/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.math.MathProcessor;
import org.mvel2.util.ParseTools;

public class OperativeAssign
extends ASTNode {
    private String varName;
    private ExecutableStatement statement;
    private final int operation;
    private int knownInType = -1;

    public OperativeAssign(String variableName, char[] expr, int start, int offset, int operation, int fields, ParserContext pCtx) {
        super(pCtx);
        this.varName = variableName;
        this.operation = operation;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if ((fields & 0x10) != 0) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
            this.egressType = this.statement.getKnownEgressType();
            if (pCtx.isStrongTyping()) {
                this.knownInType = ParseTools.__resolveType(this.egressType);
            }
            if (!pCtx.hasVarOrInput(this.varName)) {
                pCtx.addInput(this.varName, this.egressType);
            }
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getVariableResolver(this.varName);
        ctx = this.checkAssignVariable(ctx, this.varName, MathProcessor.doOperations(resolver.getValue(), this.operation, this.knownInType, this.statement.getValue(ctx, thisValue, factory)));
        resolver.setValue(ctx);
        return ctx;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getVariableResolver(this.varName);
        ctx = this.checkAssignVariable(ctx, this.varName, MathProcessor.doOperations(resolver.getValue(), this.operation, MVEL.eval(this.expr, this.start, this.offset, ctx, factory)));
        resolver.setValue(ctx);
        return ctx;
    }
}

