/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.execution;

import java.util.ArrayList;
import java.util.Collection;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionObject;

public class ExecutionArrayList<E>
extends ArrayList<E>
implements ExecutionObject {
    private final ExecutionContext executionContext;
    private final int id;
    private long memorySize = 0L;

    public ExecutionArrayList(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.id = executionContext.nextId();
    }

    public ExecutionArrayList(Collection<? extends E> c, ExecutionContext executionContext) {
        super(c);
        this.executionContext = executionContext;
        this.id = executionContext.nextId();
        for (int i = 0; i < this.size(); ++i) {
            Object val = this.get(i);
            this.memorySize += this.executionContext.onValAdd(this, i, val);
        }
    }

    public boolean push(E e) {
        return this.add(e);
    }

    public E pop() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.remove(size - 1);
    }

    public E shift() {
        return this.remove(0);
    }

    public void unshift(E e) {
        this.add(0, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean res = super.addAll(c);
        int i = c.size();
        for (E val : c) {
            this.memorySize += this.executionContext.onValAdd(this, i++, val);
        }
        return res;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean res = super.addAll(index, c);
        int i = index;
        for (E val : c) {
            this.memorySize += this.executionContext.onValAdd(this, i++, val);
        }
        return res;
    }

    @Override
    public void add(int index, E e) {
        super.add(index, e);
        this.memorySize += this.executionContext.onValAdd(this, index, e);
    }

    @Override
    public boolean add(E e) {
        boolean res = super.add(e);
        this.memorySize += this.executionContext.onValAdd(this, this.size() - 1, e);
        return res;
    }

    @Override
    public E remove(int index) {
        Object value = super.remove(index);
        this.memorySize -= this.executionContext.onValRemove(this, index, value);
        return value;
    }

    @Override
    public E set(int index, E element) {
        E oldValue = super.set(index, element);
        this.memorySize -= this.executionContext.onValRemove(this, index, oldValue);
        this.memorySize += this.executionContext.onValAdd(this, index, element);
        return oldValue;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long memorySize() {
        return this.memorySize;
    }

    @Override
    public String toString() {
        String res = super.toString();
        return "(id=" + this.id + ") " + res;
    }
}

