/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.execution;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionLinkedHashSet;
import org.mvel2.execution.ExecutionObject;

public class ExecutionCollections {
    public static <T> Collection<T> unmodifiableExecutionCollection(Collection<? extends T> c, ExecutionContext executionContext) {
        if (c.getClass() == UnmodifiableExecutionCollection.class) {
            return c;
        }
        return new UnmodifiableExecutionCollection<T>(c, executionContext);
    }

    public static <T> Set<T> unmodifiableExecutionSet(Set<? extends T> s, ExecutionContext executionContext) {
        if (s.getClass() == UnmodifiableExecutionSet.class) {
            return s;
        }
        return new UnmodifiableExecutionSet<T>(s, executionContext);
    }

    public static <T> List<T> unmodifiableExecutionList(List<? extends T> list, ExecutionContext executionContext) {
        if (list.getClass() == UnmodifiableExecutionList.class) {
            return list;
        }
        return new UnmodifiableExecutionList<T>(list, executionContext);
    }

    public static <K, V> Map<K, V> unmodifiableExecutionMap(Map<? extends K, ? extends V> m, ExecutionContext executionContext) {
        if (m.getClass() == UnmodifiableExecutionMap.class) {
            return m;
        }
        return new UnmodifiableExecutionMap<K, V>(m, executionContext);
    }

    static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static class UnmodifiableExecutionCollection<E>
    implements Collection<E>,
    ExecutionObject,
    Serializable {
        private static final long serialVersionUID = 7492637697370124347L;
        final Collection<? extends E> c;
        protected final ExecutionContext executionContext;

        UnmodifiableExecutionCollection(Collection<? extends E> c, ExecutionContext executionContext) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (!(c instanceof ExecutionObject)) {
                throw new IllegalArgumentException("Collection is not ExecutionObject");
            }
            this.executionContext = executionContext;
            this.c = c;
        }

        protected String collectionTitle() {
            return "Collection";
        }

        protected UnsupportedOperationException unmodifiableException() {
            return new UnsupportedOperationException(this.collectionTitle() + " is unmodifiable");
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> f) {
            return this.c.toArray(f);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw this.unmodifiableException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw this.unmodifiableException();
        }

        @Override
        public boolean remove(Object o) {
            throw this.unmodifiableException();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.c.containsAll(coll);
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw this.unmodifiableException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw this.unmodifiableException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw this.unmodifiableException();
        }

        @Override
        public void clear() {
            throw this.unmodifiableException();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.c.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw this.unmodifiableException();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }

        @Override
        public long memorySize() {
            return ((ExecutionObject)((Object)this.c)).memorySize();
        }
    }

    static class UnmodifiableExecutionSet<E>
    extends UnmodifiableExecutionCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        private static <T> Set<? extends T> checkExecutionSet(Set<? extends T> s, ExecutionContext executionContext) {
            if (!(s instanceof ExecutionContext)) {
                s = new ExecutionLinkedHashSet<T>(s, executionContext);
            }
            return s;
        }

        UnmodifiableExecutionSet(Set<? extends E> s, ExecutionContext executionContext) {
            super(UnmodifiableExecutionSet.checkExecutionSet(s, executionContext), executionContext);
        }

        @Override
        protected String collectionTitle() {
            return "Set";
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableExecutionList<E>
    extends UnmodifiableExecutionCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -1845512461523656905L;
        final List<? extends E> list;

        UnmodifiableExecutionList(List<? extends E> list, ExecutionContext executionContext) {
            super(list, executionContext);
            this.list = list;
        }

        @Override
        protected String collectionTitle() {
            return "List";
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public E set(int index, E element) {
            throw this.unmodifiableException();
        }

        @Override
        public void add(int index, E element) {
            throw this.unmodifiableException();
        }

        @Override
        public E remove(int index) {
            throw this.unmodifiableException();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw this.unmodifiableException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw this.unmodifiableException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw this.unmodifiableException();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = list.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw this.unmodifiableException();
                }

                @Override
                public void set(E e) {
                    throw this.unmodifiableException();
                }

                @Override
                public void add(E e) {
                    throw this.unmodifiableException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableExecutionList<E>(this.list.subList(fromIndex, toIndex), this.executionContext);
        }
    }

    private static class UnmodifiableExecutionMap<K, V>
    implements Map<K, V>,
    ExecutionObject,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        final Map<? extends K, ? extends V> m;
        protected final ExecutionContext executionContext;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        UnmodifiableExecutionMap(Map<? extends K, ? extends V> m, ExecutionContext executionContext) {
            if (m == null) {
                throw new NullPointerException();
            }
            if (!(m instanceof ExecutionObject)) {
                throw new IllegalArgumentException("Map is not an ExecutionObject");
            }
            this.executionContext = executionContext;
            this.m = m;
        }

        protected String collectionTitle() {
            return "Map";
        }

        protected UnsupportedOperationException unmodifiableException() {
            return new UnsupportedOperationException(this.collectionTitle() + " is unmodifiable");
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object val) {
            return this.m.containsValue(val);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw this.unmodifiableException();
        }

        @Override
        public V remove(Object key) {
            throw this.unmodifiableException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw this.unmodifiableException();
        }

        @Override
        public void clear() {
            throw this.unmodifiableException();
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableExecutionEntrySet<K, V>(this.m.entrySet(), this.executionContext);
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = ExecutionCollections.unmodifiableExecutionCollection(this.m.values(), this.executionContext);
            }
            return this.values;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.m.equals(o);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V getOrDefault(Object k, V defaultValue) {
            return this.m.getOrDefault(k, defaultValue);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.m.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw this.unmodifiableException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw this.unmodifiableException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw this.unmodifiableException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw this.unmodifiableException();
        }

        @Override
        public V replace(K key, V value) {
            throw this.unmodifiableException();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw this.unmodifiableException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw this.unmodifiableException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw this.unmodifiableException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw this.unmodifiableException();
        }

        @Override
        public long memorySize() {
            return ((ExecutionObject)((Object)this.m)).memorySize();
        }

        static class UnmodifiableExecutionEntrySet<K, V>
        extends UnmodifiableExecutionSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableExecutionEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> s, ExecutionContext executionContext) {
                super(s, executionContext);
            }

            @Override
            protected String collectionTitle() {
                return "EntrySet";
            }

            static <K, V> Consumer<Map.Entry<? extends K, ? extends V>> entryConsumer(Consumer<? super Map.Entry<K, V>> action) {
                return e -> action.accept(new UnmodifiableEntry(e));
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                Objects.requireNonNull(action);
                this.c.forEach(UnmodifiableExecutionEntrySet.entryConsumer(action));
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return new UnmodifiableEntrySetSpliterator(this.c.spliterator());
            }

            @Override
            public Stream<Map.Entry<K, V>> stream() {
                return StreamSupport.stream(this.spliterator(), false);
            }

            @Override
            public Stream<Map.Entry<K, V>> parallelStream() {
                return StreamSupport.stream(this.spliterator(), true);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                    {
                        this.i = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableEntry(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw this.unmodifiableException();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        Objects.requireNonNull(action);
                        this.i.forEachRemaining(UnmodifiableExecutionEntrySet.entryConsumer(action));
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] a = this.c.toArray();
                for (int i = 0; i < a.length; ++i) {
                    a[i] = new UnmodifiableEntry((Map.Entry)a[i]);
                }
                return a;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                T[] arr = this.c.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = new UnmodifiableEntry((Map.Entry)arr[i]);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)o));
            }

            @Override
            public boolean containsAll(Collection<?> coll) {
                for (Object e : coll) {
                    if (this.contains(e)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object o) {
                Set s;
                if (o == this) {
                    return true;
                }
                return o instanceof Set && (s = (Set)o).size() == this.c.size() && this.containsAll(s);
            }

            static final class UnmodifiableEntrySetSpliterator<K, V>
            implements Spliterator<Map.Entry<K, V>> {
                final Spliterator<Map.Entry<K, V>> s;

                UnmodifiableEntrySetSpliterator(Spliterator<Map.Entry<K, V>> s) {
                    this.s = s;
                }

                @Override
                public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
                    Objects.requireNonNull(action);
                    return this.s.tryAdvance(UnmodifiableExecutionEntrySet.entryConsumer(action));
                }

                @Override
                public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                    Objects.requireNonNull(action);
                    this.s.forEachRemaining(UnmodifiableExecutionEntrySet.entryConsumer(action));
                }

                @Override
                public Spliterator<Map.Entry<K, V>> trySplit() {
                    Spliterator<Map.Entry<K, V>> split = this.s.trySplit();
                    return split == null ? null : new UnmodifiableEntrySetSpliterator<K, V>(split);
                }

                @Override
                public long estimateSize() {
                    return this.s.estimateSize();
                }

                @Override
                public long getExactSizeIfKnown() {
                    return this.s.getExactSizeIfKnown();
                }

                @Override
                public int characteristics() {
                    return this.s.characteristics();
                }

                @Override
                public boolean hasCharacteristics(int characteristics) {
                    return this.s.hasCharacteristics(characteristics);
                }

                @Override
                public Comparator<? super Map.Entry<K, V>> getComparator() {
                    return this.s.getComparator();
                }
            }

            private static class UnmodifiableEntry<K, V>
            implements Map.Entry<K, V>,
            ExecutionObject {
                private Map.Entry<? extends K, ? extends V> e;

                UnmodifiableEntry(Map.Entry<? extends K, ? extends V> e) {
                    this.e = Objects.requireNonNull(e);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException("Entry is not modifiable");
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (!(o instanceof Map.Entry)) return false;
                    Map.Entry t = (Map.Entry)o;
                    if (!ExecutionCollections.eq(this.e.getKey(), t.getKey())) return false;
                    if (!ExecutionCollections.eq(this.e.getValue(), t.getValue())) return false;
                    return true;
                }

                public String toString() {
                    return this.e.toString();
                }

                @Override
                public long memorySize() {
                    return 4L;
                }
            }
        }
    }
}

