/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.execution;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionCollections;
import org.mvel2.execution.ExecutionEntry;
import org.mvel2.execution.ExecutionLinkedHashSet;
import org.mvel2.execution.ExecutionObject;
import org.mvel2.util.ArrayTools;

public class ExecutionHashMap<K, V>
extends LinkedHashMap<K, V>
implements ExecutionObject,
Iterable<Map.Entry<K, V>> {
    private static final Comparator COMP_BY_VALUE_STRING_ASC = (o1, o2) -> {
        String first = String.valueOf(((Map.Entry)o1).getValue());
        String second = String.valueOf(((Map.Entry)o2).getValue());
        return first.compareTo(second);
    };
    private static final Comparator COMP_BY_VALUE_STRING_DESC = (o1, o2) -> {
        String first = String.valueOf(((Map.Entry)o1).getValue());
        String second = String.valueOf(((Map.Entry)o2).getValue());
        return second.compareTo(first);
    };
    private static final Comparator COMP_BY_VALUE_DOUBLE_ASC = (o1, o2) -> {
        Double first = Double.parseDouble(String.valueOf(((Map.Entry)o1).getValue()));
        Double second = Double.parseDouble(String.valueOf(((Map.Entry)o2).getValue()));
        return first.compareTo(second);
    };
    private static final Comparator COMP_BY_VALUE_DOUBLE_DESC = (o1, o2) -> {
        Double first = Double.parseDouble(String.valueOf(((Map.Entry)o1).getValue()));
        Double second = Double.parseDouble(String.valueOf(((Map.Entry)o2).getValue()));
        return second.compareTo(first);
    };
    private final ExecutionContext executionContext;
    private long memorySize = 0L;

    public ExecutionHashMap(int size, ExecutionContext executionContext) {
        super(size);
        this.executionContext = executionContext;
    }

    public ExecutionHashMap(Map<K, V> map, ExecutionContext executionContext) {
        super(map.size());
        this.executionContext = executionContext;
        this.putAll(map);
    }

    @Override
    public V put(K key, V value) {
        Object res;
        if (this.containsKey(key)) {
            Object prevValue = this.get(key);
            this.memorySize -= this.executionContext.onValRemove(this, key, prevValue);
        }
        if (value != null) {
            res = super.put(key, value);
            this.memorySize += this.executionContext.onValAdd(this, key, value);
        } else {
            res = super.remove(key);
        }
        return res;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ExecutionLinkedHashSet<Map.Entry<K, V>> executionEntries = new ExecutionLinkedHashSet<Map.Entry<K, V>>(this.executionContext);
        for (Map.Entry entry : super.entrySet()) {
            executionEntries.add(new ExecutionEntry(entry.getKey(), entry.getValue()));
        }
        return executionEntries;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        for (Map.Entry<K, V> val : m.entrySet()) {
            this.memorySize += this.executionContext.onValAdd(this, val.getKey(), val.getValue());
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!super.containsKey(key)) {
            this.memorySize += this.executionContext.onValAdd(this, key, value);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result = super.replace(key, oldValue, newValue);
        if (result) {
            this.memorySize -= this.executionContext.onValRemove(this, key, oldValue);
            this.memorySize += this.executionContext.onValAdd(this, key, newValue);
        }
        return result;
    }

    @Override
    public V replace(K key, V value) {
        this.memorySize += this.executionContext.onValAdd(this, key, value);
        return super.replace(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.containsKey(key)) {
            Object value = this.get(key);
            this.memorySize -= this.executionContext.onValRemove(this, key, value);
        }
        return super.remove(key);
    }

    public Map<K, V> toUnmodifiable() {
        return ExecutionCollections.unmodifiableExecutionMap(this, this.executionContext);
    }

    @Override
    public long memorySize() {
        return this.memorySize;
    }

    @Override
    public ExecutionArrayList<V> values() {
        return new ExecutionArrayList(super.values(), this.executionContext);
    }

    public ExecutionArrayList<K> keys() {
        return new ExecutionArrayList(super.keySet(), this.executionContext);
    }

    public ExecutionHashMap<K, V> slice() {
        return new ExecutionHashMap<K, V>(this, this.executionContext);
    }

    @Override
    public ExecutionHashMap<K, V> clone() {
        return this.slice();
    }

    public ExecutionHashMap<K, V> slice(int start) {
        return this.slice(start, this.size());
    }

    public ExecutionHashMap<K, V> slice(int start, int end) {
        ExecutionArrayList<K> keys = this.keys();
        start = ArrayTools.initStartIndex(start, keys);
        end = ArrayTools.initEndIndex(end, keys);
        ExecutionHashMap<K, V> mapSlice = new ExecutionHashMap<K, V>(end - start, this.executionContext);
        int index = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (index >= start && index < end) {
                mapSlice.put(entry.getKey(), entry.getValue());
            }
            if (++index < end) continue;
            break;
        }
        return mapSlice;
    }

    public void sortByValue() {
        this.sortByValue(true);
    }

    public void sortByValue(boolean asc) {
        Map<K, V> valueSort = this.sortMapByValue((HashMap)super.clone(), asc);
        this.clearAllPutAll(valueSort);
    }

    public void sortByKey() {
        this.sortByKey(true);
    }

    public void sortByKey(boolean asc) {
        ExecutionArrayList<K> keys = this.keys();
        keys.sort(asc);
        LinkedHashMap keysMapSort = new LinkedHashMap();
        keys.forEach((Consumer<K>)((Consumer<Object>)k -> keysMapSort.put(k, this.get(k))));
        this.clearAllPutAll(keysMapSort);
    }

    public ExecutionHashMap<K, V> toSortedByValue() {
        return this.toSortedByValue(true);
    }

    public ExecutionHashMap<K, V> toSortedByValue(boolean asc) {
        Map<K, V> valueToSorted = this.sortMapByValue((HashMap)super.clone(), asc);
        return new ExecutionHashMap<K, V>(valueToSorted, this.executionContext);
    }

    public ExecutionHashMap<K, V> toSorted() {
        return this.toSorted(true);
    }

    public ExecutionHashMap<K, V> toSorted(boolean asc) {
        return this.toSortedByKey(asc);
    }

    public ExecutionHashMap<K, V> toSortedByKey() {
        return this.toSortedByKey(true);
    }

    public ExecutionHashMap<K, V> toSortedByKey(boolean asc) {
        ExecutionArrayList<K> keysToSorted = this.keys();
        keysToSorted.sort(asc);
        ExecutionHashMap<K, V> mapToSortedByKey = new ExecutionHashMap<K, V>(this.size(), this.executionContext);
        keysToSorted.forEach((Consumer<K>)((Consumer<Object>)k -> mapToSortedByKey.put(k, this.get(k))));
        return mapToSortedByKey;
    }

    public void invert() {
        ExecutionHashMap<K, V> mapInvert = this.invertMap();
        this.clear();
        this.putAll(mapInvert);
    }

    public ExecutionHashMap<K, V> toInverted() {
        return this.invertMap();
    }

    public void reverse() {
        this.clearAllPutAll(this.reversByKeys());
    }

    public ExecutionHashMap<K, V> toReversed() {
        return new ExecutionHashMap<K, V>(this.reversByKeys(), this.executionContext);
    }

    private <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map, boolean asc) {
        Comparator cmp = ((ExecutionArrayList)this.values()).validateClazzInArrayIsOnlyNumber() ? (asc ? COMP_BY_VALUE_DOUBLE_ASC : COMP_BY_VALUE_DOUBLE_DESC) : (asc ? COMP_BY_VALUE_STRING_ASC : COMP_BY_VALUE_STRING_DESC);
        return map.entrySet().stream().sorted(cmp).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private void clearAllPutAll(Map<? extends K, ? extends V> m) {
        if (this.size() != m.size()) {
            throw new IllegalArgumentException("Input map.size() is not equal to this.size()!");
        }
        super.clear();
        super.putAll(m);
    }

    private HashMap reversByKeys() {
        ExecutionArrayList<K> keys = this.keys();
        keys.reverse();
        LinkedHashMap keysMapRevers = new LinkedHashMap();
        keys.forEach((Consumer<K>)((Consumer<Object>)k -> keysMapRevers.put(k, this.get(k))));
        return keysMapRevers;
    }

    private ExecutionHashMap<K, V> invertMap() {
        Object mapClone = this.clone();
        LinkedHashMap mapInvert = new LinkedHashMap();
        HashMap valueCount = new HashMap();
        mapClone.values().forEach((? super T value) -> valueCount.put(value.toString(), valueCount.getOrDefault(value, 0) + 1));
        mapClone.forEach((? super K key, ? super V value) -> {
            if ((Integer)valueCount.get(value.toString()) == 1) {
                mapInvert.put(value, key);
            } else {
                if (mapInvert.get(value) == null) {
                    mapInvert.computeIfAbsent(value, k -> new ExecutionArrayList(this.executionContext));
                }
                ((ExecutionArrayList)mapInvert.get(value)).add(key);
            }
        });
        return new ExecutionHashMap(mapInvert, this.executionContext);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }
}

