/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionCollections;
import org.mvel2.execution.ExecutionObject;
import org.mvel2.util.ArrayTools;

public class ExecutionArrayList<E>
extends ArrayList<E>
implements ExecutionObject {
    private static final Comparator STRING_COMP_DESC = (o1, o2) -> {
        String first = String.valueOf(o1);
        String second = String.valueOf(o2);
        return second.compareTo(first);
    };
    private static final Comparator STRING_COMP_ASC = (o1, o2) -> {
        String first = String.valueOf(o1);
        String second = String.valueOf(o2);
        return first.compareTo(second);
    };
    private static final Comparator NUMERIC_COMP_ASC = (o1, o2) -> {
        Double first = Double.parseDouble(String.valueOf(o1));
        Double second = Double.parseDouble(String.valueOf(o2));
        return first.compareTo(second);
    };
    private static final Comparator NUMERIC_COMP_DESC = (o1, o2) -> {
        Double first = Double.parseDouble(String.valueOf(o1));
        Double second = Double.parseDouble(String.valueOf(o2));
        return second.compareTo(first);
    };
    private final ExecutionContext executionContext;
    private long memorySize = 0L;

    public ExecutionArrayList(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public ExecutionArrayList(Collection<? extends E> c, ExecutionContext executionContext) {
        super(c);
        this.executionContext = executionContext;
        for (int i = 0; i < this.size(); ++i) {
            Object val = this.get(i);
            this.memorySize += this.executionContext.onValAdd(this, i, val);
        }
    }

    public boolean push(E e) {
        return this.add(e);
    }

    public E pop() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.remove(size - 1);
    }

    public E shift() {
        return this.remove(0);
    }

    public void unshift(E ... ee) {
        if (ee.length > 0) {
            for (int i = 0; i < ee.length; ++i) {
                this.add(i, ee[i]);
            }
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean res = super.addAll(c);
        int i = c.size();
        for (E val : c) {
            this.memorySize += this.executionContext.onValAdd(this, i++, val);
        }
        return res;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean res = super.addAll(index, c);
        int i = index;
        for (E val : c) {
            this.memorySize += this.executionContext.onValAdd(this, i++, val);
        }
        return res;
    }

    @Override
    public void add(int index, E e) {
        super.add(index, e);
        this.memorySize += this.executionContext.onValAdd(this, index, e);
    }

    @Override
    public boolean add(E e) {
        boolean res = super.add(e);
        this.memorySize += this.executionContext.onValAdd(this, this.size() - 1, e);
        return res;
    }

    @Override
    public E remove(int index) {
        Object value = super.remove(index);
        this.memorySize -= this.executionContext.onValRemove(this, index, value);
        return value;
    }

    @Override
    public boolean remove(Object value) {
        int index = super.indexOf(value);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        E oldValue = super.set(index, element);
        this.memorySize -= this.executionContext.onValRemove(this, index, oldValue);
        this.memorySize += this.executionContext.onValAdd(this, index, element);
        return oldValue;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List list = super.subList(fromIndex, toIndex);
        return new ExecutionArrayList(list, this.executionContext);
    }

    public ExecutionArrayList<E> slice() {
        return new ExecutionArrayList<E>(this, this.executionContext);
    }

    public ExecutionArrayList<E> slice(int start) {
        return this.slice(start, this.size());
    }

    public ExecutionArrayList<E> slice(int start, int end) {
        start = ArrayTools.initStartIndex(start, this);
        end = ArrayTools.initEndIndex(end, this);
        return new ExecutionArrayList<E>(this.subList(start, end), this.executionContext);
    }

    public int length() {
        return this.size();
    }

    public List<E> toUnmodifiable() {
        return ExecutionCollections.unmodifiableExecutionList(this, this.executionContext);
    }

    @Override
    public long memorySize() {
        return this.memorySize;
    }

    public int indexOf(Object o, int fromIndex) {
        int index = this.slice(fromIndex).indexOf(o);
        return index == -1 ? index : index + fromIndex;
    }

    public String join() {
        return this.join(",");
    }

    public String join(String separator) {
        String strJoin = this.stream().map(Object::toString).collect(Collectors.joining(separator));
        return strJoin.replaceAll(", ", ",").replaceAll("\\[", "").replaceAll("]", "");
    }

    public void sort() {
        this.sort(true);
    }

    public void sort(boolean asc) {
        if (this.validateClazzInArrayIsOnlyNumber()) {
            super.sort(asc ? NUMERIC_COMP_ASC : NUMERIC_COMP_DESC);
        } else {
            super.sort(asc ? STRING_COMP_ASC : STRING_COMP_DESC);
        }
    }

    public ExecutionArrayList<E> toSorted() {
        return this.toSorted(true);
    }

    public ExecutionArrayList<E> toSorted(boolean asc) {
        ExecutionArrayList<E> newList = this.slice();
        newList.sort(asc);
        return newList;
    }

    public void reverse() {
        Collections.reverse(this);
    }

    public List toReversed() {
        ExecutionArrayList<E> newList = this.slice();
        newList.reverse();
        return newList;
    }

    public List concat(Collection c) {
        ExecutionArrayList<E> newList = this.slice();
        newList.addAll(c);
        return newList;
    }

    public List splice(int start) {
        return this.splice(start, this.size() - start, new Object[0]);
    }

    public List splice(int start, int deleteCount, E ... values) {
        start = ArrayTools.initStartIndex(start, this);
        ArrayList<E> removed = new ArrayList<E>();
        for (deleteCount = deleteCount < 0 ? 0 : Math.min(deleteCount, this.size() - start); deleteCount > 0; --deleteCount) {
            removed.add(this.remove(start));
        }
        int insertIdx = start;
        for (E e : values) {
            this.add(insertIdx++, e);
        }
        return new ExecutionArrayList(removed, this.executionContext);
    }

    public List toSpliced(int start) {
        ExecutionArrayList<E> newList = this.slice();
        newList.splice(start);
        return newList;
    }

    public List toSpliced(int start, int deleteCount, E ... values) {
        ExecutionArrayList<E> newList = this.slice();
        newList.splice(start, deleteCount, values);
        return newList;
    }

    public List with(int index, E value) {
        int parseIndex;
        int n = parseIndex = index < 0 ? index + this.size() : index;
        if (parseIndex >= this.size() || parseIndex < 0) {
            throw new IllegalArgumentException("Index: " + index + ", Size: " + this.size());
        }
        ExecutionArrayList<Object> newList = this.slice();
        newList.splice(parseIndex, 0, value);
        return newList;
    }

    public List fill(E value) {
        return this.fill(value, 0);
    }

    public List fill(E value, int start) {
        return this.fill(value, start, this.size());
    }

    public List fill(E value, int start, int end) {
        start = ArrayTools.initStartIndex(start, this);
        end = ArrayTools.initEndIndex(end, this);
        if (start < this.size() && end > start) {
            for (int i = start; i < end; ++i) {
                super.set(i, value);
            }
        }
        return this;
    }

    public boolean validateClazzInArrayIsOnlyNumber() {
        return !super.stream().anyMatch(e -> !this.validateClazzInArrayIsOnlyNumber(e));
    }

    public boolean validateClazzInArrayIsOnlyNumber(Object e) {
        try {
            Double.parseDouble(String.valueOf(e));
            return true;
        }
        catch (Exception e1) {
            return false;
        }
    }
}

