/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.execution;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionCollections;
import org.mvel2.execution.ExecutionObject;

public class ExecutionLinkedHashSet<E>
extends LinkedHashSet<E>
implements ExecutionObject {
    private final ExecutionContext executionContext;
    private long memorySize = 0L;

    public ExecutionLinkedHashSet(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public ExecutionLinkedHashSet(Set<? extends E> s, ExecutionContext executionContext) {
        super(Math.max(2 * s.size(), 11), 0.75f);
        this.executionContext = executionContext;
        this.addAll(s);
    }

    @Override
    public boolean add(E e) {
        if (super.add(e)) {
            this.memorySize += this.executionContext.onValAdd(this, e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.memorySize -= this.executionContext.onValRemove(this, o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (Object val : this) {
            this.executionContext.onValRemove(this, val);
        }
        super.clear();
        this.memorySize = 0L;
    }

    public void sort() {
        this.sort(true);
    }

    public void sort(boolean asc) {
        ExecutionArrayList<E> list = this.toList();
        list.sort(asc);
        this.clear();
        this.addAll(list);
    }

    public ExecutionLinkedHashSet<E> toSorted() {
        return this.toSorted(true);
    }

    public ExecutionLinkedHashSet<E> toSorted(boolean asc) {
        ExecutionArrayList<E> list = this.toList();
        list.sort(asc);
        LinkedHashSet<E> newSet = new LinkedHashSet<E>(list);
        return new ExecutionLinkedHashSet<E>(newSet, this.executionContext);
    }

    public ExecutionArrayList<E> toList() {
        return new ExecutionArrayList<Object>(Arrays.asList(this.toArray()), this.executionContext);
    }

    @Override
    public long memorySize() {
        return this.memorySize;
    }

    public Set<E> toUnmodifiable() {
        return ExecutionCollections.unmodifiableExecutionSet(this, this.executionContext);
    }
}

