/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;

public final class Temporals {
    private Temporals() {
    }

    public static TemporalAdjuster nextWorkingDay() {
        return Adjuster.NEXT_WORKING;
    }

    public static TemporalAdjuster previousWorkingDay() {
        return Adjuster.PREVIOUS_WORKING;
    }

    private static enum Adjuster implements TemporalAdjuster
    {
        NEXT_WORKING{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 6: {
                        return temporal.plus(2L, ChronoUnit.DAYS);
                    }
                    case 5: {
                        return temporal.plus(3L, ChronoUnit.DAYS);
                    }
                }
                return temporal.plus(1L, ChronoUnit.DAYS);
            }
        }
        ,
        PREVIOUS_WORKING{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 1: {
                        return temporal.minus(3L, ChronoUnit.DAYS);
                    }
                    case 7: {
                        return temporal.minus(2L, ChronoUnit.DAYS);
                    }
                }
                return temporal.minus(1L, ChronoUnit.DAYS);
            }
        };

    }
}

