/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import org.threeten.extra.chrono.CopticChronology;
import org.threeten.extra.chrono.CopticEra;

public final class CopticDate
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -7920528871688876868L;
    private static final int EPOCH_DAY_DIFFERENCE = 615558;
    private final int prolepticYear;
    private final short month;
    private final short day;

    public static CopticDate now() {
        return CopticDate.now(Clock.systemDefaultZone());
    }

    public static CopticDate now(ZoneId zone) {
        return CopticDate.now(Clock.system(zone));
    }

    public static CopticDate now(Clock clock) {
        LocalDate now = LocalDate.now(clock);
        return CopticDate.ofEpochDay(now.toEpochDay());
    }

    public static CopticDate of(int prolepticYear, int month, int dayOfMonth) {
        return CopticDate.create(prolepticYear, month, dayOfMonth);
    }

    public static CopticDate from(TemporalAccessor temporal) {
        if (temporal instanceof CopticDate) {
            return (CopticDate)temporal;
        }
        return CopticDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
    }

    static CopticDate ofYearDay(int prolepticYear, int dayOfYear) {
        CopticChronology.YEAR_RANGE.checkValidValue(prolepticYear, ChronoField.YEAR);
        ChronoField.DAY_OF_YEAR.range().checkValidValue(dayOfYear, ChronoField.DAY_OF_YEAR);
        if (dayOfYear == 366 && !CopticChronology.INSTANCE.isLeapYear(prolepticYear)) {
            throw new DateTimeException("Invalid date 'Nasi 6' as '" + prolepticYear + "' is not a leap year");
        }
        return new CopticDate(prolepticYear, (dayOfYear - 1) / 30 + 1, (dayOfYear - 1) % 30 + 1);
    }

    static CopticDate ofEpochDay(long epochDay) {
        ChronoField.EPOCH_DAY.range().checkValidValue(epochDay, ChronoField.EPOCH_DAY);
        long copticED = epochDay + 615558L;
        int adjustment = 0;
        if (copticED < 0L) {
            copticED += 365250000L;
            adjustment = -1000000;
        }
        int prolepticYear = (int)((copticED * 4L + 1463L) / 1461L);
        int startYearEpochDay = (prolepticYear - 1) * 365 + prolepticYear / 4;
        int doy0 = (int)(copticED - (long)startYearEpochDay);
        int month = doy0 / 30 + 1;
        int dom = doy0 % 30 + 1;
        return new CopticDate(prolepticYear + adjustment, month, dom);
    }

    private static CopticDate resolvePreviousValid(int prolepticYear, int month, int day) {
        if (month == 13 && day > 5) {
            day = CopticChronology.INSTANCE.isLeapYear(prolepticYear) ? 6 : 5;
        }
        return new CopticDate(prolepticYear, month, day);
    }

    static CopticDate create(int prolepticYear, int month, int dayOfMonth) {
        CopticChronology.YEAR_RANGE.checkValidValue(prolepticYear, ChronoField.YEAR);
        CopticChronology.MOY_RANGE.checkValidValue(month, ChronoField.MONTH_OF_YEAR);
        CopticChronology.DOM_RANGE.checkValidValue(dayOfMonth, ChronoField.DAY_OF_MONTH);
        if (month == 13 && dayOfMonth > 5) {
            if (CopticChronology.INSTANCE.isLeapYear(prolepticYear)) {
                if (dayOfMonth > 6) {
                    throw new DateTimeException("Invalid date 'Nasi " + dayOfMonth + "', valid range from 1 to 5, or 1 to 6 in a leap year");
                }
            } else {
                if (dayOfMonth == 6) {
                    throw new DateTimeException("Invalid date 'Nasi 6' as '" + prolepticYear + "' is not a leap year");
                }
                throw new DateTimeException("Invalid date 'Nasi " + dayOfMonth + "', valid range from 1 to 5, or 1 to 6 in a leap year");
            }
        }
        return new CopticDate(prolepticYear, month, dayOfMonth);
    }

    private CopticDate(int prolepticYear, int month, int dayOfMonth) {
        this.prolepticYear = prolepticYear;
        this.month = (short)month;
        this.day = (short)dayOfMonth;
    }

    private Object readResolve() {
        return CopticDate.create(this.prolepticYear, this.month, this.day);
    }

    @Override
    public CopticChronology getChronology() {
        return CopticChronology.INSTANCE;
    }

    @Override
    public CopticEra getEra() {
        return this.prolepticYear >= 1 ? CopticEra.AM : CopticEra.BEFORE_AM;
    }

    @Override
    public int lengthOfMonth() {
        if (this.month == 13) {
            return this.isLeapYear() ? 6 : 5;
        }
        return 30;
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                ChronoField f = (ChronoField)field;
                switch (f) {
                    case DAY_OF_MONTH: {
                        return ValueRange.of(1L, this.lengthOfMonth());
                    }
                    case DAY_OF_YEAR: {
                        return ValueRange.of(1L, this.lengthOfYear());
                    }
                    case ALIGNED_WEEK_OF_MONTH: {
                        return ValueRange.of(1L, this.month == 13 ? 1L : 5L);
                    }
                }
                return this.getChronology().range(f);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case DAY_OF_WEEK: {
                    return this.getDayOfWeek();
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return (this.day - 1) % 7 + 1;
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return (this.getDayOfYear() - 1) % 7 + 1;
                }
                case DAY_OF_MONTH: {
                    return this.day;
                }
                case DAY_OF_YEAR: {
                    return this.getDayOfYear();
                }
                case EPOCH_DAY: {
                    return this.toEpochDay();
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return (this.day - 1) / 7 + 1;
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return (this.getDayOfYear() - 1) / 7 + 1;
                }
                case MONTH_OF_YEAR: {
                    return this.month;
                }
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    return this.getYearOfEra();
                }
                case YEAR: {
                    return this.prolepticYear;
                }
                case ERA: {
                    return this.prolepticYear >= 1 ? 1 : 0;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    private int getDayOfWeek() {
        return (int)(Math.floorMod(this.toEpochDay() + 3L, 7L) + 1L);
    }

    private int getDayOfYear() {
        return (this.month - 1) * 30 + this.day;
    }

    private long getProlepticMonth() {
        return (long)this.prolepticYear * 13L + (long)this.month - 1L;
    }

    private int getYearOfEra() {
        return this.prolepticYear >= 1 ? this.prolepticYear : 1 - this.prolepticYear;
    }

    @Override
    public CopticDate with(TemporalAdjuster adjuster) {
        return (CopticDate)adjuster.adjustInto(this);
    }

    @Override
    public CopticDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            int nvalue = (int)newValue;
            switch (f) {
                case DAY_OF_WEEK: {
                    return this.plusDays(newValue - (long)this.getDayOfWeek());
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return this.plusDays(newValue - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return this.plusDays(newValue - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                }
                case DAY_OF_MONTH: {
                    return CopticDate.resolvePreviousValid(this.prolepticYear, this.month, nvalue);
                }
                case DAY_OF_YEAR: {
                    return CopticDate.resolvePreviousValid(this.prolepticYear, (nvalue - 1) / 30 + 1, (nvalue - 1) % 30 + 1);
                }
                case EPOCH_DAY: {
                    return CopticDate.ofEpochDay(newValue);
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return this.plusDays((newValue - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH)) * 7L);
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return this.plusDays((newValue - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR)) * 7L);
                }
                case MONTH_OF_YEAR: {
                    return CopticDate.resolvePreviousValid(this.prolepticYear, nvalue, this.day);
                }
                case PROLEPTIC_MONTH: {
                    return this.plusMonths(newValue - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: {
                    return CopticDate.resolvePreviousValid(this.prolepticYear >= 1 ? nvalue : 1 - nvalue, this.month, this.day);
                }
                case YEAR: {
                    return CopticDate.resolvePreviousValid(nvalue, this.month, this.day);
                }
                case ERA: {
                    return CopticDate.resolvePreviousValid(1 - this.prolepticYear, this.month, this.day);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.adjustInto(this, newValue);
    }

    @Override
    public CopticDate plus(TemporalAmount amount) {
        return (CopticDate)amount.addTo(this);
    }

    @Override
    public CopticDate plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)unit;
            switch (f) {
                case DAYS: {
                    return this.plusDays(amountToAdd);
                }
                case WEEKS: {
                    return this.plusDays(Math.multiplyExact(amountToAdd, 7L));
                }
                case MONTHS: {
                    return this.plusMonths(amountToAdd);
                }
                case YEARS: {
                    return this.plusYears(amountToAdd);
                }
                case DECADES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
                }
                case CENTURIES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
                }
                case MILLENNIA: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Math.addExact(this.getLong(ChronoField.ERA), amountToAdd));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return unit.addTo(this, amountToAdd);
    }

    private CopticDate plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        int newYear = ChronoField.YEAR.checkValidIntValue(Math.addExact((long)this.prolepticYear, yearsToAdd));
        return CopticDate.resolvePreviousValid(newYear, this.month, this.day);
    }

    private CopticDate plusMonths(long months) {
        if (months == 0L) {
            return this;
        }
        long curEm = (long)this.prolepticYear * 13L + (long)(this.month - 1);
        long calcEm = Math.addExact(curEm, months);
        int newYear = Math.toIntExact(Math.floorDiv(calcEm, 13L));
        int newMonth = (int)(Math.floorMod(calcEm, 13L) + 1L);
        return CopticDate.resolvePreviousValid(newYear, newMonth, this.day);
    }

    private CopticDate plusDays(long days) {
        if (days == 0L) {
            return this;
        }
        return CopticDate.ofEpochDay(Math.addExact(this.toEpochDay(), days));
    }

    @Override
    public CopticDate minus(TemporalAmount amount) {
        return (CopticDate)amount.subtractFrom(this);
    }

    @Override
    public CopticDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public ChronoLocalDateTime<CopticDate> atTime(LocalTime localTime) {
        return ChronoLocalDate.super.atTime(localTime);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        CopticDate end = CopticDate.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case DAYS: {
                    return this.daysUntil(end);
                }
                case WEEKS: {
                    return this.daysUntil(end) / 7L;
                }
                case MONTHS: {
                    return this.monthsUntil(end);
                }
                case YEARS: {
                    return this.monthsUntil(end) / 13L;
                }
                case DECADES: {
                    return this.monthsUntil(end) / 130L;
                }
                case CENTURIES: {
                    return this.monthsUntil(end) / 1300L;
                }
                case MILLENNIA: {
                    return this.monthsUntil(end) / 13000L;
                }
                case ERAS: {
                    return end.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return unit.between(this, end);
    }

    private long daysUntil(ChronoLocalDate end) {
        return end.toEpochDay() - this.toEpochDay();
    }

    private long monthsUntil(CopticDate end) {
        long packed1 = this.getProlepticMonth() * 32L + (long)this.day;
        long packed2 = end.getProlepticMonth() * 32L + (long)end.day;
        return (packed2 - packed1) / 32L;
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDateExclusive) {
        CopticDate end = CopticDate.from(endDateExclusive);
        long totalMonths = end.getProlepticMonth() - this.getProlepticMonth();
        int days = end.day - this.day;
        if (totalMonths > 0L && days < 0) {
            CopticDate calcDate = this.plusMonths(--totalMonths);
            days = (int)(end.toEpochDay() - calcDate.toEpochDay());
        } else if (totalMonths < 0L && days > 0) {
            ++totalMonths;
            days -= end.lengthOfMonth();
        }
        long years = totalMonths / 13L;
        int months = (int)(totalMonths % 13L);
        return this.getChronology().period(Math.toIntExact(years), months, days);
    }

    @Override
    public long toEpochDay() {
        long year = this.prolepticYear;
        long copticEpochDay = (year - 1L) * 365L + Math.floorDiv(year, 4L) + (long)(this.getDayOfYear() - 1);
        return copticEpochDay - 615558L;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CopticDate) {
            CopticDate otherDate = (CopticDate)obj;
            return this.prolepticYear == otherDate.prolepticYear && this.month == otherDate.month && this.day == otherDate.day;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ (this.prolepticYear & 0xFFFFF800 ^ (this.prolepticYear << 11) + (this.month << 6) + this.day);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(30);
        buf.append(this.getChronology().toString()).append(" ").append(this.getEra()).append(" ").append(this.getYearOfEra()).append(this.month < 10 ? "-0" : "-").append(this.month).append(this.day < 10 ? "-0" : "-").append(this.day);
        return buf.toString();
    }
}

