/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.Serializable;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Duration;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.PeriodParser;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;

public final class Period
implements TemporalAdder,
TemporalSubtractor,
Serializable {
    public static final Period ZERO = new Period(0, 0, 0, 0L);
    private static final long serialVersionUID = -8290556941213247973L;
    private final int years;
    private final int months;
    private final int days;
    private final long nanos;

    public static Period of(int years, int months, int days, int hours, int minutes, int seconds) {
        return Period.of(years, months, days, hours, minutes, seconds, 0L);
    }

    public static Period of(int years, int months, int days, int hours, int minutes, int seconds, long nanos) {
        if (((long)(years | months | days | hours | minutes | seconds) | nanos) == 0L) {
            return ZERO;
        }
        long totSecs = Jdk8Methods.safeAdd((long)hours * 3600L, (long)minutes * 60L) + (long)seconds;
        long totNanos = Jdk8Methods.safeAdd(Jdk8Methods.safeMultiply(totSecs, 1000000000L), nanos);
        return Period.create(years, months, days, totNanos);
    }

    public static Period ofDate(int years, int months, int days) {
        return Period.of(years, months, days, 0, 0, 0, 0L);
    }

    public static Period ofTime(int hours, int minutes, int seconds) {
        return Period.of(0, 0, 0, hours, minutes, seconds, 0L);
    }

    public static Period ofTime(int hours, int minutes, int seconds, long nanos) {
        return Period.of(0, 0, 0, hours, minutes, seconds, nanos);
    }

    public static Period of(long amount, TemporalUnit unit) {
        return ZERO.plus(amount, unit);
    }

    public static Period of(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        if (duration.isZero()) {
            return ZERO;
        }
        return new Period(0, 0, 0, duration.toNanos());
    }

    public static Period between(TemporalAccessor start, TemporalAccessor end) {
        if (!Chrono.from(start).equals(Chrono.from(end))) {
            throw new DateTimeException("Unable to calculate period as date-times have different chronologies");
        }
        int years = 0;
        int months = 0;
        int days = 0;
        long nanos = 0L;
        boolean valid = false;
        if (start.isSupported(ChronoField.YEAR)) {
            years = Jdk8Methods.safeToInt(Jdk8Methods.safeSubtract(end.getLong(ChronoField.YEAR), start.getLong(ChronoField.YEAR)));
            valid = true;
        }
        if (start.isSupported(ChronoField.MONTH_OF_YEAR)) {
            months = Jdk8Methods.safeToInt(Jdk8Methods.safeSubtract(end.getLong(ChronoField.MONTH_OF_YEAR), start.getLong(ChronoField.MONTH_OF_YEAR)));
            ValueRange startRange = Chrono.from(start).range(ChronoField.MONTH_OF_YEAR);
            ValueRange endRange = Chrono.from(end).range(ChronoField.MONTH_OF_YEAR);
            if (startRange.isFixed() && startRange.isIntValue() && startRange.equals(endRange)) {
                int monthCount = (int)(startRange.getMaximum() - startRange.getMinimum() + 1L);
                long totMonths = (long)months + (long)(years * monthCount);
                months = (int)(totMonths % (long)monthCount);
                years = Jdk8Methods.safeToInt(totMonths / (long)monthCount);
            }
            valid = true;
        }
        if (start.isSupported(ChronoField.DAY_OF_MONTH)) {
            days = Jdk8Methods.safeToInt(Jdk8Methods.safeSubtract(end.getLong(ChronoField.DAY_OF_MONTH), start.getLong(ChronoField.DAY_OF_MONTH)));
            valid = true;
        }
        if (start.isSupported(ChronoField.NANO_OF_DAY)) {
            nanos = Jdk8Methods.safeSubtract(end.getLong(ChronoField.NANO_OF_DAY), start.getLong(ChronoField.NANO_OF_DAY));
            valid = true;
        }
        if (!valid) {
            throw new DateTimeException("Unable to calculate period as date-times do not have any valid fields");
        }
        return Period.create(years, months, days, nanos);
    }

    public static Period betweenISO(LocalDate startDate, LocalDate endDate) {
        long startMonth = startDate.getLong(ChronoField.EPOCH_MONTH);
        long endMonth = endDate.getLong(ChronoField.EPOCH_MONTH);
        long totalMonths = endMonth - startMonth;
        int days = endDate.getDayOfMonth() - startDate.getDayOfMonth();
        if (totalMonths > 0L && days < 0) {
            LocalDate calcDate = startDate.plusMonths(--totalMonths);
            days = (int)(endDate.toEpochDay() - calcDate.toEpochDay());
        } else if (totalMonths < 0L && days > 0) {
            ++totalMonths;
            days -= endDate.lengthOfMonth();
        }
        long years = totalMonths / 12L;
        int months = (int)(totalMonths % 12L);
        return Period.ofDate(Jdk8Methods.safeToInt(years), months, days);
    }

    public static Period betweenISO(LocalTime startTime, LocalTime endTime) {
        return Period.create(0, 0, 0, endTime.toNanoOfDay() - startTime.toNanoOfDay());
    }

    public static Period parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        return new PeriodParser(text).parse();
    }

    private static Period create(int years, int months, int days, long nanos) {
        if (((long)(years | months | days) | nanos) == 0L) {
            return ZERO;
        }
        return new Period(years, months, days, nanos);
    }

    private Period(int years, int months, int days, long nanos) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.nanos = nanos;
    }

    private Object readResolve() {
        if (((long)(this.years | this.months | this.days) | this.nanos) == 0L) {
            return ZERO;
        }
        return this;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public boolean isPositive() {
        return ((long)(this.years | this.months | this.days) | this.nanos) > 0L;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return (int)(this.nanos / 3600000000000L);
    }

    public int getMinutes() {
        return (int)(this.nanos / 60000000000L % 60L);
    }

    public int getSeconds() {
        return (int)(this.nanos / 1000000000L % 60L);
    }

    public int getNanos() {
        return (int)(this.nanos % 1000000000L);
    }

    public long getTimeNanos() {
        return this.nanos;
    }

    public Period withYears(int years) {
        if (years == this.years) {
            return this;
        }
        return Period.create(years, this.months, this.days, this.nanos);
    }

    public Period withMonths(int months) {
        if (months == this.months) {
            return this;
        }
        return Period.create(this.years, months, this.days, this.nanos);
    }

    public Period withDays(int days) {
        if (days == this.days) {
            return this;
        }
        return Period.create(this.years, this.months, days, this.nanos);
    }

    public Period withTimeNanos(long nanos) {
        if (nanos == this.nanos) {
            return this;
        }
        return Period.create(this.years, this.months, this.days, nanos);
    }

    public Period plus(Period other) {
        return Period.create(Jdk8Methods.safeAdd(this.years, other.years), Jdk8Methods.safeAdd(this.months, other.months), Jdk8Methods.safeAdd(this.days, other.days), Jdk8Methods.safeAdd(this.nanos, other.nanos));
    }

    public Period plus(long amount, TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        if (unit instanceof ChronoUnit && (unit == ChronoUnit.YEARS || unit == ChronoUnit.MONTHS || unit == ChronoUnit.DAYS || !unit.isDurationEstimated())) {
            if (amount == 0L) {
                return this;
            }
            switch ((ChronoUnit)unit) {
                case NANOS: {
                    return this.plusNanos(amount);
                }
                case MICROS: {
                    return this.plusNanos(Jdk8Methods.safeMultiply(amount, 1000L));
                }
                case MILLIS: {
                    return this.plusNanos(Jdk8Methods.safeMultiply(amount, 1000000L));
                }
                case SECONDS: {
                    return this.plusSeconds(amount);
                }
                case MINUTES: {
                    return this.plusMinutes(amount);
                }
                case HOURS: {
                    return this.plusHours(amount);
                }
                case HALF_DAYS: {
                    return this.plusNanos(Jdk8Methods.safeMultiply(amount, 43200000000000L));
                }
                case DAYS: {
                    return this.plusDays(amount);
                }
                case MONTHS: {
                    return this.plusMonths(amount);
                }
                case YEARS: {
                    return this.plusYears(amount);
                }
            }
            throw new DateTimeException("Unsupported unit: " + unit.getName());
        }
        if (unit.isDurationEstimated()) {
            throw new DateTimeException("Unsupported unit: " + unit.getName());
        }
        return this.plusNanos(Duration.of(amount, unit).toNanos());
    }

    public Period plusYears(long amount) {
        return Period.create(Jdk8Methods.safeToInt(Jdk8Methods.safeAdd((long)this.years, amount)), this.months, this.days, this.nanos);
    }

    public Period plusMonths(long amount) {
        return Period.create(this.years, Jdk8Methods.safeToInt(Jdk8Methods.safeAdd((long)this.months, amount)), this.days, this.nanos);
    }

    public Period plusDays(long amount) {
        return Period.create(this.years, this.months, Jdk8Methods.safeToInt(Jdk8Methods.safeAdd((long)this.days, amount)), this.nanos);
    }

    public Period plusHours(long amount) {
        return this.plusNanos(Jdk8Methods.safeMultiply(amount, 3600000000000L));
    }

    public Period plusMinutes(long amount) {
        return this.plusNanos(Jdk8Methods.safeMultiply(amount, 60000000000L));
    }

    public Period plusSeconds(long amount) {
        return this.plusNanos(Jdk8Methods.safeMultiply(amount, 1000000000L));
    }

    public Period plusNanos(long amount) {
        return Period.create(this.years, this.months, this.days, Jdk8Methods.safeAdd(this.nanos, amount));
    }

    public Period minus(Period other) {
        return Period.create(Jdk8Methods.safeSubtract(this.years, other.years), Jdk8Methods.safeSubtract(this.months, other.months), Jdk8Methods.safeSubtract(this.days, other.days), Jdk8Methods.safeSubtract(this.nanos, other.nanos));
    }

    public Period minus(long amount, TemporalUnit unit) {
        return amount == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amount, unit);
    }

    public Period minusYears(long amount) {
        return amount == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-amount);
    }

    public Period minusMonths(long amount) {
        return amount == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-amount);
    }

    public Period minusDays(long amount) {
        return amount == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-amount);
    }

    public Period minusHours(long amount) {
        return amount == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-amount);
    }

    public Period minusMinutes(long amount) {
        return amount == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-amount);
    }

    public Period minusSeconds(long amount) {
        return amount == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-amount);
    }

    public Period minusNanos(long amount) {
        return amount == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-amount);
    }

    public Period multipliedBy(int scalar) {
        if (this == ZERO || scalar == 1) {
            return this;
        }
        return Period.create(Jdk8Methods.safeMultiply(this.years, scalar), Jdk8Methods.safeMultiply(this.months, scalar), Jdk8Methods.safeMultiply(this.days, scalar), Jdk8Methods.safeMultiply(this.nanos, scalar));
    }

    public Period negated() {
        return this.multipliedBy(-1);
    }

    public Period normalizedHoursToDays() {
        long totalDays = this.nanos / 86400000000000L + (long)this.days;
        long splitNanos = this.nanos % 86400000000000L;
        if (totalDays > 0L && splitNanos < 0L) {
            splitNanos += 86400000000000L;
            --totalDays;
        } else if (totalDays < 0L && splitNanos > 0L) {
            splitNanos -= 86400000000000L;
            ++totalDays;
        }
        if (totalDays == (long)this.days && splitNanos == this.nanos) {
            return this;
        }
        return Period.create(this.years, this.months, Jdk8Methods.safeToInt(totalDays), splitNanos);
    }

    public Period normalizedDaysToHours() {
        if (this.days == 0) {
            return this;
        }
        return Period.create(this.years, this.months, 0, Jdk8Methods.safeAdd(Jdk8Methods.safeMultiply((long)this.days, 86400000000000L), this.nanos));
    }

    public Period normalizedMonthsISO() {
        long totalMonths = (long)this.years * 12L + (long)this.months;
        long splitYears = totalMonths / 12L;
        int splitMonths = (int)(totalMonths % 12L);
        if (splitYears == (long)this.years && splitMonths == this.months) {
            return this;
        }
        return Period.create(Jdk8Methods.safeToInt(splitYears), splitMonths, this.days, this.nanos);
    }

    public Period toDateOnly() {
        if (this.nanos == 0L) {
            return this;
        }
        return Period.create(this.years, this.months, this.days, 0L);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if ((this.years | this.months) != 0) {
            ValueRange startRange = Chrono.from(temporal).range(ChronoField.MONTH_OF_YEAR);
            if (startRange.isFixed() && startRange.isIntValue()) {
                long monthCount = startRange.getMaximum() - startRange.getMinimum() + 1L;
                temporal = temporal.plus((long)this.years * monthCount + (long)this.months, ChronoUnit.MONTHS);
            } else {
                if (this.years != 0) {
                    temporal = temporal.plus(this.years, ChronoUnit.YEARS);
                }
                if (this.months != 0) {
                    temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
                }
            }
        }
        if (this.days != 0) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        if (this.nanos != 0L) {
            temporal = temporal.plus(this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if ((this.years | this.months) != 0) {
            ValueRange startRange = Chrono.from(temporal).range(ChronoField.MONTH_OF_YEAR);
            if (startRange.isFixed() && startRange.isIntValue()) {
                long monthCount = startRange.getMaximum() - startRange.getMinimum() + 1L;
                temporal = temporal.minus((long)this.years * monthCount + (long)this.months, ChronoUnit.MONTHS);
            } else {
                if (this.years != 0) {
                    temporal = temporal.minus(this.years, ChronoUnit.YEARS);
                }
                if (this.months != 0) {
                    temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
                }
            }
        }
        if (this.days != 0) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        if (this.nanos != 0L) {
            temporal = temporal.minus(this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public Period toTimeOnly() {
        if ((this.years | this.months | this.days) == 0) {
            return this;
        }
        return Period.create(0, 0, 0, this.nanos);
    }

    public Duration toDuration() {
        if ((this.years | this.months | this.days) != 0) {
            throw new DateTimeException("Unable to convert period to duration as years/months/days are present: " + this);
        }
        return Duration.ofNanos(this.nanos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Period) {
            Period other = (Period)obj;
            return this.years == other.years && this.months == other.months && this.days == other.days && this.nanos == other.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (this.years << 27 | this.years >>> 5) ^ (this.days << 21 | this.days >>> 11) ^ (this.months << 17 | this.months >>> 15) ^ (int)(this.nanos ^ this.nanos >>> 32);
    }

    public String toString() {
        if (this == ZERO) {
            return "PT0S";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('P');
        if (this.years != 0) {
            buf.append(this.years).append('Y');
        }
        if (this.months != 0) {
            buf.append(this.months).append('M');
        }
        if (this.days != 0) {
            buf.append(this.days).append('D');
        }
        if (this.nanos != 0L) {
            int nanoPart;
            int secondPart;
            int secsNanosOr;
            buf.append('T');
            if (this.getHours() != 0) {
                buf.append(this.getHours()).append('H');
            }
            if (this.getMinutes() != 0) {
                buf.append(this.getMinutes()).append('M');
            }
            if ((secsNanosOr = (secondPart = this.getSeconds()) | (nanoPart = this.getNanos())) != 0) {
                if ((secsNanosOr & Integer.MIN_VALUE) != 0) {
                    buf.append('-');
                    secondPart = Math.abs(secondPart);
                    nanoPart = Math.abs(nanoPart);
                }
                buf.append(secondPart);
                if (nanoPart != 0) {
                    int dotPos = buf.length();
                    nanoPart += 1000000000;
                    while (nanoPart % 10 == 0) {
                        nanoPart /= 10;
                    }
                    buf.append(nanoPart);
                    buf.setCharAt(dotPos, '.');
                }
                buf.append('S');
            }
        }
        return buf.toString();
    }
}

