/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.calendar;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.calendar.MinguoDate;
import org.threeten.bp.calendar.MinguoEra;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.ISOChrono;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.ValueRange;

public final class MinguoChrono
extends Chrono<MinguoChrono>
implements Serializable {
    public static final MinguoChrono INSTANCE = new MinguoChrono();
    public static final Era<MinguoChrono> ERA_ROC = MinguoEra.ROC;
    public static final Era<MinguoChrono> ERA_BEFORE_ROC = MinguoEra.BEFORE_ROC;
    private static final long serialVersionUID = 1039765215346859963L;
    static final int YEARS_DIFFERENCE = 1911;

    private MinguoChrono() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Minguo";
    }

    @Override
    public String getCalendarType() {
        return "roc";
    }

    @Override
    public ChronoLocalDate<MinguoChrono> date(int prolepticYear, int month, int dayOfMonth) {
        return new MinguoDate(LocalDate.of(prolepticYear + 1911, month, dayOfMonth));
    }

    @Override
    public ChronoLocalDate<MinguoChrono> dateYearDay(int prolepticYear, int dayOfYear) {
        return new MinguoDate(LocalDate.ofYearDay(prolepticYear + 1911, dayOfYear));
    }

    @Override
    public ChronoLocalDate<MinguoChrono> date(TemporalAccessor temporal) {
        if (temporal instanceof MinguoDate) {
            return (MinguoDate)temporal;
        }
        return new MinguoDate(LocalDate.from(temporal));
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return ISOChrono.INSTANCE.isLeapYear(prolepticYear + 1911L);
    }

    @Override
    public int prolepticYear(Era<MinguoChrono> era, int yearOfEra) {
        if (!(era instanceof MinguoEra)) {
            throw new DateTimeException("Era must be MinguoEra");
        }
        return era == MinguoEra.ROC ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public Era<MinguoChrono> eraOf(int eraValue) {
        return MinguoEra.of(eraValue);
    }

    @Override
    public List<Era<MinguoChrono>> eras() {
        return Arrays.asList(MinguoEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        switch (field) {
            case YEAR_OF_ERA: {
                ValueRange range = ChronoField.YEAR.range();
                return ValueRange.of(1L, range.getMaximum() - 1911L, -range.getMinimum() + 1L + 1911L);
            }
            case YEAR: {
                ValueRange range = ChronoField.YEAR.range();
                return ValueRange.of(range.getMinimum() - 1911L, range.getMaximum() - 1911L);
            }
        }
        return field.range();
    }
}

