/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.threeten.bp.format.DateTimeBuilder;
import org.threeten.bp.format.DateTimeFormatSymbols;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalField;

final class DateTimeParseContext {
    private Locale locale;
    private DateTimeFormatSymbols symbols;
    private boolean caseSensitive = true;
    private boolean strict = true;
    private final ArrayList<Parsed> parsed = new ArrayList();

    DateTimeParseContext(DateTimeFormatter formatter) {
        this.locale = formatter.getLocale();
        this.symbols = formatter.getSymbols();
        this.parsed.add(new Parsed());
    }

    DateTimeParseContext(Locale locale, DateTimeFormatSymbols symbols) {
        this.locale = locale;
        this.symbols = symbols;
        this.parsed.add(new Parsed());
    }

    DateTimeParseContext copy() {
        return new DateTimeParseContext(this.locale, this.symbols);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DateTimeFormatSymbols getSymbols() {
        return this.symbols;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean subSequenceEquals(CharSequence cs1, int offset1, CharSequence cs2, int offset2, int length) {
        if (offset1 + length > cs1.length() || offset2 + length > cs2.length()) {
            return false;
        }
        if (this.isCaseSensitive()) {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i)) || Character.toUpperCase(ch1) == Character.toUpperCase(ch2) || Character.toLowerCase(ch1) == Character.toLowerCase(ch2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    void startOptional() {
        this.parsed.add(this.currentParsed().copy());
    }

    void endOptional(boolean successful) {
        if (successful) {
            this.parsed.remove(this.parsed.size() - 2);
        } else {
            this.parsed.remove(this.parsed.size() - 1);
        }
    }

    private Parsed currentParsed() {
        return this.parsed.get(this.parsed.size() - 1);
    }

    public Long getParsed(TemporalField field) {
        for (Object obj : this.currentParsed().parsed) {
            if (!(obj instanceof FieldValue)) continue;
            FieldValue fv = (FieldValue)obj;
            if (!fv.field.equals(field)) continue;
            return fv.value;
        }
        return null;
    }

    public <T> T getParsed(Class<T> clazz) {
        for (Object obj : this.currentParsed().parsed) {
            if (!clazz.isInstance(obj)) continue;
            return (T)obj;
        }
        return null;
    }

    List<Object> getParsed() {
        return this.currentParsed().parsed;
    }

    public void setParsedField(TemporalField field, long value) {
        Objects.requireNonNull(field, "field");
        this.currentParsed().parsed.add(new FieldValue(field, value));
    }

    public <T> void setParsed(Object object) {
        Objects.requireNonNull(object, "object");
        this.currentParsed().parsed.add(object);
    }

    public DateTimeBuilder toBuilder() {
        List<Object> cals = this.currentParsed().parsed;
        DateTimeBuilder builder = new DateTimeBuilder();
        for (Object obj : cals) {
            if (obj instanceof FieldValue) {
                FieldValue fv = (FieldValue)obj;
                builder.addFieldValue(fv.field, fv.value);
                continue;
            }
            builder.addCalendrical(obj);
        }
        return builder;
    }

    public String toString() {
        return this.currentParsed().toString();
    }

    void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        this.locale = locale;
    }

    private static final class FieldValue {
        final TemporalField field;
        final long value;

        private FieldValue(TemporalField field, long value) {
            this.field = field;
            this.value = value;
        }

        public String toString() {
            return this.field.getName() + ' ' + this.value;
        }
    }

    private static final class Parsed {
        final List<Object> parsed = new ArrayList<Object>();

        private Parsed() {
        }

        protected Parsed copy() {
            Parsed cloned = new Parsed();
            cloned.parsed.addAll(this.parsed);
            return cloned;
        }

        public String toString() {
            return this.parsed.toString();
        }
    }
}

