/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.threeten.bp.Clock;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.ChronoLocalDateTime;
import org.threeten.bp.temporal.ChronoLocalDateTimeImpl;
import org.threeten.bp.temporal.ChronoZonedDateTime;
import org.threeten.bp.temporal.ChronoZonedDateTimeImpl;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.ISOChrono;
import org.threeten.bp.temporal.Ser;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.ValueRange;

public abstract class Chrono<C extends Chrono<C>>
implements Comparable<Chrono<?>> {
    private static final ConcurrentHashMap<String, Chrono<?>> CHRONOS_BY_ID;
    private static final ConcurrentHashMap<String, Chrono<?>> CHRONOS_BY_TYPE;

    public static Chrono<?> from(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        ISOChrono obj = temporal.query(TemporalQueries.CHRONO);
        return obj != null ? obj : ISOChrono.INSTANCE;
    }

    public static Chrono<?> ofLocale(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        String type = locale.getUnicodeLocaleType("ca");
        if (type == null) {
            return ISOChrono.INSTANCE;
        }
        if ("iso".equals(type) || "iso8601".equals(type)) {
            return ISOChrono.INSTANCE;
        }
        Chrono<?> chrono = CHRONOS_BY_TYPE.get(type);
        if (chrono == null) {
            throw new DateTimeException("Unknown calendar system: " + type);
        }
        return chrono;
    }

    public static Chrono<?> of(String id) {
        Chrono<?> chrono = CHRONOS_BY_ID.get(id);
        if (chrono != null) {
            return chrono;
        }
        chrono = CHRONOS_BY_TYPE.get(id);
        if (chrono != null) {
            return chrono;
        }
        throw new DateTimeException("Unknown chronology: " + id);
    }

    public static Set<Chrono<?>> getAvailableChronologies() {
        return new HashSet(CHRONOS_BY_ID.values());
    }

    public static <R extends Chrono<R>> ChronoLocalDateTime<R> dateTime(ChronoLocalDate<R> date, LocalTime time) {
        return ChronoLocalDateTimeImpl.of(date, time);
    }

    protected Chrono() {
        CHRONOS_BY_ID.putIfAbsent(this.getId(), this);
        String type = this.getCalendarType();
        if (type != null) {
            CHRONOS_BY_TYPE.putIfAbsent(type, this);
        }
    }

    public ChronoLocalDate<C> ensureChronoLocalDate(Temporal temporal) {
        ChronoLocalDate other = (ChronoLocalDate)temporal;
        if (!this.equals(other.getChrono())) {
            throw new ClassCastException("Chrono mismatch, expected: " + this.getId() + ", actual: " + ((Chrono)other.getChrono()).getId());
        }
        return other;
    }

    public ChronoLocalDateTimeImpl<C> ensureChronoLocalDateTime(Temporal temporal) {
        ChronoLocalDateTimeImpl other = (ChronoLocalDateTimeImpl)temporal;
        if (!this.equals(other.getDate().getChrono())) {
            throw new ClassCastException("Chrono mismatch, required: " + this.getId() + ", supplied: " + ((Chrono)other.getDate().getChrono()).getId());
        }
        return other;
    }

    public ChronoZonedDateTimeImpl<C> ensureChronoZonedDateTime(Temporal temporal) {
        ChronoZonedDateTimeImpl other = (ChronoZonedDateTimeImpl)temporal;
        if (!this.equals(other.getDate().getChrono())) {
            throw new ClassCastException("Chrono mismatch, required: " + this.getId() + ", supplied: " + ((Chrono)other.getDate().getChrono()).getId());
        }
        return other;
    }

    public abstract String getId();

    public abstract String getCalendarType();

    public ChronoLocalDate<C> date(Era<C> era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    public abstract ChronoLocalDate<C> date(int var1, int var2, int var3);

    public ChronoLocalDate<C> dateYearDay(Era<C> era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    public abstract ChronoLocalDate<C> dateYearDay(int var1, int var2);

    public abstract ChronoLocalDate<C> date(TemporalAccessor var1);

    public ChronoLocalDate<C> dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    public ChronoLocalDate<C> dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    public ChronoLocalDate<C> dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return this.date(LocalDate.now(clock));
    }

    public ChronoLocalDateTime<C> localDateTime(TemporalAccessor temporal) {
        try {
            return this.date(temporal).atTime(LocalTime.from(temporal));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain ChronoLocalDateTime from TemporalAccessor: " + temporal.getClass(), ex);
        }
    }

    public ChronoZonedDateTime<C> zonedDateTime(TemporalAccessor temporal) {
        try {
            ZoneId zone = ZoneId.from(temporal);
            try {
                Instant instant = Instant.from(temporal);
                return this.zonedDateTime(instant, zone);
            }
            catch (DateTimeException ex1) {
                ChronoLocalDateTimeImpl<C> cldt = this.ensureChronoLocalDateTime(this.localDateTime(temporal));
                return ChronoZonedDateTimeImpl.ofBest(cldt, zone, null);
            }
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain ChronoZonedDateTime from TemporalAccessor: " + temporal.getClass(), ex);
        }
    }

    public ChronoZonedDateTime<C> zonedDateTime(Instant instant, ZoneId zone) {
        return ChronoZonedDateTimeImpl.ofInstant(this, instant, zone);
    }

    public abstract boolean isLeapYear(long var1);

    public abstract int prolepticYear(Era<C> var1, int var2);

    public abstract Era<C> eraOf(int var1);

    public abstract List<Era<C>> eras();

    public abstract ValueRange range(ChronoField var1);

    public String getText(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendChronoText(style).toFormatter(locale).print(new DefaultInterfaceTemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField field) {
                return false;
            }

            @Override
            public long getLong(TemporalField field) {
                throw new DateTimeException("Unsupported field: " + field);
            }

            @Override
            public <R> R query(TemporalQuery<R> query) {
                if (query == TemporalQueries.CHRONO) {
                    return (R)Chrono.this;
                }
                return super.query(query);
            }
        });
    }

    @Override
    public int compareTo(Chrono<?> other) {
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Chrono) {
            return this.compareTo((Chrono)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    private Object writeReplace() {
        return new Ser(1, this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.getId());
    }

    static Chrono<?> readExternal(DataInput in) throws IOException {
        String id = in.readUTF();
        return Chrono.of(id);
    }

    static {
        ConcurrentHashMap<String, Chrono> ids = new ConcurrentHashMap<String, Chrono>();
        ConcurrentHashMap<String, Chrono> types = new ConcurrentHashMap<String, Chrono>();
        ServiceLoader<Chrono> loader = ServiceLoader.load(Chrono.class);
        for (Chrono chrono : loader) {
            ids.putIfAbsent(chrono.getId(), chrono);
            String type = chrono.getCalendarType();
            if (type == null) continue;
            types.putIfAbsent(type, chrono);
        }
        CHRONOS_BY_ID = ids;
        CHRONOS_BY_TYPE = types;
    }
}

