/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.util.Comparator;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoLocalDateTime;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;

public interface ChronoLocalDate<C extends Chrono<C>>
extends Temporal,
TemporalAdjuster,
Comparable<ChronoLocalDate<?>> {
    public static final Comparator<ChronoLocalDate<?>> DATE_COMPARATOR = new Comparator<ChronoLocalDate<?>>(){

        @Override
        public int compare(ChronoLocalDate<?> date1, ChronoLocalDate<?> date2) {
            return Long.compare(date1.toEpochDay(), date2.toEpochDay());
        }
    };

    public C getChrono();

    public Era<C> getEra();

    public boolean isLeapYear();

    public int lengthOfMonth();

    public int lengthOfYear();

    @Override
    public ChronoLocalDate<C> with(TemporalAdjuster var1);

    @Override
    public ChronoLocalDate<C> with(TemporalField var1, long var2);

    @Override
    public ChronoLocalDate<C> plus(TemporalAdder var1);

    @Override
    public ChronoLocalDate<C> plus(long var1, TemporalUnit var3);

    @Override
    public ChronoLocalDate<C> minus(TemporalSubtractor var1);

    @Override
    public ChronoLocalDate<C> minus(long var1, TemporalUnit var3);

    public ChronoLocalDateTime<C> atTime(LocalTime var1);

    public long toEpochDay();

    @Override
    public int compareTo(ChronoLocalDate<?> var1);

    public boolean isAfter(ChronoLocalDate<?> var1);

    public boolean isBefore(ChronoLocalDate<?> var1);

    public boolean isEqual(ChronoLocalDate<?> var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public String toString(DateTimeFormatter var1);
}

