/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.jdk8.DefaultInterfaceChronoLocalDateTime;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.ChronoLocalDateTime;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.ChronoZonedDateTime;
import org.threeten.bp.temporal.ChronoZonedDateTimeImpl;
import org.threeten.bp.temporal.Ser;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;

final class ChronoLocalDateTimeImpl<C extends Chrono<C>>
extends DefaultInterfaceChronoLocalDateTime<C>
implements ChronoLocalDateTime<C>,
Temporal,
TemporalAdjuster,
Serializable {
    private static final long serialVersionUID = 4556003607393004514L;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final long MICROS_PER_DAY = 86400000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MINUTE = 60000000000L;
    private static final long NANOS_PER_HOUR = 3600000000000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private final ChronoLocalDate<C> date;
    private final LocalTime time;

    static <R extends Chrono<R>> ChronoLocalDateTimeImpl<R> of(ChronoLocalDate<R> date, LocalTime time) {
        return new ChronoLocalDateTimeImpl<R>(date, time);
    }

    private ChronoLocalDateTimeImpl(ChronoLocalDate<C> date, LocalTime time) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(time, "time");
        this.date = date;
        this.time = time;
    }

    private ChronoLocalDateTimeImpl<C> with(Temporal newDate, LocalTime newTime) {
        if (this.date == newDate && this.time == newTime) {
            return this;
        }
        ChronoLocalDate cd = ((Chrono)this.date.getChrono()).ensureChronoLocalDate(newDate);
        return new ChronoLocalDateTimeImpl(cd, newTime);
    }

    @Override
    public ChronoLocalDate<C> getDate() {
        return this.date;
    }

    @Override
    public LocalTime getTime() {
        return this.time;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isDateField() || f.isTimeField();
        }
        return field != null && field.doIsSupported(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isTimeField() ? this.time.range(field) : this.date.range(field);
        }
        return field.doRange(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isTimeField() ? this.time.get(field) : this.date.get(field);
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isTimeField() ? this.time.getLong(field) : this.date.getLong(field);
        }
        return field.doGet(this);
    }

    @Override
    public ChronoLocalDateTimeImpl<C> with(TemporalAdjuster adjuster) {
        if (adjuster instanceof ChronoLocalDate) {
            return this.with((ChronoLocalDate)adjuster, this.time);
        }
        if (adjuster instanceof LocalTime) {
            return this.with(this.date, (LocalTime)adjuster);
        }
        if (adjuster instanceof ChronoLocalDateTimeImpl) {
            return ((Chrono)this.date.getChrono()).ensureChronoLocalDateTime((ChronoLocalDateTimeImpl)adjuster);
        }
        return ((Chrono)this.date.getChrono()).ensureChronoLocalDateTime((ChronoLocalDateTimeImpl)adjuster.adjustInto(this));
    }

    @Override
    public ChronoLocalDateTimeImpl<C> with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            if (f.isTimeField()) {
                return this.with(this.date, this.time.with(field, newValue));
            }
            return this.with(this.date.with(field, newValue), this.time);
        }
        return ((Chrono)this.date.getChrono()).ensureChronoLocalDateTime(field.doWith(this, newValue));
    }

    @Override
    public ChronoLocalDateTimeImpl<C> plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)unit;
            switch (f) {
                case NANOS: {
                    return this.plusNanos(amountToAdd);
                }
                case MICROS: {
                    return super.plusNanos(amountToAdd % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return super.plusNanos(amountToAdd % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(amountToAdd);
                }
                case MINUTES: {
                    return this.plusMinutes(amountToAdd);
                }
                case HOURS: {
                    return this.plusHours(amountToAdd);
                }
                case HALF_DAYS: {
                    return super.plusHours(amountToAdd % 256L * 12L);
                }
            }
            return this.with(this.date.plus(amountToAdd, unit), this.time);
        }
        return ((Chrono)this.date.getChrono()).ensureChronoLocalDateTime(unit.doPlus(this, amountToAdd));
    }

    private ChronoLocalDateTimeImpl<C> plusDays(long days) {
        return this.with(this.date.plus(days, ChronoUnit.DAYS), this.time);
    }

    private ChronoLocalDateTimeImpl<C> plusHours(long hours) {
        return this.plusWithOverflow(this.date, hours, 0L, 0L, 0L);
    }

    private ChronoLocalDateTimeImpl<C> plusMinutes(long minutes) {
        return this.plusWithOverflow(this.date, 0L, minutes, 0L, 0L);
    }

    ChronoLocalDateTimeImpl<C> plusSeconds(long seconds) {
        return this.plusWithOverflow(this.date, 0L, 0L, seconds, 0L);
    }

    private ChronoLocalDateTimeImpl<C> plusNanos(long nanos) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, nanos);
    }

    private ChronoLocalDateTimeImpl<C> plusWithOverflow(ChronoLocalDate<C> newDate, long hours, long minutes, long seconds, long nanos) {
        if ((hours | minutes | seconds | nanos) == 0L) {
            return this.with(newDate, this.time);
        }
        long totDays = nanos / 86400000000000L + seconds / 86400L + minutes / 1440L + hours / 24L;
        long totNanos = nanos % 86400000000000L + seconds % 86400L * 1000000000L + minutes % 1440L * 60000000000L + hours % 24L * 3600000000000L;
        long curNoD = this.time.toNanoOfDay();
        long newNoD = Jdk8Methods.floorMod(totNanos, 86400000000000L);
        LocalTime newTime = newNoD == curNoD ? this.time : LocalTime.ofNanoOfDay(newNoD);
        return this.with(newDate.plus(totDays += Jdk8Methods.floorDiv(totNanos += curNoD, 86400000000000L), ChronoUnit.DAYS), newTime);
    }

    @Override
    public ChronoZonedDateTime<C> atZone(ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofBest(this, zoneId, null);
    }

    @Override
    public long periodUntil(Temporal endDateTime, TemporalUnit unit) {
        if (!(endDateTime instanceof ChronoLocalDateTime)) {
            throw new DateTimeException("Unable to calculate period between objects of two different types");
        }
        ChronoLocalDateTime end = (ChronoLocalDateTime)endDateTime;
        if (!((Chrono)this.getDate().getChrono()).equals(end.getDate().getChrono())) {
            throw new DateTimeException("Unable to calculate period between two different chronologies");
        }
        if (unit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)unit;
            if (f.isTimeUnit()) {
                long amount = end.getLong(ChronoField.EPOCH_DAY) - this.date.getLong(ChronoField.EPOCH_DAY);
                switch (f) {
                    case NANOS: {
                        amount = Jdk8Methods.safeMultiply(amount, 86400000000000L);
                        break;
                    }
                    case MICROS: {
                        amount = Jdk8Methods.safeMultiply(amount, 86400000000L);
                        break;
                    }
                    case MILLIS: {
                        amount = Jdk8Methods.safeMultiply(amount, 86400000L);
                        break;
                    }
                    case SECONDS: {
                        amount = Jdk8Methods.safeMultiply(amount, 86400);
                        break;
                    }
                    case MINUTES: {
                        amount = Jdk8Methods.safeMultiply(amount, 1440);
                        break;
                    }
                    case HOURS: {
                        amount = Jdk8Methods.safeMultiply(amount, 24);
                        break;
                    }
                    case HALF_DAYS: {
                        amount = Jdk8Methods.safeMultiply(amount, 2);
                    }
                }
                return Jdk8Methods.safeAdd(amount, this.time.periodUntil(end.getTime(), unit));
            }
            ChronoLocalDate endDate = end.getDate();
            if (end.getTime().isBefore(this.time)) {
                endDate = endDate.minus(1L, ChronoUnit.DAYS);
            }
            return this.date.periodUntil(endDate, unit);
        }
        return unit.between(this, endDateTime).getAmount();
    }

    private Object writeReplace() {
        return new Ser(2, this);
    }

    void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.date);
        out.writeObject(this.time);
    }

    static ChronoLocalDateTime<?> readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ChronoLocalDate date = (ChronoLocalDate)in.readObject();
        LocalTime time = (LocalTime)in.readObject();
        return date.atTime(time);
    }
}

