/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import org.threeten.bp.temporal.Ser;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;

public final class SimplePeriod
implements TemporalAdder,
TemporalSubtractor,
Comparable<SimplePeriod>,
Serializable {
    private static final long serialVersionUID = 3752975649629L;
    private final long amount;
    private final TemporalUnit unit;

    public static SimplePeriod of(long amount, TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        return new SimplePeriod(amount, unit);
    }

    SimplePeriod(long amount, TemporalUnit unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public long getAmount() {
        return this.amount;
    }

    public TemporalUnit getUnit() {
        return this.unit;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.amount, this.unit);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.amount, this.unit);
    }

    public SimplePeriod abs() {
        if (this.amount == Long.MIN_VALUE) {
            throw new ArithmeticException("Unable to call abs() on MIN_VALUE");
        }
        return this.amount >= 0L ? this : new SimplePeriod(-this.amount, this.unit);
    }

    @Override
    public int compareTo(SimplePeriod other) {
        if (!this.unit.equals(other.unit)) {
            throw new IllegalArgumentException("Unable to compare periods with different units");
        }
        return Long.compare(this.amount, other.amount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimplePeriod) {
            SimplePeriod other = (SimplePeriod)obj;
            return this.amount == other.amount && this.unit.equals(other.unit);
        }
        return false;
    }

    public int hashCode() {
        return this.unit.hashCode() ^ (int)(this.amount ^ this.amount >>> 32);
    }

    public String toString() {
        return this.amount + " " + this.unit.getName();
    }

    private Object writeReplace() {
        return new Ser(10, this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.amount);
        out.writeObject(this.unit);
    }

    static SimplePeriod readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long amount = in.readLong();
        TemporalUnit unit = (TemporalUnit)in.readObject();
        return SimplePeriod.of(amount, unit);
    }
}

