/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.util.Comparator;
import org.threeten.bp.LocalTime;
import org.threeten.bp.Period;
import org.threeten.bp.chrono.ChronoLocalDateTime;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.Era;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;

public interface ChronoLocalDate<D extends ChronoLocalDate<D>>
extends Temporal,
TemporalAdjuster,
Comparable<ChronoLocalDate<?>> {
    public static final Comparator<ChronoLocalDate<?>> DATE_COMPARATOR = new Comparator<ChronoLocalDate<?>>(){

        @Override
        public int compare(ChronoLocalDate<?> date1, ChronoLocalDate<?> date2) {
            return Long.compare(date1.toEpochDay(), date2.toEpochDay());
        }
    };

    public Chronology getChronology();

    public Era getEra();

    public boolean isLeapYear();

    public int lengthOfMonth();

    public int lengthOfYear();

    @Override
    public ChronoLocalDate<D> with(TemporalAdjuster var1);

    @Override
    public ChronoLocalDate<D> with(TemporalField var1, long var2);

    @Override
    public ChronoLocalDate<D> plus(TemporalAmount var1);

    @Override
    public ChronoLocalDate<D> plus(long var1, TemporalUnit var3);

    @Override
    public ChronoLocalDate<D> minus(TemporalAmount var1);

    @Override
    public ChronoLocalDate<D> minus(long var1, TemporalUnit var3);

    public Period periodUntil(ChronoLocalDate<?> var1);

    public ChronoLocalDateTime<D> atTime(LocalTime var1);

    public long toEpochDay();

    @Override
    public int compareTo(ChronoLocalDate<?> var1);

    public boolean isAfter(ChronoLocalDate<?> var1);

    public boolean isBefore(ChronoLocalDate<?> var1);

    public boolean isEqual(ChronoLocalDate<?> var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public String toString(DateTimeFormatter var1);
}

