/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Locale;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.chrono.Era;
import org.threeten.bp.chrono.HijrahChronology;
import org.threeten.bp.chrono.HijrahDate;
import org.threeten.bp.chrono.Ser;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.ValueRange;

enum HijrahEra implements Era
{
    BEFORE_AH,
    AH;


    public static HijrahEra of(int hijrahEra) {
        switch (hijrahEra) {
            case 0: {
                return BEFORE_AH;
            }
            case 1: {
                return AH;
            }
        }
        throw new DateTimeException("HijrahEra not valid");
    }

    @Override
    public int getValue() {
        return this.ordinal();
    }

    @Override
    public HijrahChronology getChronology() {
        return HijrahChronology.INSTANCE;
    }

    public HijrahDate date(int year, int month, int day) {
        return this.getChronology().date(this, year, month, day);
    }

    public HijrahDate dateYearDay(int year, int dayOfYear) {
        return this.getChronology().dateYearDay(this, year, dayOfYear);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.ERA) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            throw new DateTimeException("Unsupported field: " + field.getName());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new DateTimeException("Unsupported field: " + field.getName());
        }
        return field.getFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.ERA, this.getValue());
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)this.getChronology();
        }
        return query.queryFrom(this);
    }

    @Override
    public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, style).toFormatter(locale).format(this);
    }

    int prolepticYear(int yearOfEra) {
        return this == AH ? yearOfEra : 1 - yearOfEra;
    }

    private Object writeReplace() {
        return new Ser(4, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.getValue());
    }

    static HijrahEra readExternal(DataInput in) throws IOException {
        byte eraValue = in.readByte();
        return HijrahEra.of(eraValue);
    }
}

