/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.ChronoDateImpl;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.Ser;
import org.threeten.bp.chrono.ThaiBuddhistChronology;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.ValueRange;

public final class ThaiBuddhistDate
extends ChronoDateImpl<ThaiBuddhistDate>
implements Serializable {
    private static final long serialVersionUID = -8722293800195731463L;
    private final LocalDate isoDate;

    ThaiBuddhistDate(LocalDate date) {
        Objects.requireNonNull(date, "date");
        this.isoDate = date;
    }

    @Override
    public ThaiBuddhistChronology getChronology() {
        return ThaiBuddhistChronology.INSTANCE;
    }

    @Override
    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                ChronoField f = (ChronoField)field;
                switch (f) {
                    case DAY_OF_MONTH: 
                    case DAY_OF_YEAR: 
                    case ALIGNED_WEEK_OF_MONTH: {
                        return this.isoDate.range(field);
                    }
                    case YEAR_OF_ERA: {
                        ValueRange range = ChronoField.YEAR.range();
                        long max = this.getProlepticYear() <= 0 ? -(range.getMinimum() + 543L) + 1L : range.getMaximum() + 543L;
                        return ValueRange.of(1L, max);
                    }
                }
                return this.getChronology().range(f);
            }
            throw new DateTimeException("Unsupported field: " + field.getName());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case YEAR_OF_ERA: {
                    int prolepticYear = this.getProlepticYear();
                    return prolepticYear >= 1 ? prolepticYear : 1 - prolepticYear;
                }
                case YEAR: {
                    return this.getProlepticYear();
                }
                case ERA: {
                    return this.getProlepticYear() >= 1 ? 1 : 0;
                }
            }
            return this.isoDate.getLong(field);
        }
        return field.getFrom(this);
    }

    private int getProlepticYear() {
        return this.isoDate.getYear() + 543;
    }

    @Override
    public ThaiBuddhistDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            if (this.getLong(f) == newValue) {
                return this;
            }
            switch (f) {
                case YEAR_OF_ERA: 
                case YEAR: 
                case ERA: {
                    f.checkValidValue(newValue);
                    int nvalue = (int)newValue;
                    switch (f) {
                        case YEAR_OF_ERA: {
                            return this.with(this.isoDate.withYear((this.getProlepticYear() >= 1 ? nvalue : 1 - nvalue) - 543));
                        }
                        case YEAR: {
                            return this.with(this.isoDate.withYear(nvalue - 543));
                        }
                        case ERA: {
                            return this.with(this.isoDate.withYear(1 - this.getProlepticYear() - 543));
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(field, newValue));
        }
        return field.adjustInto(this, newValue);
    }

    ThaiBuddhistDate plusYears(long years) {
        return this.with(this.isoDate.plusYears(years));
    }

    ThaiBuddhistDate plusMonths(long months) {
        return this.with(this.isoDate.plusMonths(months));
    }

    ThaiBuddhistDate plusDays(long days) {
        return this.with(this.isoDate.plusDays(days));
    }

    private ThaiBuddhistDate with(LocalDate newDate) {
        return newDate.equals(this.isoDate) ? this : new ThaiBuddhistDate(newDate);
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThaiBuddhistDate) {
            ThaiBuddhistDate otherDate = (ThaiBuddhistDate)obj;
            return this.isoDate.equals(otherDate.isoDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private Object writeReplace() {
        return new Ser(7, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.get(ChronoField.YEAR));
        out.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        out.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static ChronoLocalDate<?> readExternal(DataInput in) throws IOException {
        int year = in.readInt();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        return ThaiBuddhistChronology.INSTANCE.date(year, month, dayOfMonth);
    }
}

