/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.format.DateTimeFormatStyleProvider;
import org.threeten.bp.format.DateTimeFormatSymbols;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseContext;
import org.threeten.bp.format.DateTimePrintContext;
import org.threeten.bp.format.DateTimeTextProvider;
import org.threeten.bp.format.FormatStyle;
import org.threeten.bp.format.SignStyle;
import org.threeten.bp.format.SimpleDateTimeTextProvider;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.IsoFields;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.ValueRange;
import org.threeten.bp.zone.ZoneRulesProvider;

public final class DateTimeFormatterBuilder {
    private static final TemporalQuery<ZoneId> QUERY_REGION_ONLY = new TemporalQuery<ZoneId>(){

        @Override
        public ZoneId queryFrom(TemporalAccessor temporal) {
            ZoneId zone = temporal.query(TemporalQueries.zoneId());
            return zone != null && !(zone instanceof ZoneOffset) ? zone : null;
        }
    };
    private DateTimeFormatterBuilder active = this;
    private final DateTimeFormatterBuilder parent;
    private final List<DateTimePrinterParser> printerParsers = new ArrayList<DateTimePrinterParser>();
    private final boolean optional;
    private int padNextWidth;
    private char padNextChar;
    private int valueParserIndex = -1;
    private static final Map<Character, TemporalField> FIELD_MAP = new HashMap<Character, TemporalField>();
    static final Comparator<String> LENGTH_SORT;

    public DateTimeFormatterBuilder() {
        this.parent = null;
        this.optional = false;
    }

    private DateTimeFormatterBuilder(DateTimeFormatterBuilder parent, boolean optional) {
        this.parent = parent;
        this.optional = optional;
    }

    public DateTimeFormatterBuilder parseCaseSensitive() {
        this.appendInternal(SettingsParser.SENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseCaseInsensitive() {
        this.appendInternal(SettingsParser.INSENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseStrict() {
        this.appendInternal(SettingsParser.STRICT);
        return this;
    }

    public DateTimeFormatterBuilder parseLenient() {
        this.appendInternal(SettingsParser.LENIENT);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField field) {
        Objects.requireNonNull(field, "field");
        this.active.valueParserIndex = this.appendInternal(new NumberPrinterParser(field, 1, 19, SignStyle.NORMAL));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField field, int width) {
        Objects.requireNonNull(field, "field");
        if (width < 1 || width > 19) {
            throw new IllegalArgumentException("The width must be from 1 to 19 inclusive but was " + width);
        }
        NumberPrinterParser pp = new NumberPrinterParser(field, width, width, SignStyle.NOT_NEGATIVE);
        return this.appendFixedWidth(width, pp);
    }

    public DateTimeFormatterBuilder appendValue(TemporalField field, int minWidth, int maxWidth, SignStyle signStyle) {
        if (minWidth == maxWidth && signStyle == SignStyle.NOT_NEGATIVE) {
            return this.appendValue(field, maxWidth);
        }
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(signStyle, "signStyle");
        if (minWidth < 1 || minWidth > 19) {
            throw new IllegalArgumentException("The minimum width must be from 1 to 19 inclusive but was " + minWidth);
        }
        if (maxWidth < 1 || maxWidth > 19) {
            throw new IllegalArgumentException("The maximum width must be from 1 to 19 inclusive but was " + maxWidth);
        }
        if (maxWidth < minWidth) {
            throw new IllegalArgumentException("The maximum width must exceed or equal the minimum width but " + maxWidth + " < " + minWidth);
        }
        NumberPrinterParser pp = new NumberPrinterParser(field, minWidth, maxWidth, signStyle);
        if (minWidth == maxWidth) {
            this.appendInternal(pp);
        } else {
            this.active.valueParserIndex = this.appendInternal(pp);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField field, int width, int baseValue) {
        Objects.requireNonNull(field, "field");
        ReducedPrinterParser pp = new ReducedPrinterParser(field, width, baseValue);
        this.appendFixedWidth(width, pp);
        return this;
    }

    private DateTimeFormatterBuilder appendFixedWidth(int width, NumberPrinterParser pp) {
        if (this.active.valueParserIndex >= 0) {
            NumberPrinterParser basePP = (NumberPrinterParser)this.active.printerParsers.get(this.active.valueParserIndex);
            basePP = basePP.withSubsequentWidth(width);
            int activeValueParser = this.active.valueParserIndex;
            this.active.printerParsers.set(this.active.valueParserIndex, basePP);
            this.appendInternal(pp.withFixedWidth());
            this.active.valueParserIndex = activeValueParser;
        } else {
            this.appendInternal(pp);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendFraction(TemporalField field, int minWidth, int maxWidth, boolean decimalPoint) {
        this.appendInternal(new FractionPrinterParser(field, minWidth, maxWidth, decimalPoint));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField field) {
        return this.appendText(field, TextStyle.FULL);
    }

    public DateTimeFormatterBuilder appendText(TemporalField field, TextStyle textStyle) {
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(textStyle, "textStyle");
        this.appendInternal(new TextPrinterParser(field, textStyle, DateTimeTextProvider.getInstance()));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField field, Map<Long, String> textLookup) {
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(textLookup, "textLookup");
        LinkedHashMap<Long, String> copy = new LinkedHashMap<Long, String>(textLookup);
        Map<TextStyle, Map<Long, String>> map = Collections.singletonMap(TextStyle.FULL, copy);
        final SimpleDateTimeTextProvider.LocaleStore store = new SimpleDateTimeTextProvider.LocaleStore(map);
        DateTimeTextProvider provider = new DateTimeTextProvider(){

            @Override
            public String getText(TemporalField field, long value, TextStyle style, Locale locale) {
                return store.getText(value, style);
            }

            @Override
            public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField field, TextStyle style, Locale locale) {
                return store.getTextIterator(style);
            }

            @Override
            public Locale[] getAvailableLocales() {
                throw new UnsupportedOperationException();
            }
        };
        this.appendInternal(new TextPrinterParser(field, TextStyle.FULL, provider));
        return this;
    }

    public DateTimeFormatterBuilder appendInstant() {
        this.appendInternal(new InstantPrinterParser());
        return this;
    }

    public DateTimeFormatterBuilder appendOffsetId() {
        this.appendInternal(OffsetIdPrinterParser.INSTANCE_ID);
        return this;
    }

    public DateTimeFormatterBuilder appendOffset(String pattern, String noOffsetText) {
        this.appendInternal(new OffsetIdPrinterParser(noOffsetText, pattern));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneId() {
        this.appendInternal(new ZoneIdPrinterParser(TemporalQueries.zoneId(), "ZoneId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneRegionId() {
        this.appendInternal(new ZoneIdPrinterParser(QUERY_REGION_ONLY, "ZoneRegionId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneOrOffsetId() {
        this.appendInternal(new ZoneIdPrinterParser(TemporalQueries.zone(), "ZoneOrOffsetId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle) {
        this.appendInternal(new ZoneTextPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyId() {
        this.appendInternal(new ChronoPrinterParser(null));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyText(TextStyle textStyle) {
        Objects.requireNonNull(textStyle, "textStyle");
        this.appendInternal(new ChronoPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendLocalized(FormatStyle dateStyle, FormatStyle timeStyle) {
        if (dateStyle == null && timeStyle == null) {
            throw new IllegalArgumentException("Either the date or time style must be non-null");
        }
        this.appendInternal(new LocalizedPrinterParser(dateStyle, timeStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char literal) {
        this.appendInternal(new CharLiteralPrinterParser(literal));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(String literal) {
        Objects.requireNonNull(literal, "literal");
        if (literal.length() > 0) {
            if (literal.length() == 1) {
                this.appendInternal(new CharLiteralPrinterParser(literal.charAt(0)));
            } else {
                this.appendInternal(new StringLiteralPrinterParser(literal));
            }
        }
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.appendInternal(formatter.toPrinterParser(false));
        return this;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.appendInternal(formatter.toPrinterParser(true));
        return this;
    }

    public DateTimeFormatterBuilder appendPattern(String pattern) {
        Objects.requireNonNull(pattern, "pattern");
        this.parsePattern(pattern);
        return this;
    }

    private void parsePattern(String pattern) {
        for (int pos = 0; pos < pattern.length(); ++pos) {
            int start;
            char cur = pattern.charAt(pos);
            if (cur >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z') {
                TemporalField field;
                start = pos++;
                while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                    ++pos;
                }
                int count = pos - start;
                if (cur == 'p') {
                    int pad = 0;
                    if (pos < pattern.length() && ((cur = pattern.charAt(pos)) >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z')) {
                        pad = count;
                        start = pos++;
                        while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                            ++pos;
                        }
                        count = pos - start;
                    }
                    if (pad == 0) {
                        throw new IllegalArgumentException("Pad letter 'p' must be followed by valid pad pattern: " + pattern);
                    }
                    this.padNext(pad);
                }
                if ((field = FIELD_MAP.get(Character.valueOf(cur))) != null) {
                    this.parseField(cur, count, field);
                } else if (cur == 'z') {
                    if (count > 4) {
                        throw new IllegalArgumentException("Too many pattern letters: " + cur);
                    }
                    if (count == 4) {
                        this.appendZoneText(TextStyle.FULL);
                    } else {
                        this.appendZoneText(TextStyle.SHORT);
                    }
                } else if (cur == 'V') {
                    if (count != 2) {
                        throw new IllegalArgumentException("Pattern letter count must be 2: " + cur);
                    }
                    this.appendZoneId();
                } else if (cur == 'Z') {
                    if (count > 3) {
                        throw new IllegalArgumentException("Too many pattern letters: " + cur);
                    }
                    this.appendOffset("+HHMM", "+0000");
                } else if (cur == 'X') {
                    if (count > 5) {
                        throw new IllegalArgumentException("Too many pattern letters: " + cur);
                    }
                    this.appendOffset(OffsetIdPrinterParser.PATTERNS[count + (count == 1 ? 0 : 1)], "Z");
                } else if (cur == 'x') {
                    if (count > 5) {
                        throw new IllegalArgumentException("Too many pattern letters: " + cur);
                    }
                    String zero = count == 1 ? "+00" : (count % 2 == 0 ? "+0000" : "+00:00");
                    this.appendOffset(OffsetIdPrinterParser.PATTERNS[count + (count == 1 ? 0 : 1)], zero);
                } else {
                    throw new IllegalArgumentException("Unknown pattern letter: " + cur);
                }
                --pos;
                continue;
            }
            if (cur == '\'') {
                start = pos++;
                while (pos < pattern.length()) {
                    if (pattern.charAt(pos) == '\'') {
                        if (pos + 1 >= pattern.length() || pattern.charAt(pos + 1) != '\'') break;
                        ++pos;
                    }
                    ++pos;
                }
                if (pos >= pattern.length()) {
                    throw new IllegalArgumentException("Pattern ends with an incomplete string literal: " + pattern);
                }
                String str = pattern.substring(start + 1, pos);
                if (str.length() == 0) {
                    this.appendLiteral('\'');
                    continue;
                }
                this.appendLiteral(str.replace("''", "'"));
                continue;
            }
            if (cur == '[') {
                this.optionalStart();
                continue;
            }
            if (cur == ']') {
                if (this.active.parent == null) {
                    throw new IllegalArgumentException("Pattern invalid as it contains ] without previous [");
                }
                this.optionalEnd();
                continue;
            }
            if (cur == '{' || cur == '}') {
                throw new IllegalArgumentException("Pattern includes reserved character: '" + cur + "'");
            }
            this.appendLiteral(cur);
        }
    }

    private void parseField(char cur, int count, TemporalField field) {
        block0 : switch (cur) {
            case 'Y': 
            case 'y': {
                if (count == 2) {
                    this.appendValueReduced(field, 2, 2000);
                    break;
                }
                if (count < 4) {
                    this.appendValue(field, count, 19, SignStyle.NORMAL);
                    break;
                }
                this.appendValue(field, count, 19, SignStyle.EXCEEDS_PAD);
                break;
            }
            case 'E': 
            case 'G': 
            case 'M': 
            case 'Q': {
                switch (count) {
                    case 1: {
                        this.appendValue(field);
                        break block0;
                    }
                    case 2: {
                        this.appendValue(field, 2);
                        break block0;
                    }
                    case 3: {
                        this.appendText(field, TextStyle.SHORT);
                        break block0;
                    }
                    case 4: {
                        this.appendText(field, TextStyle.FULL);
                        break block0;
                    }
                    case 5: {
                        this.appendText(field, TextStyle.NARROW);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + cur);
            }
            case 'a': {
                switch (count) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.appendText(field, TextStyle.SHORT);
                        break block0;
                    }
                    case 4: {
                        this.appendText(field, TextStyle.FULL);
                        break block0;
                    }
                    case 5: {
                        this.appendText(field, TextStyle.NARROW);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + cur);
            }
            case 'S': {
                this.appendFraction(ChronoField.NANO_OF_SECOND, count, count, false);
                break;
            }
            default: {
                if (count == 1) {
                    this.appendValue(field);
                    break;
                }
                this.appendValue(field, count);
            }
        }
    }

    public DateTimeFormatterBuilder padNext(int padWidth) {
        return this.padNext(padWidth, ' ');
    }

    public DateTimeFormatterBuilder padNext(int padWidth, char padChar) {
        if (padWidth < 1) {
            throw new IllegalArgumentException("The pad width must be at least one but was " + padWidth);
        }
        this.active.padNextWidth = padWidth;
        this.active.padNextChar = padChar;
        this.active.valueParserIndex = -1;
        return this;
    }

    public DateTimeFormatterBuilder optionalStart() {
        this.active.valueParserIndex = -1;
        this.active = new DateTimeFormatterBuilder(this.active, true);
        return this;
    }

    public DateTimeFormatterBuilder optionalEnd() {
        if (this.active.parent == null) {
            throw new IllegalStateException("Cannot call optionalEnd() as there was no previous call to optionalStart()");
        }
        if (this.active.printerParsers.size() > 0) {
            CompositePrinterParser cpp = new CompositePrinterParser(this.active.printerParsers, this.active.optional);
            this.active = this.active.parent;
            this.appendInternal(cpp);
        } else {
            this.active = this.active.parent;
        }
        return this;
    }

    private int appendInternal(DateTimePrinterParser pp) {
        Objects.requireNonNull(pp, "pp");
        if (this.active.padNextWidth > 0) {
            if (pp != null) {
                pp = new PadPrinterParserDecorator(pp, this.active.padNextWidth, this.active.padNextChar);
            }
            this.active.padNextWidth = 0;
            this.active.padNextChar = '\u0000';
        }
        this.active.printerParsers.add(pp);
        this.active.valueParserIndex = -1;
        return this.active.printerParsers.size() - 1;
    }

    public DateTimeFormatter toFormatter() {
        return this.toFormatter(Locale.getDefault());
    }

    public DateTimeFormatter toFormatter(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        while (this.active.parent != null) {
            this.optionalEnd();
        }
        CompositePrinterParser pp = new CompositePrinterParser(this.printerParsers, false);
        return new DateTimeFormatter(pp, locale, DateTimeFormatSymbols.STANDARD, null, null);
    }

    static {
        FIELD_MAP.put(Character.valueOf('G'), ChronoField.ERA);
        FIELD_MAP.put(Character.valueOf('y'), ChronoField.YEAR);
        FIELD_MAP.put(Character.valueOf('Q'), IsoFields.QUARTER_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('M'), ChronoField.MONTH_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('D'), ChronoField.DAY_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('d'), ChronoField.DAY_OF_MONTH);
        FIELD_MAP.put(Character.valueOf('F'), ChronoField.ALIGNED_WEEK_OF_MONTH);
        FIELD_MAP.put(Character.valueOf('E'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('a'), ChronoField.AMPM_OF_DAY);
        FIELD_MAP.put(Character.valueOf('H'), ChronoField.HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('k'), ChronoField.CLOCK_HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('K'), ChronoField.HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('h'), ChronoField.CLOCK_HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('m'), ChronoField.MINUTE_OF_HOUR);
        FIELD_MAP.put(Character.valueOf('s'), ChronoField.SECOND_OF_MINUTE);
        FIELD_MAP.put(Character.valueOf('S'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('A'), ChronoField.MILLI_OF_DAY);
        FIELD_MAP.put(Character.valueOf('n'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('N'), ChronoField.NANO_OF_DAY);
        LENGTH_SORT = new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.length() == str2.length() ? str1.compareTo(str2) : str1.length() - str2.length();
            }
        };
    }

    static final class LocalizedPrinterParser
    implements DateTimePrinterParser {
        private final FormatStyle dateStyle;
        private final FormatStyle timeStyle;

        LocalizedPrinterParser(FormatStyle dateStyle, FormatStyle timeStyle) {
            this.dateStyle = dateStyle;
            this.timeStyle = timeStyle;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            Chronology chrono = Chronology.from(context.getTemporal());
            return this.formatter(context.getLocale(), chrono).toPrinterParser(false).print(context, buf);
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            Chronology chrono = context.getEffectiveChronology();
            return this.formatter(context.getLocale(), chrono).toPrinterParser(false).parse(context, text, position);
        }

        private DateTimeFormatter formatter(Locale locale, Chronology chrono) {
            return DateTimeFormatStyleProvider.getInstance().getFormatter(this.dateStyle, this.timeStyle, chrono, locale);
        }

        public String toString() {
            return "Localized(" + (this.dateStyle != null ? this.dateStyle : "") + "," + (this.timeStyle != null ? this.timeStyle : "") + ")";
        }
    }

    static final class ChronoPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle textStyle;

        ChronoPrinterParser(TextStyle textStyle) {
            this.textStyle = textStyle;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            Chronology chrono = context.getValue(TemporalQueries.chronology());
            if (chrono == null) {
                return false;
            }
            if (this.textStyle == null) {
                buf.append(chrono.getId());
            } else {
                buf.append(chrono.getId());
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            if (position < 0 || position > text.length()) {
                throw new IndexOutOfBoundsException();
            }
            Set<Chronology> chronos = Chronology.getAvailableChronologies();
            Chronology bestMatch = null;
            int matchLen = -1;
            for (Chronology chrono : chronos) {
                String id = chrono.getId();
                int idLen = id.length();
                if (idLen <= matchLen || !context.subSequenceEquals(text, position, id, 0, idLen)) continue;
                bestMatch = chrono;
                matchLen = idLen;
            }
            if (bestMatch == null) {
                return ~position;
            }
            context.setParsed(bestMatch);
            return position + matchLen;
        }
    }

    static final class ZoneIdPrinterParser
    implements DateTimePrinterParser {
        private final TemporalQuery<ZoneId> query;
        private final String description;
        private static volatile Map.Entry<Integer, SubstringTree> cachedSubstringTree;

        ZoneIdPrinterParser(TemporalQuery<ZoneId> query, String description) {
            this.query = query;
            this.description = description;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            ZoneId zone = context.getValue(this.query);
            if (zone == null) {
                return false;
            }
            buf.append(zone.getId());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            int nodeLength;
            int length = text.length();
            if (position > length) {
                throw new IndexOutOfBoundsException();
            }
            if (position == length) {
                return ~position;
            }
            char nextChar = text.charAt(position);
            if (nextChar == '+' || nextChar == '-') {
                DateTimeParseContext newContext = context.copy();
                int endPos = OffsetIdPrinterParser.INSTANCE_ID.parse(newContext, text, position);
                if (endPos < 0) {
                    return endPos;
                }
                int offset = (int)newContext.getParsed(ChronoField.OFFSET_SECONDS).longValue();
                ZoneOffset zone = ZoneOffset.ofTotalSeconds(offset);
                context.setParsed(zone);
                return endPos;
            }
            if (length >= position + 2) {
                char nextNextChar = text.charAt(position + 1);
                if (nextChar == 'U' && nextNextChar == 'T') {
                    if (length >= position + 3 && text.charAt(position + 2) == 'C') {
                        return this.parsePrefixedOffset(context, text, position + 3);
                    }
                    return this.parsePrefixedOffset(context, text, position + 2);
                }
                if (nextChar == 'G' && length >= position + 3 && nextNextChar == 'M' && text.charAt(position + 2) == 'T') {
                    return this.parsePrefixedOffset(context, text, position + 3);
                }
            }
            Set<String> regionIds = ZoneRulesProvider.getAvailableZoneIds();
            int regionIdsSize = regionIds.size();
            Map.Entry<Integer, SubstringTree> cached = cachedSubstringTree;
            if (cached == null || cached.getKey() != regionIdsSize) {
                ZoneIdPrinterParser zone = this;
                synchronized (zone) {
                    cached = cachedSubstringTree;
                    if (cached == null || cached.getKey() != regionIdsSize) {
                        cachedSubstringTree = cached = new AbstractMap.SimpleImmutableEntry<Integer, SubstringTree>(regionIdsSize, ZoneIdPrinterParser.prepareParser(regionIds));
                    }
                }
            }
            SubstringTree tree = cached.getValue();
            String parsedZoneId = null;
            while (tree != null && position + (nodeLength = tree.length) <= length) {
                parsedZoneId = text.subSequence(position, position + nodeLength).toString();
                tree = tree.get(parsedZoneId);
            }
            if (parsedZoneId == null || !regionIds.contains(parsedZoneId)) {
                if (nextChar == 'Z') {
                    context.setParsed(ZoneOffset.UTC);
                    return position + 1;
                }
                return ~position;
            }
            context.setParsed(ZoneId.of(parsedZoneId));
            return position + parsedZoneId.length();
        }

        private int parsePrefixedOffset(DateTimeParseContext context, CharSequence text, int position) {
            DateTimeParseContext newContext = context.copy();
            int endPos = OffsetIdPrinterParser.INSTANCE_ID.parse(newContext, text, position);
            if (endPos < 0) {
                context.setParsed(ZoneOffset.UTC);
                return position;
            }
            int offset = (int)newContext.getParsed(ChronoField.OFFSET_SECONDS).longValue();
            ZoneOffset zone = ZoneOffset.ofTotalSeconds(offset);
            context.setParsed(zone);
            return endPos;
        }

        private static SubstringTree prepareParser(Set<String> availableIDs) {
            ArrayList<String> ids = new ArrayList<String>(availableIDs);
            Collections.sort(ids, LENGTH_SORT);
            SubstringTree tree = new SubstringTree(((String)ids.get(0)).length());
            for (String id : ids) {
                tree.add(id);
            }
            return tree;
        }

        public String toString() {
            return this.description;
        }

        private static final class SubstringTree {
            final int length;
            private final Map<CharSequence, SubstringTree> substringMap = new HashMap<CharSequence, SubstringTree>();

            private SubstringTree(int length) {
                this.length = length;
            }

            private SubstringTree get(CharSequence substring2) {
                return this.substringMap.get(substring2);
            }

            private void add(String newSubstring) {
                int idLen = newSubstring.length();
                if (idLen == this.length) {
                    this.substringMap.put(newSubstring, null);
                } else if (idLen > this.length) {
                    String substring = newSubstring.substring(0, this.length);
                    SubstringTree parserTree = this.substringMap.get(substring);
                    if (parserTree == null) {
                        parserTree = new SubstringTree(idLen);
                        this.substringMap.put(substring, parserTree);
                    }
                    parserTree.add(newSubstring);
                }
            }
        }
    }

    static final class ZoneTextPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle textStyle;

        ZoneTextPrinterParser(TextStyle textStyle) {
            this.textStyle = Objects.requireNonNull(textStyle, "textStyle");
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            ZoneId zone = context.getValue(TemporalQueries.zoneId());
            if (zone == null) {
                return false;
            }
            buf.append(zone.getId());
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ZoneText(" + (Object)((Object)this.textStyle) + ")";
        }
    }

    static final class OffsetIdPrinterParser
    implements DateTimePrinterParser {
        static final String[] PATTERNS = new String[]{"+HH", "+HHmm", "+HH:mm", "+HHMM", "+HH:MM", "+HHMMss", "+HH:MM:ss", "+HHMMSS", "+HH:MM:SS"};
        static final OffsetIdPrinterParser INSTANCE_ID = new OffsetIdPrinterParser("Z", "+HH:MM:ss");
        private final String noOffsetText;
        private final int type;

        OffsetIdPrinterParser(String noOffsetText, String pattern) {
            Objects.requireNonNull(noOffsetText, "noOffsetText");
            Objects.requireNonNull(pattern, "pattern");
            this.noOffsetText = noOffsetText;
            this.type = this.checkPattern(pattern);
        }

        private int checkPattern(String pattern) {
            for (int i = 0; i < PATTERNS.length; ++i) {
                if (!PATTERNS[i].equals(pattern)) continue;
                return i;
            }
            throw new IllegalArgumentException("Invalid zone offset pattern: " + pattern);
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            Long offsetSecs = context.getValue(ChronoField.OFFSET_SECONDS);
            if (offsetSecs == null) {
                return false;
            }
            int totalSecs = Jdk8Methods.safeToInt(offsetSecs);
            if (totalSecs == 0) {
                buf.append(this.noOffsetText);
            } else {
                int absHours = Math.abs(totalSecs / 3600 % 100);
                int absMinutes = Math.abs(totalSecs / 60 % 60);
                int absSeconds = Math.abs(totalSecs % 60);
                int bufPos = buf.length();
                int output = absHours;
                buf.append(totalSecs < 0 ? "-" : "+").append((char)(absHours / 10 + 48)).append((char)(absHours % 10 + 48));
                if (this.type >= 3 || this.type >= 1 && absMinutes > 0) {
                    buf.append(this.type % 2 == 0 ? ":" : "").append((char)(absMinutes / 10 + 48)).append((char)(absMinutes % 10 + 48));
                    output += absMinutes;
                    if (this.type >= 7 || this.type >= 5 && absSeconds > 0) {
                        buf.append(this.type % 2 == 0 ? ":" : "").append((char)(absSeconds / 10 + 48)).append((char)(absSeconds % 10 + 48));
                        output += absSeconds;
                    }
                }
                if (output == 0) {
                    buf.setLength(bufPos);
                    buf.append(this.noOffsetText);
                }
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            char sign;
            int length = text.length();
            int noOffsetLen = this.noOffsetText.length();
            if (noOffsetLen == 0) {
                if (position == length) {
                    return context.setParsedField(ChronoField.OFFSET_SECONDS, 0L, position, position);
                }
            } else {
                if (position == length) {
                    return ~position;
                }
                if (context.subSequenceEquals(text, position, this.noOffsetText, 0, noOffsetLen)) {
                    return context.setParsedField(ChronoField.OFFSET_SECONDS, 0L, position, position + noOffsetLen);
                }
            }
            if ((sign = text.charAt(position)) == '+' || sign == '-') {
                int negative = sign == '-' ? -1 : 1;
                int[] array = new int[4];
                array[0] = position + 1;
                if (!(this.parseNumber(array, 1, text, true) || this.parseNumber(array, 2, text, this.type >= 3) || this.parseNumber(array, 3, text, false))) {
                    long offsetSecs = (long)negative * ((long)array[1] * 3600L + (long)array[2] * 60L + (long)array[3]);
                    return context.setParsedField(ChronoField.OFFSET_SECONDS, offsetSecs, position, array[0]);
                }
            }
            if (noOffsetLen == 0) {
                return context.setParsedField(ChronoField.OFFSET_SECONDS, 0L, position, position + noOffsetLen);
            }
            return ~position;
        }

        private boolean parseNumber(int[] array, int arrayIndex, CharSequence parseText, boolean required) {
            if ((this.type + 3) / 2 < arrayIndex) {
                return false;
            }
            int pos = array[0];
            if (this.type % 2 == 0 && arrayIndex > 1) {
                if (pos + 1 > parseText.length() || parseText.charAt(pos) != ':') {
                    return required;
                }
                ++pos;
            }
            if (pos + 2 > parseText.length()) {
                return required;
            }
            char ch1 = parseText.charAt(pos++);
            char ch2 = parseText.charAt(pos++);
            if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9') {
                return required;
            }
            int value = (ch1 - 48) * 10 + (ch2 - 48);
            if (value < 0 || value > 59) {
                return required;
            }
            array[arrayIndex] = value;
            array[0] = pos;
            return false;
        }

        public String toString() {
            String converted = this.noOffsetText.replace("'", "''");
            return "Offset('" + converted + "'," + PATTERNS[this.type] + ")";
        }
    }

    static final class InstantPrinterParser
    implements DateTimePrinterParser {
        private static final long SECONDS_PER_10000_YEARS = 315569520000L;
        private static final long SECONDS_0000_TO_1970 = 62167219200L;
        private static final CompositePrinterParser PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).appendLiteral('Z').toFormatter().toPrinterParser(false);

        InstantPrinterParser() {
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            Long inSecs = context.getValue(ChronoField.INSTANT_SECONDS);
            Long inNanos = context.getValue(ChronoField.NANO_OF_SECOND);
            if (inSecs == null || inNanos == null) {
                return false;
            }
            long inSec = inSecs;
            int inNano = ChronoField.NANO_OF_SECOND.checkValidIntValue(inNanos);
            if (inSec >= -62167219200L) {
                long zeroSecs = inSec - 315569520000L + 62167219200L;
                long hi = Jdk8Methods.floorDiv(zeroSecs, 315569520000L) + 1L;
                long lo = Jdk8Methods.floorMod(zeroSecs, 315569520000L);
                LocalDateTime ldt = LocalDateTime.ofEpochSecond(lo - 62167219200L, inNano, ZoneOffset.UTC);
                if (hi > 0L) {
                    buf.append('+').append(hi);
                }
                buf.append(ldt).append('Z');
            } else {
                long zeroSecs = inSec + 62167219200L;
                long hi = zeroSecs / 315569520000L;
                long lo = zeroSecs % 315569520000L;
                LocalDateTime ldt = LocalDateTime.ofEpochSecond(lo - 62167219200L, inNano, ZoneOffset.UTC);
                int pos = buf.length();
                buf.append(ldt).append('Z');
                if (hi < 0L) {
                    if (ldt.getYear() == -10000) {
                        buf.replace(pos, pos + 2, Long.toString(hi - 1L));
                    } else if (lo == 0L) {
                        buf.insert(pos, hi);
                    } else {
                        buf.insert(pos + 1, Math.abs(hi));
                    }
                }
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            DateTimeParseContext newContext = context.copy();
            int pos = PARSER.parse(newContext, text, position);
            if (pos < 0) {
                return pos;
            }
            long yearParsed = newContext.getParsed(ChronoField.YEAR);
            int month = newContext.getParsed(ChronoField.MONTH_OF_YEAR).intValue();
            int day = newContext.getParsed(ChronoField.DAY_OF_MONTH).intValue();
            int hour = newContext.getParsed(ChronoField.HOUR_OF_DAY).intValue();
            int min = newContext.getParsed(ChronoField.MINUTE_OF_HOUR).intValue();
            Long secVal = newContext.getParsed(ChronoField.SECOND_OF_MINUTE);
            Long nanoVal = newContext.getParsed(ChronoField.NANO_OF_SECOND);
            int sec = secVal != null ? secVal.intValue() : 0;
            int nano = nanoVal != null ? nanoVal.intValue() : 0;
            int year = (int)yearParsed % 10000;
            try {
                LocalDateTime ldt = LocalDateTime.of(year, month, day, hour, min, sec, 0);
                long instantSecs = ldt.toEpochSecond(ZoneOffset.UTC);
            }
            catch (RuntimeException ex) {
                return ~position;
            }
            int successPos = text.length();
            successPos = context.setParsedField(ChronoField.INSTANT_SECONDS, instantSecs += Jdk8Methods.safeMultiply(yearParsed / 10000L, 315569520000L), position, successPos);
            return context.setParsedField(ChronoField.NANO_OF_SECOND, nano, position, successPos);
        }

        public String toString() {
            return "Instant()";
        }
    }

    static final class TextPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final TextStyle textStyle;
        private final DateTimeTextProvider provider;
        private volatile NumberPrinterParser numberPrinterParser;

        TextPrinterParser(TemporalField field, TextStyle textStyle, DateTimeTextProvider provider) {
            this.field = field;
            this.textStyle = textStyle;
            this.provider = provider;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            Long value = context.getValue(this.field);
            if (value == null) {
                return false;
            }
            String text = this.provider.getText(this.field, value, this.textStyle, context.getLocale());
            if (text == null) {
                return this.numberPrinterParser().print(context, buf);
            }
            buf.append(text);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence parseText, int position) {
            int length = parseText.length();
            if (position < 0 || position > length) {
                throw new IndexOutOfBoundsException();
            }
            TextStyle style = context.isStrict() ? this.textStyle : null;
            Iterator<Map.Entry<String, Long>> it = this.provider.getTextIterator(this.field, style, context.getLocale());
            if (it != null) {
                while (it.hasNext()) {
                    Map.Entry<String, Long> entry = it.next();
                    String itText = entry.getKey();
                    if (!context.subSequenceEquals(itText, 0, parseText, position, itText.length())) continue;
                    return context.setParsedField(this.field, entry.getValue(), position, position + itText.length());
                }
                if (context.isStrict()) {
                    return ~position;
                }
            }
            return this.numberPrinterParser().parse(context, parseText, position);
        }

        private NumberPrinterParser numberPrinterParser() {
            if (this.numberPrinterParser == null) {
                this.numberPrinterParser = new NumberPrinterParser(this.field, 1, 19, SignStyle.NORMAL);
            }
            return this.numberPrinterParser;
        }

        public String toString() {
            if (this.textStyle == TextStyle.FULL) {
                return "Text(" + this.field.getName() + ")";
            }
            return "Text(" + this.field.getName() + "," + (Object)((Object)this.textStyle) + ")";
        }
    }

    static final class FractionPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final int minWidth;
        private final int maxWidth;
        private final boolean decimalPoint;

        FractionPrinterParser(TemporalField field, int minWidth, int maxWidth, boolean decimalPoint) {
            Objects.requireNonNull(field, "field");
            if (!field.range().isFixed()) {
                throw new IllegalArgumentException("Field must have a fixed set of values: " + field.getName());
            }
            if (minWidth < 0 || minWidth > 9) {
                throw new IllegalArgumentException("Minimum width must be from 0 to 9 inclusive but was " + minWidth);
            }
            if (maxWidth < 1 || maxWidth > 9) {
                throw new IllegalArgumentException("Maximum width must be from 1 to 9 inclusive but was " + maxWidth);
            }
            if (maxWidth < minWidth) {
                throw new IllegalArgumentException("Maximum width must exceed or equal the minimum width but " + maxWidth + " < " + minWidth);
            }
            this.field = field;
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
            this.decimalPoint = decimalPoint;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            Long value = context.getValue(this.field);
            if (value == null) {
                return false;
            }
            DateTimeFormatSymbols symbols = context.getSymbols();
            BigDecimal fraction = this.convertToFraction(value);
            if (fraction.scale() == 0) {
                if (this.minWidth > 0) {
                    if (this.decimalPoint) {
                        buf.append(symbols.getDecimalSeparator());
                    }
                    for (int i = 0; i < this.minWidth; ++i) {
                        buf.append(symbols.getZeroDigit());
                    }
                }
            } else {
                int outputScale = Math.min(Math.max(fraction.scale(), this.minWidth), this.maxWidth);
                fraction = fraction.setScale(outputScale, RoundingMode.FLOOR);
                String str = fraction.toPlainString().substring(2);
                str = symbols.convertNumberToI18N(str);
                if (this.decimalPoint) {
                    buf.append(symbols.getDecimalSeparator());
                }
                buf.append(str);
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            int minEndPos;
            int effectiveMin = context.isStrict() ? this.minWidth : 0;
            int effectiveMax = context.isStrict() ? this.maxWidth : 9;
            int length = text.length();
            if (position == length) {
                return effectiveMin > 0 ? ~position : position;
            }
            if (this.decimalPoint) {
                if (text.charAt(position) != context.getSymbols().getDecimalSeparator()) {
                    return effectiveMin > 0 ? ~position : position;
                }
                ++position;
            }
            if ((minEndPos = position + effectiveMin) > length) {
                return ~position;
            }
            int maxEndPos = Math.min(position + effectiveMax, length);
            int total = 0;
            int pos = position;
            while (pos < maxEndPos) {
                char ch = text.charAt(pos++);
                int digit = context.getSymbols().convertToDigit(ch);
                if (digit < 0) {
                    if (pos < minEndPos) {
                        return ~position;
                    }
                    --pos;
                    break;
                }
                total = total * 10 + digit;
            }
            BigDecimal fraction = new BigDecimal(total).movePointLeft(pos - position);
            long value = this.convertFromFraction(fraction);
            return context.setParsedField(this.field, value, position, pos);
        }

        private BigDecimal convertToFraction(long value) {
            ValueRange range = this.field.range();
            range.checkValidValue(value, this.field);
            BigDecimal minBD = BigDecimal.valueOf(range.getMinimum());
            BigDecimal rangeBD = BigDecimal.valueOf(range.getMaximum()).subtract(minBD).add(BigDecimal.ONE);
            BigDecimal valueBD = BigDecimal.valueOf(value).subtract(minBD);
            BigDecimal fraction = valueBD.divide(rangeBD, 9, RoundingMode.FLOOR);
            return fraction.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : fraction.stripTrailingZeros();
        }

        private long convertFromFraction(BigDecimal fraction) {
            ValueRange range = this.field.range();
            BigDecimal minBD = BigDecimal.valueOf(range.getMinimum());
            BigDecimal rangeBD = BigDecimal.valueOf(range.getMaximum()).subtract(minBD).add(BigDecimal.ONE);
            BigDecimal valueBD = fraction.multiply(rangeBD).setScale(0, RoundingMode.FLOOR).add(minBD);
            return valueBD.longValueExact();
        }

        public String toString() {
            String decimal = this.decimalPoint ? ",DecimalPoint" : "";
            return "Fraction(" + this.field.getName() + "," + this.minWidth + "," + this.maxWidth + decimal + ")";
        }
    }

    static final class ReducedPrinterParser
    extends NumberPrinterParser {
        private final int baseValue;
        private final int range;

        ReducedPrinterParser(TemporalField field, int width, int baseValue) {
            super(field, width, width, SignStyle.NOT_NEGATIVE);
            if (width < 1 || width > 18) {
                throw new IllegalArgumentException("The width must be from 1 to 18 inclusive but was " + width);
            }
            if (!field.range().isValidValue(baseValue)) {
                throw new IllegalArgumentException("The base value must be within the range of the field");
            }
            this.baseValue = baseValue;
            this.range = EXCEED_POINTS[width];
            if ((long)baseValue + (long)this.range > Integer.MAX_VALUE) {
                throw new DateTimeException("Unable to add printer-parser as the range exceeds the capacity of an int");
            }
        }

        @Override
        long getValue(long value) {
            return Math.abs(value % (long)this.range);
        }

        @Override
        int setValue(DateTimeParseContext context, long value, int errorPos, int successPos) {
            int lastPart = this.baseValue % this.range;
            value = this.baseValue > 0 ? (long)(this.baseValue - lastPart) + value : (long)(this.baseValue - lastPart) - value;
            if (value < (long)this.baseValue) {
                value += (long)this.range;
            }
            return context.setParsedField(this.field, value, errorPos, successPos);
        }

        @Override
        NumberPrinterParser withFixedWidth() {
            return this;
        }

        @Override
        boolean isFixedWidth() {
            return true;
        }

        @Override
        public String toString() {
            return "ReducedValue(" + this.field.getName() + "," + this.minWidth + "," + this.baseValue + ")";
        }
    }

    static class NumberPrinterParser
    implements DateTimePrinterParser {
        static final int[] EXCEED_POINTS = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        final TemporalField field;
        final int minWidth;
        private final int maxWidth;
        private final SignStyle signStyle;
        private final int subsequentWidth;

        NumberPrinterParser(TemporalField field, int minWidth, int maxWidth, SignStyle signStyle) {
            this.field = field;
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
            this.signStyle = signStyle;
            this.subsequentWidth = 0;
        }

        private NumberPrinterParser(TemporalField field, int minWidth, int maxWidth, SignStyle signStyle, int subsequentWidth) {
            this.field = field;
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
            this.signStyle = signStyle;
            this.subsequentWidth = subsequentWidth;
        }

        NumberPrinterParser withFixedWidth() {
            return new NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, -1);
        }

        NumberPrinterParser withSubsequentWidth(int subsequentWidth) {
            return new NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, this.subsequentWidth + subsequentWidth);
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            String str;
            Long valueLong = context.getValue(this.field);
            if (valueLong == null) {
                return false;
            }
            long value = this.getValue(valueLong);
            DateTimeFormatSymbols symbols = context.getSymbols();
            String string = str = value == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(value));
            if (str.length() > this.maxWidth) {
                throw new DateTimeException("Field " + this.field.getName() + " cannot be printed as the value " + value + " exceeds the maximum print width of " + this.maxWidth);
            }
            str = symbols.convertNumberToI18N(str);
            if (value >= 0L) {
                switch (this.signStyle) {
                    case EXCEEDS_PAD: {
                        if (this.minWidth >= 19 || value < (long)EXCEED_POINTS[this.minWidth]) break;
                        buf.append(symbols.getPositiveSign());
                        break;
                    }
                    case ALWAYS: {
                        buf.append(symbols.getPositiveSign());
                    }
                }
            } else {
                switch (this.signStyle) {
                    case EXCEEDS_PAD: 
                    case ALWAYS: 
                    case NORMAL: {
                        buf.append(symbols.getNegativeSign());
                        break;
                    }
                    case NOT_NEGATIVE: {
                        throw new DateTimeException("Field " + this.field.getName() + " cannot be printed as the value " + value + " cannot be negative according to the SignStyle");
                    }
                }
            }
            for (int i = 0; i < this.minWidth - str.length(); ++i) {
                buf.append(symbols.getZeroDigit());
            }
            buf.append(str);
            return true;
        }

        long getValue(long value) {
            return value;
        }

        boolean isFixedWidth() {
            return this.subsequentWidth == -1;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            int length = text.length();
            if (position == length) {
                return ~position;
            }
            char sign = text.charAt(position);
            boolean negative = false;
            boolean positive = false;
            if (sign == context.getSymbols().getPositiveSign()) {
                if (!this.signStyle.parse(true, context.isStrict(), this.minWidth == this.maxWidth)) {
                    return ~position;
                }
                positive = true;
                ++position;
            } else if (sign == context.getSymbols().getNegativeSign()) {
                if (!this.signStyle.parse(false, context.isStrict(), this.minWidth == this.maxWidth)) {
                    return ~position;
                }
                negative = true;
                ++position;
            } else if (this.signStyle == SignStyle.ALWAYS && context.isStrict()) {
                return ~position;
            }
            int effMinWidth = context.isStrict() || this.isFixedWidth() ? this.minWidth : 1;
            int minEndPos = position + effMinWidth;
            if (minEndPos > length) {
                return ~position;
            }
            int effMaxWidth = this.maxWidth + Math.max(this.subsequentWidth, 0);
            long total = 0L;
            BigInteger totalBig = null;
            int pos = position;
            for (int pass = 0; pass < 2; ++pass) {
                int maxEndPos = Math.min(pos + effMaxWidth, length);
                while (pos < maxEndPos) {
                    char ch = text.charAt(pos++);
                    int digit = context.getSymbols().convertToDigit(ch);
                    if (digit < 0) {
                        if (--pos >= minEndPos) break;
                        return ~position;
                    }
                    if (pos - position > 18) {
                        if (totalBig == null) {
                            totalBig = BigInteger.valueOf(total);
                        }
                        totalBig = totalBig.multiply(BigInteger.TEN).add(BigInteger.valueOf(digit));
                        continue;
                    }
                    total = total * 10L + (long)digit;
                }
                if (this.subsequentWidth <= 0 || pass != 0) break;
                int parseLen = pos - position;
                effMaxWidth = Math.max(effMinWidth, parseLen - this.subsequentWidth);
                pos = position;
                total = 0L;
                totalBig = null;
            }
            if (negative) {
                if (totalBig != null) {
                    if (totalBig.equals(BigInteger.ZERO) && context.isStrict()) {
                        return ~(position - 1);
                    }
                    totalBig = totalBig.negate();
                } else {
                    if (total == 0L && context.isStrict()) {
                        return ~(position - 1);
                    }
                    total = -total;
                }
            } else if (this.signStyle == SignStyle.EXCEEDS_PAD && context.isStrict()) {
                int parseLen = pos - position;
                if (positive) {
                    if (parseLen <= this.minWidth) {
                        return ~(position - 1);
                    }
                } else if (parseLen > this.minWidth) {
                    return ~position;
                }
            }
            if (totalBig != null) {
                if (totalBig.bitLength() > 63) {
                    totalBig = totalBig.divide(BigInteger.TEN);
                    --pos;
                }
                return this.setValue(context, totalBig.longValue(), position, pos);
            }
            return this.setValue(context, total, position, pos);
        }

        int setValue(DateTimeParseContext context, long value, int errorPos, int successPos) {
            return context.setParsedField(this.field, value, errorPos, successPos);
        }

        public String toString() {
            if (this.minWidth == 1 && this.maxWidth == 19 && this.signStyle == SignStyle.NORMAL) {
                return "Value(" + this.field.getName() + ")";
            }
            if (this.minWidth == this.maxWidth && this.signStyle == SignStyle.NOT_NEGATIVE) {
                return "Value(" + this.field.getName() + "," + this.minWidth + ")";
            }
            return "Value(" + this.field.getName() + "," + this.minWidth + "," + this.maxWidth + "," + (Object)((Object)this.signStyle) + ")";
        }
    }

    static final class StringLiteralPrinterParser
    implements DateTimePrinterParser {
        private final String literal;

        StringLiteralPrinterParser(String literal) {
            this.literal = literal;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            buf.append(this.literal);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            int length = text.length();
            if (position > length || position < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!context.subSequenceEquals(text, position, this.literal, 0, this.literal.length())) {
                return ~position;
            }
            return position + this.literal.length();
        }

        public String toString() {
            String converted = this.literal.replace("'", "''");
            return "'" + converted + "'";
        }
    }

    static final class CharLiteralPrinterParser
    implements DateTimePrinterParser {
        private final char literal;

        CharLiteralPrinterParser(char literal) {
            this.literal = literal;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            buf.append(this.literal);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            int length = text.length();
            if (position == length) {
                return ~position;
            }
            char ch = text.charAt(position);
            if (!context.charEquals(this.literal, ch)) {
                return ~position;
            }
            return position + 1;
        }

        public String toString() {
            if (this.literal == '\'') {
                return "''";
            }
            return "'" + this.literal + "'";
        }
    }

    static enum SettingsParser implements DateTimePrinterParser
    {
        SENSITIVE,
        INSENSITIVE,
        STRICT,
        LENIENT;


        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            switch (this.ordinal()) {
                case 0: {
                    context.setCaseSensitive(true);
                    break;
                }
                case 1: {
                    context.setCaseSensitive(false);
                    break;
                }
                case 2: {
                    context.setStrict(true);
                    break;
                }
                case 3: {
                    context.setStrict(false);
                }
            }
            return position;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "ParseCaseSensitive(true)";
                }
                case 1: {
                    return "ParseCaseSensitive(false)";
                }
                case 2: {
                    return "ParseStrict(true)";
                }
                case 3: {
                    return "ParseStrict(false)";
                }
            }
            throw new IllegalStateException("Unreachable");
        }
    }

    static final class PadPrinterParserDecorator
    implements DateTimePrinterParser {
        private final DateTimePrinterParser printerParser;
        private final int padWidth;
        private final char padChar;

        PadPrinterParserDecorator(DateTimePrinterParser printerParser, int padWidth, char padChar) {
            this.printerParser = printerParser;
            this.padWidth = padWidth;
            this.padChar = padChar;
        }

        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            int preLen = buf.length();
            if (!this.printerParser.print(context, buf)) {
                return false;
            }
            int len = buf.length() - preLen;
            if (len > this.padWidth) {
                throw new DateTimeException("Cannot print as output of " + len + " characters exceeds pad width of " + this.padWidth);
            }
            for (int i = 0; i < this.padWidth - len; ++i) {
                buf.insert(preLen, this.padChar);
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            int pos;
            boolean strict = context.isStrict();
            boolean caseSensitive = context.isCaseSensitive();
            if (position > text.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (position == text.length()) {
                return ~position;
            }
            int endPos = position + this.padWidth;
            if (endPos > text.length()) {
                if (strict) {
                    return ~position;
                }
                endPos = text.length();
            }
            for (pos = position; pos < endPos && (caseSensitive ? text.charAt(pos) == this.padChar : context.charEquals(text.charAt(pos), this.padChar)); ++pos) {
            }
            int resultPos = this.printerParser.parse(context, text = text.subSequence(0, endPos), pos);
            if (resultPos != endPos && strict) {
                return ~(position + pos);
            }
            return resultPos;
        }

        public String toString() {
            return "Pad(" + this.printerParser + "," + this.padWidth + (this.padChar == ' ' ? ")" : ",'" + this.padChar + "')");
        }
    }

    static final class CompositePrinterParser
    implements DateTimePrinterParser {
        private final DateTimePrinterParser[] printerParsers;
        private final boolean optional;

        CompositePrinterParser(List<DateTimePrinterParser> printerParsers, boolean optional) {
            this(printerParsers.toArray(new DateTimePrinterParser[printerParsers.size()]), optional);
        }

        CompositePrinterParser(DateTimePrinterParser[] printerParsers, boolean optional) {
            this.printerParsers = printerParsers;
            this.optional = optional;
        }

        public CompositePrinterParser withOptional(boolean optional) {
            if (optional == this.optional) {
                return this;
            }
            return new CompositePrinterParser(this.printerParsers, optional);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean print(DateTimePrintContext context, StringBuilder buf) {
            int length = buf.length();
            if (this.optional) {
                context.startOptional();
            }
            try {
                for (DateTimePrinterParser pp : this.printerParsers) {
                    if (pp.print(context, buf)) continue;
                    buf.setLength(length);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (this.optional) {
                    context.endOptional();
                }
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext context, CharSequence text, int position) {
            DateTimePrinterParser pp;
            if (this.optional) {
                context.startOptional();
                int pos = position;
                for (DateTimePrinterParser pp2 : this.printerParsers) {
                    if ((pos = pp2.parse(context, text, pos)) >= 0) continue;
                    context.endOptional(false);
                    return position;
                }
                context.endOptional(true);
                return pos;
            }
            DateTimePrinterParser[] arr$ = this.printerParsers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (position = (pp = arr$[i$]).parse(context, text, position)) >= 0; ++i$) {
            }
            return position;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.printerParsers != null) {
                buf.append(this.optional ? "[" : "(");
                for (DateTimePrinterParser pp : this.printerParsers) {
                    buf.append(pp);
                }
                buf.append(this.optional ? "]" : ")");
            }
            return buf.toString();
        }
    }

    static interface DateTimePrinterParser {
        public boolean print(DateTimePrintContext var1, StringBuilder var2);

        public int parse(DateTimeParseContext var1, CharSequence var2, int var3);
    }
}

