/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.ZoneId;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.IsoChronology;
import org.threeten.bp.format.DateTimeBuilder;
import org.threeten.bp.format.DateTimeFormatSymbols;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;

final class DateTimeParseContext {
    private Locale locale;
    private DateTimeFormatSymbols symbols;
    private Chronology chronology;
    private boolean caseSensitive = true;
    private boolean strict = true;
    private final ArrayList<Parsed> parsed = new ArrayList();

    DateTimeParseContext(DateTimeFormatter formatter) {
        this.locale = formatter.getLocale();
        this.symbols = formatter.getSymbols();
        this.chronology = formatter.getChronology();
        this.parsed.add(new Parsed());
    }

    DateTimeParseContext(Locale locale, DateTimeFormatSymbols symbols, Chronology chronology) {
        this.locale = locale;
        this.symbols = symbols;
        this.chronology = chronology;
        this.parsed.add(new Parsed());
    }

    DateTimeParseContext copy() {
        return new DateTimeParseContext(this.locale, this.symbols, this.chronology);
    }

    Locale getLocale() {
        return this.locale;
    }

    DateTimeFormatSymbols getSymbols() {
        return this.symbols;
    }

    Chronology getEffectiveChronology() {
        Chronology chrono = this.currentParsed().chrono;
        if (chrono == null && (chrono = this.chronology) == null) {
            chrono = IsoChronology.INSTANCE;
        }
        return chrono;
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    boolean subSequenceEquals(CharSequence cs1, int offset1, CharSequence cs2, int offset2, int length) {
        if (offset1 + length > cs1.length() || offset2 + length > cs2.length()) {
            return false;
        }
        if (this.isCaseSensitive()) {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i)) || Character.toUpperCase(ch1) == Character.toUpperCase(ch2) || Character.toLowerCase(ch1) == Character.toLowerCase(ch2)) continue;
                return false;
            }
        }
        return true;
    }

    boolean charEquals(char ch1, char ch2) {
        if (this.isCaseSensitive()) {
            return ch1 == ch2;
        }
        return DateTimeParseContext.charEqualsIgnoreCase(ch1, ch2);
    }

    static boolean charEqualsIgnoreCase(char c1, char c2) {
        return c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    boolean isStrict() {
        return this.strict;
    }

    void setStrict(boolean strict) {
        this.strict = strict;
    }

    void startOptional() {
        this.parsed.add(this.currentParsed().copy());
    }

    void endOptional(boolean successful) {
        if (successful) {
            this.parsed.remove(this.parsed.size() - 2);
        } else {
            this.parsed.remove(this.parsed.size() - 1);
        }
    }

    private Parsed currentParsed() {
        return this.parsed.get(this.parsed.size() - 1);
    }

    Long getParsed(TemporalField field) {
        return this.currentParsed().fieldValues.get(field);
    }

    int setParsedField(TemporalField field, long value, int errorPos, int successPos) {
        Objects.requireNonNull(field, "field");
        Long old = this.currentParsed().fieldValues.put(field, value);
        return old != null && old != value ? ~errorPos : successPos;
    }

    void setParsed(Chronology chrono) {
        Objects.requireNonNull(chrono, "chrono");
        this.currentParsed().chrono = chrono;
    }

    void setParsed(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        this.currentParsed().zone = zone;
    }

    Parsed toParsed() {
        return this.currentParsed();
    }

    public String toString() {
        return this.currentParsed().toString();
    }

    void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        this.locale = locale;
    }

    final class Parsed
    extends DefaultInterfaceTemporalAccessor {
        Chronology chrono = null;
        ZoneId zone = null;
        final Map<TemporalField, Long> fieldValues = new HashMap<TemporalField, Long>();

        private Parsed() {
        }

        protected Parsed copy() {
            Parsed cloned = new Parsed();
            cloned.chrono = this.chrono;
            cloned.zone = this.zone;
            cloned.fieldValues.putAll(this.fieldValues);
            return cloned;
        }

        public String toString() {
            return this.fieldValues.toString() + "," + this.chrono + "," + this.zone;
        }

        @Override
        public boolean isSupported(TemporalField field) {
            return this.fieldValues.containsKey(field);
        }

        @Override
        public int get(TemporalField field) {
            if (!this.fieldValues.containsKey(field)) {
                throw new DateTimeException("Unsupported field: " + field);
            }
            long value = this.fieldValues.get(field);
            return Jdk8Methods.safeToInt(value);
        }

        @Override
        public long getLong(TemporalField field) {
            if (!this.fieldValues.containsKey(field)) {
                throw new DateTimeException("Unsupported field: " + field);
            }
            return this.fieldValues.get(field);
        }

        @Override
        public <R> R query(TemporalQuery<R> query) {
            if (query == TemporalQueries.chronology()) {
                return (R)this.chrono;
            }
            if (query == TemporalQueries.zoneId() || query == TemporalQueries.zone()) {
                return (R)this.zone;
            }
            return super.query(query);
        }

        Parsed resolveFields() {
            block0: while (true) {
                for (Map.Entry<TemporalField, Long> entry : this.fieldValues.entrySet()) {
                    TemporalField targetField = entry.getKey();
                    Map<TemporalField, Long> changes = targetField.resolve(this, entry.getValue());
                    if (changes == null) continue;
                    this.resolveMakeChanges(targetField, changes);
                    this.fieldValues.remove(targetField);
                    continue block0;
                }
                break;
            }
            return this;
        }

        private void resolveMakeChanges(TemporalField targetField, Map<TemporalField, Long> changes) {
            for (Map.Entry<TemporalField, Long> change : changes.entrySet()) {
                TemporalField changeField = change.getKey();
                Long changeValue = change.getValue();
                Objects.requireNonNull(changeField, "changeField");
                if (changeValue != null) {
                    Long old = this.fieldValues.put(changeField, changeValue);
                    if (old == null || old.longValue() == changeValue.longValue()) continue;
                    throw new DateTimeException("Conflict found: " + changeField + " " + old + " differs from " + changeField + " " + changeValue + " while resolving  " + targetField);
                }
                this.fieldValues.remove(changeField);
            }
        }

        DateTimeBuilder toBuilder() {
            DateTimeBuilder builder = new DateTimeBuilder();
            for (Map.Entry<TemporalField, Long> fv : this.fieldValues.entrySet()) {
                builder.addFieldValue(fv.getKey(), fv.getValue());
            }
            if (this.chrono != null) {
                builder.addObject(this.chrono);
            } else if (DateTimeParseContext.this.chronology != null) {
                builder.addObject(DateTimeParseContext.this.chronology);
            }
            if (this.zone != null) {
                builder.addObject(this.zone);
            }
            return builder;
        }
    }
}

