/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.util.Locale;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.format.DateTimeFormatSymbols;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.ValueRange;

final class DateTimePrintContext {
    private TemporalAccessor temporal;
    private Locale locale;
    private DateTimeFormatSymbols symbols;
    private int optional;

    DateTimePrintContext(TemporalAccessor temporal, DateTimeFormatter formatter) {
        this.temporal = DateTimePrintContext.adjust(temporal, formatter);
        this.locale = formatter.getLocale();
        this.symbols = formatter.getSymbols();
    }

    DateTimePrintContext(TemporalAccessor temporal, Locale locale, DateTimeFormatSymbols symbols) {
        this.temporal = temporal;
        this.locale = locale;
        this.symbols = symbols;
    }

    private static TemporalAccessor adjust(final TemporalAccessor temporal, DateTimeFormatter formatter) {
        Chronology overrideChrono = formatter.getChronology();
        ZoneId overrideZone = formatter.getZone();
        if (overrideChrono == null && overrideZone == null) {
            return temporal;
        }
        Chronology temporalChrono = Chronology.from(temporal);
        ZoneId temporalZone = temporal.query(TemporalQueries.zone());
        if (!temporal.isSupported(ChronoField.EPOCH_DAY) || Objects.equals(overrideChrono, temporalChrono)) {
            overrideChrono = null;
        }
        if (!temporal.isSupported(ChronoField.INSTANT_SECONDS) || Objects.equals(overrideZone, temporalZone)) {
            overrideZone = null;
        }
        if (overrideChrono == null && overrideZone == null) {
            return temporal;
        }
        if (overrideChrono != null && overrideZone != null) {
            return overrideChrono.zonedDateTime(Instant.from(temporal), overrideZone);
        }
        if (overrideZone != null) {
            return temporalChrono.zonedDateTime(Instant.from(temporal), overrideZone);
        }
        final ChronoLocalDate<?> date = overrideChrono.date(temporal);
        return new DefaultInterfaceTemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField field) {
                return temporal.isSupported(field);
            }

            @Override
            public ValueRange range(TemporalField field) {
                if (field instanceof ChronoField) {
                    if (((ChronoField)field).isDateField()) {
                        return date.range(field);
                    }
                    return temporal.range(field);
                }
                return field.rangeRefinedBy(this);
            }

            @Override
            public long getLong(TemporalField field) {
                if (field instanceof ChronoField) {
                    if (((ChronoField)field).isDateField()) {
                        return date.getLong(field);
                    }
                    return temporal.getLong(field);
                }
                return field.getFrom(this);
            }

            @Override
            public <R> R query(TemporalQuery<R> query) {
                if (query == TemporalQueries.chronology()) {
                    return (R)date.getChronology();
                }
                if (query == TemporalQueries.zoneId() || query == TemporalQueries.precision()) {
                    return temporal.query(query);
                }
                return query.queryFrom(this);
            }
        };
    }

    TemporalAccessor getTemporal() {
        return this.temporal;
    }

    Locale getLocale() {
        return this.locale;
    }

    DateTimeFormatSymbols getSymbols() {
        return this.symbols;
    }

    void startOptional() {
        ++this.optional;
    }

    void endOptional() {
        --this.optional;
    }

    <R> R getValue(TemporalQuery<R> query) {
        R result = this.temporal.query(query);
        if (result == null && this.optional == 0) {
            throw new DateTimeException("Unable to extract value: " + this.temporal.getClass());
        }
        return result;
    }

    Long getValue(TemporalField field) {
        try {
            return this.temporal.getLong(field);
        }
        catch (DateTimeException ex) {
            if (this.optional > 0) {
                return null;
            }
            throw ex;
        }
    }

    public String toString() {
        return this.temporal.toString();
    }

    void setDateTime(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        this.temporal = temporal;
    }

    void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        this.locale = locale;
    }
}

