/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.struct;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thshsh.struct.ByteCountMismatchException;
import org.thshsh.struct.ByteOrder;
import org.thshsh.struct.ConstantMismatchException;
import org.thshsh.struct.CountMismatchException;
import org.thshsh.struct.LengthMismatchException;
import org.thshsh.struct.Mapping;
import org.thshsh.struct.MappingException;
import org.thshsh.struct.Packer;
import org.thshsh.struct.StructEntityMapping;
import org.thshsh.struct.Token;
import org.thshsh.struct.TokenType;
import org.thshsh.struct.ZeroCountException;

public class Struct<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(Struct.class);
    private static final Map<Character, ByteOrder> BYTE_ORDER_MAP = new HashMap<Character, ByteOrder>();
    protected List<Token> tokens = new ArrayList<Token>();
    protected ByteOrder byteOrder;
    protected Charset charset;
    protected Class<T> entityClass;
    protected Boolean pad = false;
    protected Boolean trimAndPad = false;

    public Struct() {
        this(null, null);
    }

    public Struct(ByteOrder byteOrder, Charset charset) {
        this.byteOrder = byteOrder != null ? byteOrder : ByteOrder.nativeOrder();
        this.charset = charset != null ? charset : Charset.defaultCharset();
    }

    public Struct<T> appendToken(Token t) {
        this.tokens.add(t);
        return this;
    }

    public Struct<T> appendTokens(Iterable<Token> it) {
        it.forEach(t -> this.tokens.add((Token)t));
        return this;
    }

    public Struct<T> insertToken(Token t, int index) {
        this.tokens.add(index, t);
        return this;
    }

    public Struct<T> appendToken(TokenType type, int countOrLength) {
        return this.appendToken(new Token(type, countOrLength));
    }

    public Struct<T> insertToken(TokenType type, int countOrLength, int index) {
        return this.insertToken(new Token(type, countOrLength), index);
    }

    public Struct<T> byteOrder(ByteOrder bo) {
        this.byteOrder = bo;
        return this;
    }

    public Struct<T> charset(Charset cs) {
        this.charset = cs;
        return this;
    }

    public Struct<T> trimAndPad(boolean b) {
        this.trimAndPad = b;
        return this;
    }

    public int byteCount() {
        int size = 0;
        for (Token t : this.tokens) {
            size += t.byteCount();
        }
        return size;
    }

    public int tokenCount() {
        int count = 0;
        for (Token t : this.tokens) {
            if (t.hide.booleanValue()) continue;
            count += t.tokenCount();
        }
        return count;
    }

    public T unpackEntity(InputStream stream) throws IOException {
        return this.unpackEntity(this.entityClass, stream);
    }

    public T unpackEntity(byte[] bytes) {
        return this.unpackEntity(this.entityClass, bytes);
    }

    public <V> V unpackEntity(Class<V> c, InputStream stream) throws IOException {
        byte[] buffer = new byte[this.byteCount()];
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        return this.unpackEntity(c, buffer);
    }

    public <V> V unpackEntity(Class<V> c, ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(this.byteCount());
        IOUtils.readFully((ReadableByteChannel)channel, (ByteBuffer)buffer);
        return this.unpackEntity(c, buffer.array());
    }

    public <V> V unpackEntity(Class<V> c, byte[] bytes) {
        try {
            StructEntityMapping<V> config = StructEntityMapping.get(c);
            config.validate(this);
            List<Object> values = this.unpack(bytes);
            V instance = c.newInstance();
            Iterator<Object> valuesIt = values.iterator();
            Iterator<Mapping> mapit = config.mappings.iterator();
            while (valuesIt.hasNext()) {
                Object value = valuesIt.next();
                Mapping mapping = mapit.next();
                mapping.setValue(instance, value);
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MappingException(c, (Exception)e);
        }
    }

    public byte[] packEntity(Object o) {
        try {
            StructEntityMapping<?> config = StructEntityMapping.get(o.getClass());
            config.validate(this);
            ArrayList<Object> values = new ArrayList<Object>();
            for (Mapping mapping : config.mappings) {
                Object value = mapping.getValue(o);
                values.add(value);
            }
            return this.pack(values);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MappingException(o.getClass(), (Exception)e);
        }
    }

    public byte[] pack(Object ... objects) {
        return this.pack(Arrays.asList(objects));
    }

    public byte[] pack(List<Object> vals) {
        int tokenCount = this.tokenCount();
        if (tokenCount != vals.size()) {
            throw new CountMismatchException(tokenCount, vals.size());
        }
        byte[] result = new byte[this.byteCount()];
        int position = 0;
        Iterator<Token> tokens = this.tokens.iterator();
        Iterator<Object> values = vals.iterator();
        LOGGER.debug("Packing values: {}", vals);
        while (tokens.hasNext()) {
            Token token = tokens.next();
            LOGGER.debug("Packing token: {}", (Object)token);
            int length = token.length;
            for (int i = 0; i < token.tokenCount(); ++i) {
                Object val;
                if (token.isConstant()) {
                    val = token.constant;
                    if (!token.hide.booleanValue()) {
                        values.next();
                    }
                } else {
                    val = values.next();
                }
                LOGGER.debug("Packing val: {}", val);
                byte[] packedBytes = this.pack(token, val);
                if (packedBytes.length != length) {
                    throw new ByteCountMismatchException(length, packedBytes.length, val);
                }
                System.arraycopy(packedBytes, 0, result, position, packedBytes.length);
                position += packedBytes.length;
            }
        }
        return result;
    }

    protected byte[] pack(Token token, Object val) {
        byte[] packedBytes;
        TokenType type = token.type;
        java.nio.ByteOrder byteOrder = this.byteOrder.getByteOrder();
        switch (type) {
            case Short: {
                packedBytes = Packer.packRaw_16b((Short)val, byteOrder);
                break;
            }
            case ShortUnsigned: {
                packedBytes = Packer.packRaw_u16b((Integer)val, byteOrder);
                break;
            }
            case Integer: {
                packedBytes = Packer.packRaw_32b((Integer)val & 0xFFFFFFFF, byteOrder);
                break;
            }
            case IntegerUnsigned: {
                packedBytes = Packer.packRaw_u32b((Long)val, byteOrder);
                break;
            }
            case LongUnsigned: {
                val = ((BigInteger)val).longValue();
            }
            case Long: 
            case LongUnsignedToSigned: {
                packedBytes = Packer.packRaw_64b((Long)val & 0xFFFFFFFFFFFFFFFFL, byteOrder);
                break;
            }
            case Double: {
                packedBytes = Packer.packFloat_64b((Double)val, byteOrder);
                break;
            }
            case Bytes: {
                packedBytes = (byte[])val;
                break;
            }
            case String: {
                String string = (String)val;
                if (string.length() != token.length) {
                    if (!this.trimAndPad.booleanValue() || token.isConstant()) {
                        throw new LengthMismatchException(token.length, string.length());
                    }
                    string = StringUtils.rightPad((String)string, (int)token.length);
                }
                packedBytes = string.getBytes(this.charset);
                break;
            }
            case Boolean: {
                packedBytes = new byte[]{(Boolean)val != false ? (byte)1 : 0};
                break;
            }
            case Byte: {
                packedBytes = new byte[]{(Byte)val};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled case: " + (Object)((Object)token.type));
            }
        }
        return packedBytes;
    }

    public List<Object> unpack(InputStream stream) throws IOException {
        byte[] buffer = new byte[this.byteCount()];
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        return this.unpack(buffer);
    }

    public List<Object> unpack(byte[] vals) {
        Struct format = this;
        int len = format.byteCount();
        if (len != vals.length) {
            throw new ByteCountMismatchException(len, vals.length);
        }
        ArrayList<Object> tokens = new ArrayList<Object>();
        byte[][] arrays = new byte[][]{null, new byte[1], new byte[2], null, new byte[4], null, null, null, new byte[8]};
        ByteArrayInputStream bs = new ByteArrayInputStream(vals);
        int position = 0;
        try {
            block2: for (int t = 0; t < format.tokens.size(); ++t) {
                Token token = format.tokens.get(t);
                for (int i = 0; i < token.tokenCount(); ++i) {
                    LOGGER.debug("position: {}", (Object)position);
                    byte[] ar = token.type.array ? new byte[token.length] : arrays[token.type.size];
                    boolean trim = token.isConstant() ? false : this.trimAndPad;
                    Object o = Struct.unpack(token.type, this.byteOrder, this.charset, ar, bs, trim);
                    LOGGER.debug("unpacked: '{}'", o);
                    if (token.isConstant()) {
                        LOGGER.debug("expecting: '{}'", token.constant);
                        if (token.validate.booleanValue() && !token.type.equalsFunction.apply(token.constant, o).booleanValue()) {
                            throw new ConstantMismatchException(t, token.constant, o);
                        }
                    }
                    if (!token.hide.booleanValue()) {
                        tokens.add(o);
                    } else {
                        LOGGER.debug("hiding token");
                    }
                    position += ar.length;
                    if (token.type.array) continue block2;
                }
            }
            LOGGER.debug("end position: {}", (Object)position);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception reading in memory byte array", e);
        }
        LOGGER.debug("unpacked: {}", tokens);
        return tokens;
    }

    public static Struct<List<Object>> create(String fmt) {
        return Struct.create(fmt, null);
    }

    public static <T> Struct<T> create(Class<T> structClass) {
        LOGGER.debug("create: {}", structClass);
        return StructEntityMapping.get(structClass).createStruct();
    }

    public static Struct<List<Object>> create(String fmt, Charset cs) {
        Struct<List<Object>> format = new Struct<List<Object>>(null, cs);
        Character x = null;
        StringBuilder countOrLengthBuffer = new StringBuilder();
        for (int i = 0; i < fmt.length(); ++i) {
            x = Character.valueOf(fmt.charAt(i));
            if (BYTE_ORDER_MAP.keySet().contains(x)) {
                format.byteOrder = BYTE_ORDER_MAP.get(x);
                continue;
            }
            if (Character.isDigit(x.charValue())) {
                countOrLengthBuffer.append(x);
                continue;
            }
            TokenType type = TokenType.fromCharacter(x.charValue());
            int countOrLength = 1;
            if (countOrLengthBuffer.length() > 0) {
                countOrLength = Integer.valueOf(countOrLengthBuffer.toString());
                if (countOrLength < 1) {
                    throw new ZeroCountException();
                }
                countOrLengthBuffer.setLength(0);
            }
            format.appendToken(type, countOrLength);
        }
        return format;
    }

    public static Object unpack(TokenType type, ByteOrder bo, InputStream is) throws IOException {
        return Struct.unpack(type, bo, Charset.defaultCharset(), new byte[type.size], is, null);
    }

    public static Object unpack(TokenType type, ByteOrder bo, byte[] bytes) throws IOException {
        return Struct.unpack(type, bo, Charset.defaultCharset(), bytes);
    }

    public static Object unpack(TokenType type, int length, Charset charset, InputStream is) throws IOException {
        return Struct.unpack(type, ByteOrder.nativeOrder(), charset, new byte[length], is, null);
    }

    public static Object unpack(TokenType type, InputStream is) throws IOException {
        return Struct.unpack(type, ByteOrder.nativeOrder(), Charset.defaultCharset(), new byte[type.size], is, null);
    }

    public static Object unpack(TokenType type, Integer length, ByteOrder byteOrder, Charset charset, InputStream bs) throws IOException {
        byte[] bytes = new byte[length.intValue()];
        IOUtils.readFully((InputStream)bs, (byte[])bytes);
        return Struct.unpack(type, byteOrder, charset, bytes);
    }

    public static Object unpack(TokenType type, ByteOrder byteOrder, Charset charset, byte[] bytes, InputStream bs, Boolean trim) throws IOException {
        IOUtils.readFully((InputStream)bs, (byte[])bytes);
        return Struct.unpack(type, byteOrder, charset, bytes, trim);
    }

    public static Object unpack(TokenType type, ByteOrder order, Charset charset, byte[] bytes) throws IOException {
        return Struct.unpack(type, order, charset, bytes, (Boolean)null);
    }

    public static Object unpack(TokenType type, ByteOrder order, Charset charset, byte[] bytes, Boolean trim) throws IOException {
        if (trim == null) {
            trim = false;
        }
        java.nio.ByteOrder byteOrder = order.getByteOrder();
        LOGGER.debug("unpacking: 0x{}", (Object)Hex.encodeHexString((byte[])bytes));
        switch (type) {
            case ShortUnsigned: {
                return Packer.unpackRaw_u16b(bytes, byteOrder);
            }
            case Short: {
                return Packer.unpackRaw_16b(bytes, byteOrder);
            }
            case IntegerUnsigned: {
                return Packer.unpackRaw_u32b(bytes, byteOrder);
            }
            case Integer: {
                return Packer.unpackRaw_32b(bytes, byteOrder);
            }
            case LongUnsigned: {
                return new BigInteger(Long.toUnsignedString(Packer.unpackRaw_64b(bytes, byteOrder)));
            }
            case LongUnsignedToSigned: {
                return new BigInteger(Long.toUnsignedString(Packer.unpackRaw_64b(bytes, byteOrder))).longValueExact();
            }
            case Long: {
                return Packer.unpackRaw_64b(bytes, byteOrder);
            }
            case Double: {
                return Packer.unpackFloat_64b(bytes, byteOrder);
            }
            case Bytes: {
                return bytes;
            }
            case String: {
                String string = new String(bytes, charset);
                if (trim.booleanValue()) {
                    string = string.trim();
                }
                return string;
            }
            case Byte: {
                return bytes[0];
            }
            case Boolean: {
                return bytes[0] != 0;
            }
        }
        throw new IllegalArgumentException("unhandled case: " + (Object)((Object)type));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[tokens=");
        builder.append(this.tokens);
        builder.append(", byteOrder=");
        builder.append((Object)this.byteOrder);
        builder.append(", charset=");
        builder.append(this.charset);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.byteOrder == null ? 0 : this.byteOrder.hashCode());
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.tokens == null ? 0 : this.tokens.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Struct other = (Struct)obj;
        if (this.byteOrder == null ? other.byteOrder != null : !this.byteOrder.equals((Object)other.byteOrder)) {
            return false;
        }
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        return !(this.tokens == null ? other.tokens != null : !this.tokens.equals(other.tokens));
    }

    static {
        BYTE_ORDER_MAP.put(Character.valueOf('>'), ByteOrder.Big);
        BYTE_ORDER_MAP.put(Character.valueOf('<'), ByteOrder.Little);
        BYTE_ORDER_MAP.put(Character.valueOf('!'), ByteOrder.Big);
        BYTE_ORDER_MAP.put(Character.valueOf('@'), ByteOrder.nativeOrder());
    }
}

