/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.struct;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thshsh.struct.CountMismatchException;
import org.thshsh.struct.Mapping;
import org.thshsh.struct.MappingException;
import org.thshsh.struct.Struct;
import org.thshsh.struct.StructEntity;
import org.thshsh.struct.StructToken;
import org.thshsh.struct.StructTokenPrefix;
import org.thshsh.struct.StructTokenSuffix;
import org.thshsh.struct.Token;
import org.thshsh.struct.TokenType;

public class StructEntityMapping<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructEntityMapping.class);
    protected static final Map<Class<?>, StructEntityMapping<?>> CACHE = new HashMap();
    protected Class<T> structClass;
    protected Struct<T> struct;
    protected StructEntity classAnnotation;
    protected List<Mapping> mappings;

    public StructEntityMapping(Class<T> structClass, StructEntity classAnnotation, List<Mapping> p) {
        this.classAnnotation = classAnnotation;
        this.structClass = structClass;
        this.mappings = p;
        this.struct = StructEntityMapping.createStruct(this);
    }

    public Struct<T> createStruct() {
        return StructEntityMapping.createStruct(this);
    }

    public void validate(Struct<?> struct) {
        if (!this.struct.tokens.equals(struct.tokens)) {
            LOGGER.error("struct tokens: {} do not match class tokens: {}", struct.tokens, this.struct.tokens);
            throw new CountMismatchException(struct.tokens.size(), this.struct.tokens.size());
        }
    }

    protected static <T> StructEntityMapping<T> create(Class<T> structClass) {
        Mapping mapping;
        StructEntity sc = structClass.getAnnotation(StructEntity.class);
        ArrayList<Mapping> properties = new ArrayList<Mapping>();
        for (PropertyDescriptor d : PropertyUtils.getPropertyDescriptors(structClass)) {
            Mapping mapping2 = null;
            Method method = null;
            Class<?> type = null;
            if (d.getReadMethod() != null && d.getReadMethod().isAnnotationPresent(StructToken.class)) {
                method = d.getReadMethod();
                type = method.getReturnType();
            } else if (d.getWriteMethod() != null && d.getWriteMethod().isAnnotationPresent(StructToken.class)) {
                method = d.getWriteMethod();
                type = method.getParameterTypes()[0];
            }
            if (method == null) continue;
            mapping2 = new Mapping(d, null, method.getAnnotation(StructToken.class), method.getAnnotation(StructTokenPrefix.class), method.getAnnotation(StructTokenSuffix.class), type);
            properties.add(mapping2);
        }
        Class<T> search = structClass;
        do {
            for (Field field : search.getDeclaredFields()) {
                if (!field.isAnnotationPresent(StructToken.class)) continue;
                StructToken annotation = field.getAnnotation(StructToken.class);
                StructTokenPrefix pre = field.getAnnotation(StructTokenPrefix.class);
                StructTokenSuffix suf = field.getAnnotation(StructTokenSuffix.class);
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), search);
                    mapping = new Mapping(pd, null, annotation, pre, suf, field.getType());
                    properties.add(mapping);
                }
                catch (IntrospectionException e) {
                    if (!Modifier.isPublic(field.getModifiers()) && StringUtils.isEmpty((CharSequence)annotation.constant())) {
                        throw new MappingException("Field " + field.getName() + " has no property accessors and is not public or a constant", (Exception)e);
                    }
                    mapping = new Mapping(null, field, annotation, pre, suf, field.getType());
                    properties.add(mapping);
                }
            }
        } while ((search = search.getSuperclass()) != null);
        if (properties.size() == 0) {
            throw new MappingException("No Struct properties found on class " + structClass.getCanonicalName());
        }
        Collections.sort(properties, (p0, p1) -> Integer.valueOf(p0.annotation.order()).compareTo(p1.annotation.order()));
        HashSet<Object> orders = new HashSet<Object>();
        HashSet<Integer> offsets = new HashSet<Integer>();
        TreeMap<Integer, Mapping> offsetMap = new TreeMap<Integer, Mapping>();
        Integer length = 0;
        for (Mapping m : properties) {
            Integer order = m.annotation.order();
            Integer offset = m.annotation.offset();
            if (order.equals(Integer.MIN_VALUE) && offset.equals(Integer.MIN_VALUE) || !order.equals(Integer.MIN_VALUE) && !offset.equals(Integer.MIN_VALUE)) {
                throw new MappingException("One of Index or Offset must be specified for mapped token on entity: " + structClass);
            }
            if (order.equals(Integer.MIN_VALUE)) {
                if (offsets.contains(offset)) {
                    throw new MappingException("Found two StructTokens at offset " + offset + " for entity " + structClass);
                }
                offsets.add(offset);
                offsetMap.put(offset, m);
                continue;
            }
            if (orders.contains(order)) {
                throw new MappingException("Found two StructTokens at index " + order + " for entity " + structClass);
            }
            if (offsets.contains(length)) {
                throw new MappingException("Found two StructTokens at offset " + length + " for entity " + structClass);
            }
            LOGGER.debug("deriving offset from order: {} = {}", (Object)order, (Object)length);
            orders.add(order);
            offsets.add(length);
            offsetMap.put(length, m);
            length = length + m.length;
        }
        LOGGER.debug("offsetMap: {}", offsetMap);
        ArrayList<Mapping> finalList = new ArrayList<Mapping>();
        Integer currentOffset = 0;
        for (Integer offset : offsetMap.keySet()) {
            mapping = (Mapping)offsetMap.get(offset);
            LOGGER.debug("offset: {} has mapping: {}", (Object)offset, (Object)mapping.token);
            LOGGER.debug("currentOffset: {}", (Object)currentOffset);
            if (offset.equals(currentOffset)) {
                finalList.add(mapping);
            } else {
                LOGGER.debug("Offset is off by {}", (Object)(offset - currentOffset));
                mapping.addPrefixBytes(offset - currentOffset);
            }
            currentOffset = currentOffset + mapping.length;
        }
        properties.sort((f0, f1) -> Integer.valueOf(f0.annotation.order()).compareTo(f1.annotation.order()));
        StructEntityMapping<T> config = new StructEntityMapping<T>(structClass, sc, properties);
        return config;
    }

    public static <T> StructEntityMapping<T> get(Class<T> classs) {
        if (!CACHE.containsKey(classs)) {
            CACHE.put(classs, StructEntityMapping.create(classs));
        }
        return CACHE.get(classs);
    }

    public static <T> Struct<T> createStruct(StructEntityMapping<T> config) {
        Struct s = new Struct();
        s.entityClass = config.structClass;
        if (config.classAnnotation != null) {
            if (StringUtils.isNotBlank((CharSequence)config.classAnnotation.charset())) {
                s.charset = Charset.forName(config.classAnnotation.charset());
            }
            s.byteOrder(config.classAnnotation.byteOrder()).trimAndPad(config.classAnnotation.trimAndPad());
        }
        for (Mapping mapping : config.mappings) {
            s.appendTokens(mapping.prefixTokens);
            s.appendToken(mapping.token);
            s.appendTokens(mapping.suffixTokens);
        }
        return s;
    }

    public static Token annotationToToken(StructToken anno) {
        return StructEntityMapping.annotationToToken(anno, anno.type());
    }

    public static Token annotationToToken(StructToken anno, TokenType type) {
        if (type == null) {
            if (anno.type() == TokenType.Auto) {
                throw new MappingException("Type must be specified for annotation: " + anno);
            }
            type = anno.type();
        }
        int length = anno.length();
        Object constantValue = null;
        if (StringUtils.isNotEmpty((CharSequence)anno.constant())) {
            if (type.convert == null) {
                throw new MappingException("Cannot specify constants for TokenType: " + (Object)((Object)type));
            }
            constantValue = type.convert(anno.constant());
            length = type.length(constantValue);
        }
        Token t = new Token(type, 1, length, constantValue, anno.validate());
        return t;
    }
}

