/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.struct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thshsh.struct.MappingException;
import org.thshsh.struct.TokenType;

public class Token {
    public static final Logger LOGGER = LoggerFactory.getLogger(Token.class);
    protected TokenType type;
    protected int count;
    protected int length;
    protected int byteCount;
    protected Object constant;
    protected Boolean hide = false;
    protected Boolean validate = true;

    public Token(TokenType type, int countOrLength) {
        this(type, type.array ? 1 : countOrLength, type.array ? countOrLength : 0, null, true);
    }

    public Token(TokenType t, int count, int len, Object constant, boolean val) {
        this.type = t;
        if (!this.type.array && len != 0 && len != this.type.size) {
            throw new MappingException("Length: " + len + " cannot be specified for Struct Token type: " + (Object)((Object)this.type));
        }
        this.length = this.type.array ? len : this.type.size;
        this.count = count;
        if (count == 0) {
            throw new MappingException("Count cannot be zero");
        }
        if (this.length < 0) {
            throw new MappingException("Length cannot be negative");
        }
        this.constant = constant;
        this.validate = val;
        this.byteCount = count * this.length;
    }

    public int tokenCount() {
        return this.count;
    }

    public int length() {
        return this.length;
    }

    public int byteCount() {
        return this.byteCount;
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[type=");
        builder.append((Object)this.type);
        builder.append(", count=");
        builder.append(this.count);
        builder.append(", length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + this.length;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.type == other.type;
    }
}

