/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.struct;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.thshsh.struct.StructToken;

public enum TokenType {
    Short(2, false, "h", Short.class, Short::valueOf, null, Objects::equals),
    Integer(4, false, "il", Integer.class, Integer::valueOf, null, Objects::equals),
    Long(8, false, "q", Long.class, Long::valueOf, null, Objects::equals),
    ShortUnsigned(2, false, "H", true, Integer.class, Integer::valueOf, null, Objects::equals),
    IntegerUnsigned(4, false, "I", true, Long.class, Long::valueOf, null, Objects::equals),
    LongUnsigned(8, false, "Q", true, BigInteger.class, s -> new BigInteger((String)s), null, Objects::equals),
    LongUnsignedToSigned(8, false, "R", true, Long.class, s -> new BigInteger((String)s).longValueExact(), null, Objects::equals),
    Double(8, false, "d", Double.class, Double::valueOf, null, Objects::equals),
    Bytes(1, true, "s", byte[].class, s -> {
        try {
            return Hex.decodeHex((String)s);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }, s -> ((byte[])s).length, (o1, o2) -> Arrays.equals((byte[])o1, (byte[])o2)),
    Byte(1, false, "cb", Byte.class, Byte::valueOf, null, Objects::equals),
    String(1, true, "S", String.class, String::valueOf, s -> ((String)s).length(), Objects::equals),
    Boolean(1, false, "t", Boolean.class, Boolean::valueOf, null, Objects::equals),
    Auto(1, false, "a", null, null, null, null);

    int size;
    boolean array;
    String characters;
    Class<?> defaultClass;
    boolean unsigned;
    Function<String, ?> convert;
    ToIntFunction<Object> lengthFunction;
    BiFunction<Object, Object, Boolean> equalsFunction;

    private TokenType(int size, boolean ar, String chars, Class<?> defaultClass, Function<String, ?> convert, ToIntFunction<Object> l, BiFunction<Object, Object, Boolean> equalsFunction) {
        this(size, ar, chars, false, defaultClass, convert, l, equalsFunction);
    }

    private TokenType(int size, boolean ar, String chars, boolean unsigned, Class<?> defaultClass, Function<String, ?> convert, ToIntFunction<Object> l, BiFunction<Object, Object, Boolean> equalsFunction) {
        this.size = size;
        this.array = ar;
        this.defaultClass = defaultClass;
        this.characters = chars;
        this.unsigned = unsigned;
        this.convert = convert;
        this.lengthFunction = l;
        this.equalsFunction = equalsFunction;
    }

    public int size() {
        return this.size;
    }

    public Object convert(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return this.convert.apply(value);
    }

    public int length(Object value) {
        if (value == null) {
            return 0;
        }
        if (this.lengthFunction == null) {
            return this.size;
        }
        return this.lengthFunction.applyAsInt(value);
    }

    public static TokenType fromCharacter(char c) {
        for (TokenType type : TokenType.values()) {
            if (type.characters.indexOf(c) <= -1) continue;
            return type;
        }
        throw new IllegalArgumentException();
    }

    public static TokenType fromField(Field field) {
        StructToken st = field.getAnnotation(StructToken.class);
        Class<?> classs = field.getType();
        for (TokenType type : TokenType.values()) {
            if (!classs.equals(type.defaultClass) || st.unsigned() != type.unsigned) continue;
            return type;
        }
        throw new IllegalArgumentException();
    }

    public static TokenType fromClass(Class<?> classs, boolean unsigned) {
        for (TokenType type : TokenType.values()) {
            if (!classs.equals(type.defaultClass)) continue;
            return type;
        }
        throw new IllegalArgumentException("Cant create token type for: " + classs);
    }
}

