/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.conditionalcomments.util;

import org.thymeleaf.extras.conditionalcomments.util.ConditionalCommentParsingResult;

public final class ConditionalCommentUtils {
    public static boolean isConditionalComment(String text) {
        return ConditionalCommentUtils.parseConditionalComment(text) != null;
    }

    public static ConditionalCommentParsingResult parseConditionalComment(String text) {
        int i;
        int len = text.length();
        for (i = 0; i < len && Character.isWhitespace(text.charAt(i)); ++i) {
        }
        if (i >= len || text.charAt(i++) != '[') {
            return null;
        }
        int startExpressionOffset = i;
        while (i < len && text.charAt(i) != ']') {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        int startExpressionLen = i - startExpressionOffset;
        ++i;
        while (i < len && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        if (i >= len || text.charAt(i++) != '>') {
            return null;
        }
        int contentOffset = i;
        for (i = len - 1; i > contentOffset && Character.isWhitespace(text.charAt(i)); --i) {
        }
        if (i <= contentOffset || text.charAt(i--) != ']') {
            return null;
        }
        int endExpressionLastPos = i + 1;
        while (i > contentOffset && text.charAt(i) != '[') {
            --i;
        }
        if (i <= contentOffset) {
            return null;
        }
        int endExpressionOffset = i + 1;
        int endExpressionLen = endExpressionLastPos - endExpressionOffset;
        --i;
        while (i >= contentOffset && Character.isWhitespace(text.charAt(i))) {
            --i;
        }
        if (i <= contentOffset || text.charAt(i--) != '!') {
            return null;
        }
        if (i <= contentOffset || text.charAt(i--) != '<') {
            return null;
        }
        int contentLen = i + 1 - contentOffset;
        if (contentLen <= 0 || startExpressionLen <= 0 || endExpressionLen <= 0) {
            return null;
        }
        return new ConditionalCommentParsingResult(text, startExpressionOffset, startExpressionLen, contentOffset, contentLen, endExpressionOffset, endExpressionLen);
    }

    private ConditionalCommentUtils() {
    }
}

