/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.auth;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.extras.springsecurity3.auth.ISpringVersionSpecificUtility;
import org.thymeleaf.extras.springsecurity3.util.SpringVersionUtils;
import org.thymeleaf.util.ClassLoaderUtils;

final class SpringVersionSpecificUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SpringVersionSpecificUtils.class);
    private static final String PACKAGE_NAME = SpringVersionSpecificUtils.class.getPackage().getName();
    private static final String SPRING3_DELEGATE_CLASS = PACKAGE_NAME + ".Spring3VersionSpecificUtility";
    private static final String SPRING4_DELEGATE_CLASS = PACKAGE_NAME + ".Spring4VersionSpecificUtility";
    private static final ISpringVersionSpecificUtility spring3Delegate;
    private static final ISpringVersionSpecificUtility spring4Delegate;

    static EvaluationContext wrapEvaluationContext(EvaluationContext evaluationContext, IExpressionObjects expresionObjects) {
        if (spring4Delegate != null) {
            return spring4Delegate.wrapEvaluationContext(evaluationContext, expresionObjects);
        }
        if (spring3Delegate != null) {
            return spring3Delegate.wrapEvaluationContext(evaluationContext, expresionObjects);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently Spring 3.0, 3.1, 3.2 and 4.x are supported.");
    }

    private SpringVersionSpecificUtils() {
    }

    static {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(SpringVersionSpecificUtils.class);
        if (SpringVersionUtils.isSpring40AtLeast()) {
            LOG.trace("[THYMELEAF][TESTING] Spring 4.0+ found on classpath. Initializing auth utility for Spring 4");
            try {
                Class<?> implClass = Class.forName(SPRING4_DELEGATE_CLASS, true, classLoader);
                spring4Delegate = (ISpringVersionSpecificUtility)implClass.newInstance();
                spring3Delegate = null;
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError((Throwable)new ConfigurationException("Environment has been detected to be at least Spring 4, but thymeleaf could not initialize a delegate of class \"" + SPRING4_DELEGATE_CLASS + "\"", (Throwable)e));
            }
        } else if (SpringVersionUtils.isSpring30AtLeast()) {
            LOG.trace("[THYMELEAF][TESTING] Spring 3.x found on classpath. Initializing auth utility for Spring 3");
            try {
                Class<?> implClass = Class.forName(SPRING3_DELEGATE_CLASS, true, classLoader);
                spring3Delegate = (ISpringVersionSpecificUtility)implClass.newInstance();
                spring4Delegate = null;
            }
            catch (Exception e) {
                throw new ConfigurationException("Environment has been detected to be Spring 3.x, but thymeleaf could not initialize a delegate of class \"" + SPRING3_DELEGATE_CLASS + "\"", (Throwable)e);
            }
        } else {
            throw new ConfigurationException("The auth infrastructure could not create utility for the specific version of Spring beingused. Currently Spring 3.0, 3.1, 3.2 and 4.x are supported.");
        }
    }
}

