/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.util;

import org.springframework.core.SpringVersion;
import org.thymeleaf.util.ClassLoaderUtils;

public final class SpringVersionUtils {
    private static final int SPRING_VERSION_MAJOR;
    private static final int SPRING_VERSION_MINOR;

    private static boolean testClassExistence(String className) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(org.thymeleaf.spring4.util.SpringVersionUtils.class);
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static int getSpringVersionMajor() {
        return SPRING_VERSION_MAJOR;
    }

    public static int getSpringVersionMinor() {
        return SPRING_VERSION_MINOR;
    }

    public static boolean isSpring30AtLeast() {
        return SPRING_VERSION_MAJOR >= 3;
    }

    public static boolean isSpring31AtLeast() {
        return SPRING_VERSION_MAJOR > 3 || SPRING_VERSION_MAJOR == 3 && SPRING_VERSION_MINOR >= 1;
    }

    public static boolean isSpring32AtLeast() {
        return SPRING_VERSION_MAJOR > 3 || SPRING_VERSION_MAJOR == 3 && SPRING_VERSION_MINOR >= 2;
    }

    public static boolean isSpring40AtLeast() {
        return SPRING_VERSION_MAJOR >= 4;
    }

    public static boolean isSpring41AtLeast() {
        return SPRING_VERSION_MAJOR > 4 || SPRING_VERSION_MAJOR == 4 && SPRING_VERSION_MINOR >= 1;
    }

    public static boolean isSpring42AtLeast() {
        return SPRING_VERSION_MAJOR > 4 || SPRING_VERSION_MAJOR == 4 && SPRING_VERSION_MINOR >= 2;
    }

    public static boolean isSpring43AtLeast() {
        return SPRING_VERSION_MAJOR > 4 || SPRING_VERSION_MAJOR == 4 && SPRING_VERSION_MINOR >= 3;
    }

    private SpringVersionUtils() {
    }

    static {
        String springVersion = SpringVersion.getVersion();
        if (springVersion != null) {
            try {
                String versionRemainder = springVersion;
                int separatorIdx = versionRemainder.indexOf(46);
                SPRING_VERSION_MAJOR = Integer.parseInt(versionRemainder.substring(0, separatorIdx));
                int separator2Idx = versionRemainder.indexOf(46, separatorIdx + 1);
                SPRING_VERSION_MINOR = Integer.parseInt(versionRemainder.substring(separatorIdx + 1, separator2Idx));
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError("Exception during initialization of Spring versioning utilities. Identified Spring version is '" + springVersion + "', which does not follow the {major}.{minor}.{...} scheme");
            }
        } else if (SpringVersionUtils.testClassExistence("org.springframework.context.annotation.ComponentScans")) {
            SPRING_VERSION_MAJOR = 4;
            SPRING_VERSION_MINOR = 3;
        } else if (SpringVersionUtils.testClassExistence("org.springframework.core.annotation.AliasFor")) {
            SPRING_VERSION_MAJOR = 4;
            SPRING_VERSION_MINOR = 2;
        } else if (SpringVersionUtils.testClassExistence("org.springframework.cache.annotation.CacheConfig")) {
            SPRING_VERSION_MAJOR = 4;
            SPRING_VERSION_MINOR = 1;
        } else if (SpringVersionUtils.testClassExistence("org.springframework.core.io.PathResource")) {
            SPRING_VERSION_MAJOR = 4;
            SPRING_VERSION_MINOR = 0;
        } else if (SpringVersionUtils.testClassExistence("org.springframework.web.context.request.async.DeferredResult")) {
            SPRING_VERSION_MAJOR = 3;
            SPRING_VERSION_MINOR = 2;
        } else if (SpringVersionUtils.testClassExistence("org.springframework.web.servlet.support.RequestDataValueProcessor")) {
            SPRING_VERSION_MAJOR = 3;
            SPRING_VERSION_MINOR = 1;
        } else if (SpringVersionUtils.testClassExistence("org.springframework.web.bind.annotation.RequestBody")) {
            SPRING_VERSION_MAJOR = 3;
            SPRING_VERSION_MINOR = 0;
        } else {
            SPRING_VERSION_MAJOR = 2;
            SPRING_VERSION_MINOR = 5;
        }
    }
}

