/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.dialect.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.extras.springsecurity3.auth.AuthUtils;
import org.thymeleaf.extras.springsecurity3.auth.Authorization;

public class SpringSecurityExpressionObjectFactory
implements IExpressionObjectFactory {
    public static final String AUTHENTICATION_EXPRESSION_OBJECT_NAME = "authentication";
    public static final String AUTHORIZATION_EXPRESSION_OBJECT_NAME = "authorization";
    protected static final Set<String> ALL_EXPRESSION_OBJECT_NAMES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("authentication", "authorization")));

    public Set<String> getAllExpressionObjectNames() {
        return ALL_EXPRESSION_OBJECT_NAMES;
    }

    public boolean isCacheable(String expressionObjectName) {
        return true;
    }

    public Object buildObject(IExpressionContext context, String expressionObjectName) {
        if (AUTHENTICATION_EXPRESSION_OBJECT_NAME.equals(expressionObjectName) && context instanceof IWebContext) {
            return AuthUtils.getAuthenticationObject();
        }
        if (AUTHORIZATION_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            if (context instanceof IWebContext) {
                Authentication authentication = (Authentication)context.getExpressionObjects().getObject(AUTHENTICATION_EXPRESSION_OBJECT_NAME);
                IWebContext webContext = (IWebContext)context;
                HttpServletRequest request = webContext.getRequest();
                HttpServletResponse response = webContext.getResponse();
                ServletContext servletContext = webContext.getServletContext();
                return new Authorization(context, authentication, request, response, servletContext);
            }
            return null;
        }
        return null;
    }
}

