/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity5.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.expression.EvaluationContext;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.extras.springsecurity5.util.ISpringVersionSpecificUtility;
import org.thymeleaf.spring5.context.webflux.ISpringWebFluxContext;
import org.thymeleaf.spring5.expression.ThymeleafEvaluationContextWrapper;

final class Spring5VersionSpecificUtility
implements ISpringVersionSpecificUtility {
    Spring5VersionSpecificUtility() {
    }

    @Override
    public EvaluationContext wrapEvaluationContext(EvaluationContext evaluationContext, IExpressionObjects expresionObjects) {
        ThymeleafEvaluationContextWrapper thymeleafEvaluationContext = new ThymeleafEvaluationContextWrapper(evaluationContext);
        thymeleafEvaluationContext.setExpressionObjects(expresionObjects);
        return thymeleafEvaluationContext;
    }

    @Override
    public boolean isWebContext(IContext context) {
        return context instanceof IWebContext || context instanceof ISpringWebFluxContext;
    }

    @Override
    public boolean isWebMvcContext(IContext context) {
        return context instanceof IWebContext;
    }

    @Override
    public boolean isWebFluxContext(IContext context) {
        return context instanceof ISpringWebFluxContext;
    }

    @Override
    public HttpServletRequest getHttpServletRequest(IContext context) {
        if (context instanceof IWebContext) {
            return ((IWebContext)context).getRequest();
        }
        throw new TemplateProcessingException("Cannot obtain HttpServletRequest from a non-Servlet context implementation (\"" + context.getClass().getName() + "\")");
    }

    @Override
    public HttpServletResponse getHttpServletResponse(IContext context) {
        if (context instanceof IWebContext) {
            return ((IWebContext)context).getResponse();
        }
        throw new TemplateProcessingException("Cannot obtain HttpServletResponse from a non-WebFlux context implementation (\"" + context.getClass().getName() + "\")");
    }

    @Override
    public ServerWebExchange getServerWebExchange(IContext context) {
        if (context instanceof ISpringWebFluxContext) {
            return ((ISpringWebFluxContext)context).getExchange();
        }
        throw new TemplateProcessingException("Cannot obtain ServerWebExchange from a non-WebFlux context implementation (\"" + context.getClass().getName() + "\")");
    }
}

