/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity6.auth;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.WebAttributes;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.extras.springsecurity6.util.SpringSecurityContextUtils;
import org.thymeleaf.extras.springsecurity6.util.SpringVersionSpecificUtils;
import org.thymeleaf.util.Validate;

public final class AuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(AuthUtils.class);

    private AuthUtils() {
    }

    public static Authentication getAuthenticationObject(IExpressionContext context) {
        Authentication authentication;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Obtaining authentication object.", new Object[]{TemplateEngine.threadIndex()});
        }
        if ((authentication = SpringSecurityContextUtils.getAuthenticationObject((IContext)context)) == null || authentication.getPrincipal() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] No authentication object found in context.", new Object[]{TemplateEngine.threadIndex()});
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Authentication object of class {} found in context for user \"{}\".", new Object[]{TemplateEngine.threadIndex(), authentication.getClass().getName(), authentication.getName()});
        }
        return authentication;
    }

    public static Object getAuthenticationProperty(Authentication authentication, String property) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Reading property \"{}\" from authentication object.", new Object[]{TemplateEngine.threadIndex(), property});
        }
        if (authentication == null) {
            return null;
        }
        try {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)authentication);
            Object propertyObj = wrapper.getPropertyValue(property);
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Property \"{}\" obtained from authentication object for user \"{}\". Returned value of class {}.", new Object[]{TemplateEngine.threadIndex(), property, authentication.getName(), propertyObj == null ? null : propertyObj.getClass().getName()});
            }
            return propertyObj;
        }
        catch (BeansException e) {
            throw new TemplateProcessingException("Error retrieving value for property \"" + property + "\" of authentication object of class " + authentication.getClass().getName(), (Throwable)e);
        }
    }

    public static boolean authorizeUsingAccessExpression(IExpressionContext context, String accessExpression, Authentication authentication) {
        boolean authorized;
        Validate.notNull((Object)context, (String)"Context cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checking authorization using access expression \"{}\" for user \"{}\".", new Object[]{TemplateEngine.threadIndex(), accessExpression, authentication == null ? null : authentication.getName()});
        }
        boolean bl = authorized = SpringVersionSpecificUtils.isWebFluxContext((IContext)context) ? WebFluxAuthUtils.authorizeUsingAccessExpressionWebFlux(context, accessExpression, authentication) : MvcAuthUtils.authorizeUsingAccessExpressionMvc(context, accessExpression, authentication);
        if (authorized) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Checked authorization using access expression \"{}\" for user \"{}\". Access GRANTED.", new Object[]{TemplateEngine.threadIndex(), accessExpression, authentication == null ? null : authentication.getName()});
            }
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checked authorization using access expression \"{}\" for user \"{}\". Access DENIED.", new Object[]{TemplateEngine.threadIndex(), accessExpression, authentication == null ? null : authentication.getName()});
        }
        return false;
    }

    private static SecurityExpressionHandler<FilterInvocation> getExpressionHandler(IExpressionContext context) {
        ApplicationContext ctx = AuthUtils.getContext((IContext)context);
        Map expressionHandlers = ctx.getBeansOfType(SecurityExpressionHandler.class);
        for (SecurityExpressionHandler handler : expressionHandlers.values()) {
            Class clazz = GenericTypeResolver.resolveTypeArgument(handler.getClass(), SecurityExpressionHandler.class);
            if (!FilterInvocation.class.equals((Object)GenericTypeResolver.resolveTypeArgument(handler.getClass(), SecurityExpressionHandler.class))) continue;
            return handler;
        }
        throw new TemplateProcessingException("No visible SecurityExpressionHandler instance could be found in the application context. There must be at least one in order to support expressions in Spring Security authorization queries.");
    }

    public static boolean authorizeUsingUrlCheck(IExpressionContext context, String url, String method, Authentication authentication) {
        boolean authorized;
        Validate.notNull((Object)context, (String)"Context cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checking authorization for URL \"{}\" and method \"{}\" for user \"{}\".", new Object[]{TemplateEngine.threadIndex(), url, method, authentication == null ? null : authentication.getName()});
        }
        boolean bl = authorized = SpringVersionSpecificUtils.isWebFluxContext((IContext)context) ? WebFluxAuthUtils.authorizeUsingUrlCheckWebFlux(context, url, method, authentication) : MvcAuthUtils.authorizeUsingUrlCheckMvc(context, url, method, authentication);
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checked authorization for URL \"{}\" and method \"{}\" for user \"{}\". " + (authorized ? "Access GRANTED." : "Access DENIED."), new Object[]{TemplateEngine.threadIndex(), url, method, authentication == null ? null : authentication.getName()});
        }
        return authorized;
    }

    private static WebInvocationPrivilegeEvaluator getPrivilegeEvaluator(IExpressionContext context) {
        WebInvocationPrivilegeEvaluator privEvaluatorFromRequest = (WebInvocationPrivilegeEvaluator)SpringSecurityContextUtils.getRequestAttribute((IContext)context, WebAttributes.WEB_INVOCATION_PRIVILEGE_EVALUATOR_ATTRIBUTE);
        if (privEvaluatorFromRequest != null) {
            return privEvaluatorFromRequest;
        }
        ApplicationContext ctx = AuthUtils.getContext((IContext)context);
        Map privilegeEvaluators = ctx.getBeansOfType(WebInvocationPrivilegeEvaluator.class);
        if (privilegeEvaluators.size() == 0) {
            throw new TemplateProcessingException("No visible WebInvocationPrivilegeEvaluator instance could be found in the application context. There must be at least one in order to support URL access checks in Spring Security authorization queries.");
        }
        return (WebInvocationPrivilegeEvaluator)privilegeEvaluators.values().toArray()[0];
    }

    public static ApplicationContext getContext(IContext context) {
        return SpringSecurityContextUtils.getApplicationContext(context);
    }

    private static final class WebFluxAuthUtils {
        private WebFluxAuthUtils() {
        }

        private static boolean authorizeUsingAccessExpressionWebFlux(IExpressionContext context, String accessExpression, Authentication authentication) {
            if (!MinimalAuthenticationExpressionSupport.isMinimalHandledExpression(accessExpression)) {
                throw new TemplateProcessingException("Authorization-oriented expressions (such as those in 'sec:authorize') are restricted in WebFlux applications due to a lack of support in the reactive side of Spring Security (as of Spring Security 5.1). Only a minimal set of security expressions is allowed: " + MinimalAuthenticationExpressionSupport.HANDLED_EXPRESSIONS);
            }
            return MinimalAuthenticationExpressionSupport.evaluateMinimalExpression(accessExpression, authentication);
        }

        private static boolean authorizeUsingUrlCheckWebFlux(IExpressionContext context, String url, String method, Authentication authentication) {
            throw new TemplateProcessingException("Authorization-oriented expressions (such as those in 'sec:authorize') are restricted in WebFlux applications due to a lack of support in the reactive side of Spring Security (as of Spring Security 5.1). Only a minimal set of security expressions is allowed: " + MinimalAuthenticationExpressionSupport.HANDLED_EXPRESSIONS);
        }
    }

    private static final class MvcAuthUtils {
        private MvcAuthUtils() {
        }

        private static boolean authorizeUsingAccessExpressionMvc(IExpressionContext context, String accessExpression, Authentication authentication) {
            String expr = accessExpression != null && accessExpression.startsWith("${") && accessExpression.endsWith("}") ? accessExpression.substring(2, accessExpression.length() - 1) : accessExpression;
            SecurityExpressionHandler<FilterInvocation> handler = AuthUtils.getExpressionHandler(context);
            Expression expressionObject = null;
            try {
                expressionObject = handler.getExpressionParser().parseExpression(expr);
            }
            catch (ParseException e) {
                throw new TemplateProcessingException("An error happened trying to parse Spring Security access expression \"" + expr + "\"", (Throwable)e);
            }
            HttpServletRequest request = SpringVersionSpecificUtils.getHttpServletRequest((IContext)context);
            HttpServletResponse response = SpringVersionSpecificUtils.getHttpServletResponse((IContext)context);
            FilterInvocation filterInvocation = new FilterInvocation((ServletRequest)request, (ServletResponse)response, ServletFilterChainHolder.DUMMY_CHAIN);
            EvaluationContext evaluationContext = handler.createEvaluationContext(authentication, (Object)filterInvocation);
            IExpressionObjects expressionObjects = context.getExpressionObjects();
            EvaluationContext wrappedEvaluationContext = SpringVersionSpecificUtils.wrapEvaluationContext(evaluationContext, expressionObjects);
            return ExpressionUtils.evaluateAsBoolean((Expression)expressionObject, (EvaluationContext)wrappedEvaluationContext);
        }

        private static boolean authorizeUsingUrlCheckMvc(IExpressionContext context, String url, String method, Authentication authentication) {
            String contextPath = SpringSecurityContextUtils.getContextPath((IContext)context);
            return AuthUtils.getPrivilegeEvaluator(context).isAllowed(contextPath, url, method, authentication);
        }
    }

    private static final class MinimalAuthenticationExpressionSupport {
        private static final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
        private static final String EXPR_ISAUTHENTICATED = "isAuthenticated()";
        private static final String EXPR_ISFULLYAUTHENTICATED = "isFullyAuthenticated()";
        private static final String EXPR_ISANONYMOUS = "isAnonymous()";
        private static final String EXPR_ISREMEMBERME = "isRememberMe()";
        private static final Set<String> HANDLED_EXPRESSIONS = new LinkedHashSet<String>(Arrays.asList("isAuthenticated()", "isFullyAuthenticated()", "isAnonymous()", "isRememberMe()"));

        private MinimalAuthenticationExpressionSupport() {
        }

        static boolean isMinimalHandledExpression(String accessExpression) {
            return HANDLED_EXPRESSIONS.contains(accessExpression);
        }

        static boolean evaluateMinimalExpression(String accessExpression, Authentication authentication) {
            if (EXPR_ISAUTHENTICATED.equals(accessExpression)) {
                return MinimalAuthenticationExpressionSupport.isAuthenticated(authentication);
            }
            if (EXPR_ISFULLYAUTHENTICATED.equals(accessExpression)) {
                return MinimalAuthenticationExpressionSupport.isFullyAuthenticated(authentication);
            }
            if (EXPR_ISANONYMOUS.equals(accessExpression)) {
                return MinimalAuthenticationExpressionSupport.isAnonymous(authentication);
            }
            if (EXPR_ISREMEMBERME.equals(accessExpression)) {
                return MinimalAuthenticationExpressionSupport.isRememberMe(authentication);
            }
            throw new IllegalArgumentException("Unknown minimal expression: \"" + accessExpression + "\". Supported expressions are: " + HANDLED_EXPRESSIONS);
        }

        private static boolean isAnonymous(Authentication authentication) {
            return trustResolver.isAnonymous(authentication);
        }

        private static boolean isAuthenticated(Authentication authentication) {
            return !MinimalAuthenticationExpressionSupport.isAnonymous(authentication);
        }

        private static boolean isRememberMe(Authentication authentication) {
            return trustResolver.isRememberMe(authentication);
        }

        private static boolean isFullyAuthenticated(Authentication authentication) {
            return !trustResolver.isAnonymous(authentication) && !trustResolver.isRememberMe(authentication);
        }
    }

    private static class ServletFilterChainHolder {
        private static final FilterChain DUMMY_CHAIN = new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                throw new UnsupportedOperationException();
            }
        };

        private ServletFilterChainHolder() {
        }
    }
}

