/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity6.dialect.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.extras.springsecurity6.auth.AuthUtils;
import org.thymeleaf.extras.springsecurity6.auth.Authorization;
import org.thymeleaf.extras.springsecurity6.util.SpringVersionSpecificUtils;

public class SpringSecurityExpressionObjectFactory
implements IExpressionObjectFactory {
    public static final String AUTHENTICATION_EXPRESSION_OBJECT_NAME = "authentication";
    public static final String AUTHORIZATION_EXPRESSION_OBJECT_NAME = "authorization";
    protected static final Set<String> ALL_EXPRESSION_OBJECT_NAMES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("authentication", "authorization")));

    public Set<String> getAllExpressionObjectNames() {
        return ALL_EXPRESSION_OBJECT_NAMES;
    }

    public boolean isCacheable(String expressionObjectName) {
        return true;
    }

    public Object buildObject(IExpressionContext context, String expressionObjectName) {
        if (AUTHENTICATION_EXPRESSION_OBJECT_NAME.equals(expressionObjectName) && SpringVersionSpecificUtils.isWebContext((IContext)context)) {
            return AuthUtils.getAuthenticationObject(context);
        }
        if (AUTHORIZATION_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            if (SpringVersionSpecificUtils.isWebContext((IContext)context)) {
                Authentication authentication = (Authentication)context.getExpressionObjects().getObject(AUTHENTICATION_EXPRESSION_OBJECT_NAME);
                return new Authorization(context, authentication);
            }
            return null;
        }
        return null;
    }
}

