/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity6.util;

import org.springframework.core.SpringVersion;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.VersionUtils;

public final class SpringVersionUtils {
    private static final VersionUtils.VersionSpec SPRING_VERSION_SPEC;
    private static final boolean SPRING_WEB_MVC_PRESENT;
    private static final boolean SPRING_WEB_REACTIVE_PRESENT;

    public static String getSpringVersion() {
        return SPRING_VERSION_SPEC.getVersion();
    }

    public static int getSpringVersionMajor() {
        return SPRING_VERSION_SPEC.getMajor();
    }

    public static int getSpringVersionMinor() {
        return SPRING_VERSION_SPEC.getMinor();
    }

    public static int getSpringVersionPatch() {
        return SPRING_VERSION_SPEC.getPatch();
    }

    public static boolean isSpring30AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(3, 0);
    }

    public static boolean isSpring31AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(3, 1);
    }

    public static boolean isSpring32AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(3, 2);
    }

    public static boolean isSpring40AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(4, 0);
    }

    public static boolean isSpring41AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(4, 1);
    }

    public static boolean isSpring42AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(4, 2);
    }

    public static boolean isSpring43AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(4, 3);
    }

    public static boolean isSpring50AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(5, 0);
    }

    public static boolean isSpring51AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(5, 1);
    }

    public static boolean isSpring52AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(5, 2);
    }

    public static boolean isSpring53AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(5, 3);
    }

    public static boolean isSpring60AtLeast() {
        return SpringVersionUtils.isSpringAtLeast(6, 0);
    }

    public static boolean isSpringAtLeast(int major, int minor) {
        return SpringVersionUtils.isSpringAtLeast(major, minor, 0);
    }

    public static boolean isSpringAtLeast(int major, int minor, int patch) {
        return SPRING_VERSION_SPEC.isAtLeast(major, minor, patch);
    }

    public static boolean isSpringWebMvcPresent() {
        return SPRING_WEB_MVC_PRESENT;
    }

    public static boolean isSpringWebFluxPresent() {
        return SPRING_WEB_REACTIVE_PRESENT;
    }

    private SpringVersionUtils() {
    }

    static {
        String springVersion = SpringVersion.getVersion();
        String corePackageName = SpringVersion.class.getPackage().getName();
        String springPackageName = corePackageName.substring(0, corePackageName.length() - 5);
        if (springVersion != null) {
            SPRING_VERSION_SPEC = VersionUtils.parseVersion((String)springVersion);
            if (SPRING_VERSION_SPEC.isUnknown()) {
                throw new ExceptionInInitializerError("Exception during initialization of Spring versioning utilities. Identified Spring version is '" + springVersion + "', which does not follow the {major}.{minor}.{patch}[.{...}] scheme");
            }
        } else {
            SPRING_VERSION_SPEC = ClassLoaderUtils.isClassPresent((String)(springPackageName + ".core.io.buffer.DataBuffer")) ? (!ClassLoaderUtils.isClassPresent((String)(springPackageName + ".lang.UsesJava8")) ? VersionUtils.parseVersion((String)"6.0.0") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".util.ConcurrentLruCache")) ? VersionUtils.parseVersion((String)"5.3.0") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".util.SimpleRouteMatcher")) ? VersionUtils.parseVersion((String)"5.2.0.RELEASE") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".util.function.SupplierUtils")) ? VersionUtils.parseVersion((String)"5.1.0.RELEASE") : VersionUtils.parseVersion((String)"5.0.0.RELEASE"))))) : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".context.annotation.ComponentScans")) ? VersionUtils.parseVersion((String)"4.3.0.RELEASE") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".core.annotation.AliasFor")) ? VersionUtils.parseVersion((String)"4.2.0.RELEASE") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".cache.annotation.CacheConfig")) ? VersionUtils.parseVersion((String)"4.1.0.RELEASE") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".core.io.PathResource")) ? VersionUtils.parseVersion((String)"4.0.0.RELEASE") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".web.context.request.async.DeferredResult")) ? VersionUtils.parseVersion((String)"3.2.0.RELEASE") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".web.servlet.support.RequestDataValueProcessor")) ? VersionUtils.parseVersion((String)"3.1.0.RELEASE") : (ClassLoaderUtils.isClassPresent((String)(springPackageName + ".web.bind.annotation.RequestBody")) ? VersionUtils.parseVersion((String)"3.0.0.RELEASE") : VersionUtils.parseVersion((String)"2.5.0.RELEASE"))))))));
        }
        SPRING_WEB_MVC_PRESENT = ClassLoaderUtils.isClassPresent((String)(springPackageName + ".web.servlet.View"));
        SPRING_WEB_REACTIVE_PRESENT = SPRING_VERSION_SPEC.isAtLeast(5) && ClassLoaderUtils.isClassPresent((String)(springPackageName + ".web.reactive.result.view.View"));
    }
}

