/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.dialect.processor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.template.AttributeResolver;
import org.apache.tiles.template.DefaultAttributeResolver;
import org.apache.tiles.template.GetAsStringModel;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Macro;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.attr.AbstractChildrenModifierAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesStringAttrProcessor
extends AbstractChildrenModifierAttrProcessor {
    public static final String ATTR_NAME = "string";
    public static final int PRECEDENCE = 100;
    private final GetAsStringModel model = new GetAsStringModel((AttributeResolver)new DefaultAttributeResolver());

    public TilesStringAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 100;
    }

    protected List<Node> getModifiedChildren(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        IContext context = arguments.getContext();
        if (!(context instanceof IWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a web context (implementation of " + IWebContext.class.getName() + ". Tiles integration can only be used in " + "web environements.");
        }
        IWebContext webContext = (IWebContext)context;
        HttpServletRequest request = webContext.getHttpServletRequest();
        HttpServletResponse response = webContext.getHttpServletResponse();
        ServletContext servletContext = webContext.getServletContext();
        TilesContainer tilesContainer = ServletUtil.getContainer((ServletContext)servletContext);
        boolean ignore = false;
        String preparer = null;
        String role = null;
        Object defaultValue = null;
        String defaultValueRole = null;
        String defaultValueType = null;
        String name = attributeValue;
        Attribute value = null;
        TemplateEngine templateEngine = arguments.getTemplateEngine();
        StringWriter writer = new StringWriter();
        try {
            this.model.execute(tilesContainer, (Writer)writer, false, preparer, role, defaultValue, defaultValueRole, defaultValueType, name, value, new Object[]{templateEngine, arguments, request, response, writer});
        }
        catch (IOException e) {
            throw new TemplateProcessingException("Error while processing Tiles attribute \"" + name + "\"", (Throwable)e);
        }
        String templateResult = writer.toString();
        Macro macroNode = new Macro(templateResult);
        return Collections.singletonList(macroNode);
    }
}

