/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.view;

import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.WebExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring4.expression.ThymeleafEvaluationContext;
import org.thymeleaf.spring4.view.AbstractThymeleafView;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;

public class ThymeleafView
extends AbstractThymeleafView {
    private static final String pathVariablesSelector;
    private Set<String> markupSelectors = null;

    public ThymeleafView() {
    }

    public ThymeleafView(String templateName) {
        super(templateName);
    }

    public String getMarkupSelector() {
        return this.markupSelectors == null || this.markupSelectors.size() == 0 ? null : this.markupSelectors.iterator().next();
    }

    public void setMarkupSelector(String markupSelector) {
        this.markupSelectors = markupSelector == null || markupSelector.trim().length() == 0 ? null : Collections.singleton(markupSelector.trim());
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.renderFragment(this.markupSelectors, model, request, response);
    }

    protected void renderFragment(Set<String> markupSelectorsToRender, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set processMarkupSelectors;
        Set markupSelectors;
        String templateName;
        Map pathVars;
        ServletContext servletContext = this.getServletContext();
        String viewTemplateName = this.getTemplateName();
        ITemplateEngine viewTemplateEngine = this.getTemplateEngine();
        if (viewTemplateName == null) {
            throw new IllegalArgumentException("Property 'templateName' is required");
        }
        if (this.getLocale() == null) {
            throw new IllegalArgumentException("Property 'locale' is required");
        }
        if (viewTemplateEngine == null) {
            throw new IllegalArgumentException("Property 'templateEngine' is required");
        }
        HashMap<String, Object> mergedModel = new HashMap<String, Object>(30);
        Map<String, Object> templateStaticVariables = this.getStaticVariables();
        if (templateStaticVariables != null) {
            mergedModel.putAll(templateStaticVariables);
        }
        if (pathVariablesSelector != null && (pathVars = (Map)request.getAttribute(pathVariablesSelector)) != null) {
            mergedModel.putAll(pathVars);
        }
        if (model != null) {
            mergedModel.putAll(model);
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        RequestContext requestContext = new RequestContext(request, response, this.getServletContext(), mergedModel);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springRequestContext", requestContext);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springMacroRequestContext", requestContext);
        ConversionService conversionService = (ConversionService)request.getAttribute(ConversionService.class.getName());
        ThymeleafEvaluationContext evaluationContext = new ThymeleafEvaluationContext(applicationContext, conversionService);
        mergedModel.put("thymeleaf::EvaluationContext", evaluationContext);
        IEngineConfiguration configuration = viewTemplateEngine.getConfiguration();
        WebExpressionContext context = new WebExpressionContext(configuration, request, response, servletContext, this.getLocale(), mergedModel);
        if (!viewTemplateName.contains("::")) {
            templateName = viewTemplateName;
            markupSelectors = null;
        } else {
            FragmentExpression fragmentExpression;
            IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            try {
                fragmentExpression = (FragmentExpression)parser.parseExpression((IExpressionContext)context, "~{" + viewTemplateName + "}");
            }
            catch (TemplateProcessingException e) {
                throw new IllegalArgumentException("Invalid template name specification: '" + viewTemplateName + "'");
            }
            FragmentExpression.ExecutedFragmentExpression fragment = FragmentExpression.createExecutedFragmentExpression((IExpressionContext)context, (FragmentExpression)fragmentExpression, (StandardExpressionExecutionContext)StandardExpressionExecutionContext.NORMAL);
            templateName = FragmentExpression.resolveTemplateName((FragmentExpression.ExecutedFragmentExpression)fragment);
            markupSelectors = FragmentExpression.resolveFragments((FragmentExpression.ExecutedFragmentExpression)fragment);
            Map nameFragmentParameters = fragment.getFragmentParameters();
            if (nameFragmentParameters != null) {
                if (fragment.hasSyntheticParameters()) {
                    throw new IllegalArgumentException("Parameters in a view specification must be named (non-synthetic): '" + viewTemplateName + "'");
                }
                context.setVariables(nameFragmentParameters);
            }
        }
        String templateContentType = this.getContentType();
        Locale templateLocale = this.getLocale();
        String templateCharacterEncoding = this.getCharacterEncoding();
        if (markupSelectors != null && markupSelectors.size() > 0) {
            if (markupSelectorsToRender != null && markupSelectorsToRender.size() > 0) {
                throw new IllegalArgumentException("A markup selector has been specified (" + Arrays.asList(markupSelectors) + ") for a view that was already being executed as a fragment (" + Arrays.asList(markupSelectorsToRender) + "). Only one fragment selection is allowed.");
            }
            processMarkupSelectors = markupSelectors;
        } else {
            processMarkupSelectors = markupSelectorsToRender != null && markupSelectorsToRender.size() > 0 ? markupSelectorsToRender : null;
        }
        response.setLocale(templateLocale);
        if (templateContentType != null) {
            response.setContentType(templateContentType);
        } else {
            response.setContentType("text/html;charset=ISO-8859-1");
        }
        if (templateCharacterEncoding != null) {
            response.setCharacterEncoding(templateCharacterEncoding);
        }
        viewTemplateEngine.process(templateName, processMarkupSelectors, (IContext)context, (Writer)response.getWriter());
    }

    static {
        String pathVariablesSelectorValue = null;
        try {
            Field pathVariablesField = View.class.getDeclaredField("PATH_VARIABLES");
            pathVariablesSelectorValue = (String)pathVariablesField.get(null);
        }
        catch (NoSuchFieldException ignored) {
            pathVariablesSelectorValue = null;
        }
        catch (IllegalAccessException ignored) {
            pathVariablesSelectorValue = null;
        }
        pathVariablesSelector = pathVariablesSelectorValue;
    }
}

