/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.webflux;

import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.thymeleaf.spring5.view.reactive.ThymeleafReactiveView;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveContextVariableUtils {
    static Publisher<Object> computePublisherValue(Object asyncObj, ReactiveAdapterRegistry reactiveAdapterRegistry) {
        if (asyncObj instanceof Flux || asyncObj instanceof Mono) {
            return (Publisher)asyncObj;
        }
        if (reactiveAdapterRegistry == null) {
            throw new IllegalArgumentException("Could not initialize lazy reactive variable: Value is of class " + asyncObj.getClass().getName() + ", but no ReactiveAdapterRegistry has been set. This can happen if this context variable is used for rendering a template without going through a " + ThymeleafReactiveView.class.getSimpleName() + " or if there is no ReactiveAdapterRegistry bean registered at the application context. In such cases, it is required that the wrapped lazy variable values are instances of either " + Flux.class.getName() + " or " + Mono.class.getName() + ".");
        }
        ReactiveAdapter adapter = reactiveAdapterRegistry.getAdapter(null, asyncObj);
        if (adapter != null) {
            Publisher publisher = adapter.toPublisher(asyncObj);
            if (adapter.isMultiValue()) {
                return Flux.from((Publisher)publisher);
            }
            return Mono.from((Publisher)publisher);
        }
        throw new IllegalArgumentException("Value set for " + ReactiveContextVariableUtils.class.getSimpleName() + " context variable is of class " + asyncObj.getClass().getName() + ", but the ReactiveAdapterRegistry does not contain a valid adapter able to convert it into a supported reactive data stream.");
    }

    private ReactiveContextVariableUtils() {
    }
}

