/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.resolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resolver.ITestableResolver;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceContainer;
import org.thymeleaf.testing.templateengine.resource.ITestResourceItem;
import org.thymeleaf.testing.templateengine.resource.ITestResourceResolver;
import org.thymeleaf.testing.templateengine.resource.StandardTestResourceResolver;
import org.thymeleaf.testing.templateengine.standard.test.builder.IStandardTestBuilder;
import org.thymeleaf.testing.templateengine.standard.test.builder.StandardTestBuilder;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedData;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestRawData;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.IStandardTestEvaluator;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.StandardTestEvaluator;
import org.thymeleaf.testing.templateengine.standard.test.reader.IStandardTestReader;
import org.thymeleaf.testing.templateengine.standard.test.reader.StandardTestReader;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.testing.templateengine.testable.ITestIterator;
import org.thymeleaf.testing.templateengine.testable.ITestParallelizer;
import org.thymeleaf.testing.templateengine.testable.ITestSequence;
import org.thymeleaf.testing.templateengine.testable.ITestable;
import org.thymeleaf.testing.templateengine.testable.TestIterator;
import org.thymeleaf.testing.templateengine.testable.TestParallelizer;
import org.thymeleaf.testing.templateengine.testable.TestSequence;
import org.thymeleaf.util.Validate;

public class StandardTestableResolver
implements ITestableResolver {
    public static final String FOLDER_INDEX_FILE_PREFIX = "FOLDER";
    private static String TEST_FILE_SUFFIX = ".THTEST";
    private static String INDEX_FILE_SUFFIX = ".THINDEX";
    public static final String FOLDER_INDEX_FILE_NAME = "FOLDER" + INDEX_FILE_SUFFIX;
    private static final Pattern INDEX_FILE_LINE_PATTERN = Pattern.compile("(.*?)(\\[(.*?)])?\\s*$");
    private static String ITERATOR_SUFFIX_PATTERN_STR = "iter-(\\d*)$";
    private static String ITERATOR_PATTERN_STR = "^(.*?)-" + ITERATOR_SUFFIX_PATTERN_STR;
    private static Pattern ITERATOR_SUFFIX_PATTERN = Pattern.compile(ITERATOR_SUFFIX_PATTERN_STR);
    private static Pattern ITERATOR_PATTERN = Pattern.compile(ITERATOR_PATTERN_STR);
    private static String PARALLELIZER_SUFFIX_PATTERN_STR = "parallel-(\\d*)$";
    private static String PARALLELIZER_PATTERN_STR = "^(.*?)-" + PARALLELIZER_SUFFIX_PATTERN_STR;
    private static Pattern PARALLELIZER_SUFFIX_PATTERN = Pattern.compile(PARALLELIZER_SUFFIX_PATTERN_STR);
    private static Pattern PARALLELIZER_PATTERN = Pattern.compile(PARALLELIZER_PATTERN_STR);
    private ITestResourceResolver testResourceResolver = StandardTestResourceResolver.UTF8_RESOLVER;
    private IStandardTestReader testReader = new StandardTestReader();
    private IStandardTestEvaluator testEvaluator = new StandardTestEvaluator();
    private IStandardTestBuilder testBuilder = new StandardTestBuilder();

    public final ITestResourceResolver getTestResourceResolver() {
        return this.testResourceResolver;
    }

    public final void setTestResourceResolver(ITestResourceResolver testResourceResolver) {
        Validate.notNull((Object)testResourceResolver, (String)"Test Resource Resolver cannot be null");
        this.testResourceResolver = testResourceResolver;
    }

    public IStandardTestBuilder getTestBuilder() {
        return this.testBuilder;
    }

    public void setTestBuilder(IStandardTestBuilder testBuilder) {
        Validate.notNull((Object)testBuilder, (String)"Test Builder cannot be null");
        this.testBuilder = testBuilder;
    }

    public IStandardTestReader getTestReader() {
        return this.testReader;
    }

    public void setTestReader(IStandardTestReader testReader) {
        Validate.notNull((Object)testReader, (String)"Test Reader cannot be null");
        this.testReader = testReader;
    }

    public IStandardTestEvaluator getTestEvaluator() {
        return this.testEvaluator;
    }

    public void setTestEvaluator(IStandardTestEvaluator testEvaluator) {
        Validate.notNull((Object)testEvaluator, (String)"Test Evaluator cannot be null");
        this.testEvaluator = testEvaluator;
    }

    public final ITestable resolve(String executionId, String testableName) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)testableName, (String)"Testable name cannot be null");
        ITestResource resource = this.testResourceResolver.resolve(testableName);
        if (resource == null) {
            return null;
        }
        return this.resolveResource(executionId, resource);
    }

    public final ITestable resolveRelative(String executionId, String testableName, ITestResource relativeTo) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)testableName, (String)"Testable name cannot be null");
        if (relativeTo == null) {
            return this.resolve(executionId, testableName);
        }
        ITestResource resource = this.testResourceResolver.resolve(testableName, relativeTo);
        if (resource == null) {
            return null;
        }
        return this.resolveResource(executionId, resource);
    }

    protected TestableType computeTestableType(ITestResource resource) {
        if (resource == null) {
            return TestableType.NONE;
        }
        String resourceName = resource.getName();
        if (resourceName == null) {
            return null;
        }
        if (resource instanceof ITestResourceItem) {
            if (resourceName.toUpperCase().endsWith(INDEX_FILE_SUFFIX)) {
                return TestableType.SEQUENCE;
            }
            return TestableType.TEST;
        }
        if (resource instanceof ITestResourceContainer) {
            Matcher iterMatcher = ITERATOR_PATTERN.matcher(resourceName);
            if (iterMatcher.matches()) {
                return TestableType.ITERATOR;
            }
            Matcher paralMatcher = PARALLELIZER_PATTERN.matcher(resourceName);
            if (paralMatcher.matches()) {
                return TestableType.PARALLELIZER;
            }
            return TestableType.SEQUENCE;
        }
        throw new IllegalStateException("Unknown resource type " + resource.getClass().getName());
    }

    protected final ITestable resolveResource(String executionId, ITestResource resource) {
        if (resource == null) {
            return null;
        }
        TestableType type = this.computeTestableType(resource);
        if (type == null) {
            return null;
        }
        switch (type) {
            case TEST: {
                return this.resolveAsTest(executionId, resource);
            }
            case SEQUENCE: {
                return this.resolveAsTestSequence(executionId, resource);
            }
            case ITERATOR: {
                return this.resolveAsTestIterator(executionId, resource);
            }
            case PARALLELIZER: {
                return this.resolveAsTestParallelizer(executionId, resource);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Cannot process testable type " + (Object)((Object)type));
    }

    protected final ITest resolveAsTest(String executionId, ITestResource resource) {
        StandardTestRawData rawData;
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)resource, (String)"Test resource cannot be null");
        IStandardTestReader reader = this.getTestReader();
        if (reader == null) {
            throw new TestEngineExecutionException("A null test reader has been configured");
        }
        IStandardTestEvaluator evaluator = this.getTestEvaluator();
        if (evaluator == null) {
            throw new TestEngineExecutionException("A null test evaluator has been configured");
        }
        IStandardTestBuilder builder = this.getTestBuilder();
        if (builder == null) {
            throw new TestEngineExecutionException("A null test builder has been configured");
        }
        ITestResourceResolver resolver = this.getTestResourceResolver();
        if (resolver == null) {
            throw new TestEngineExecutionException("A null test resource resolver has been configured");
        }
        try {
            rawData = reader.readTestResource(executionId, resource, this);
        }
        catch (IOException e) {
            throw new TestEngineExecutionException("Error reading resource \"" + resource.getName() + "\"", e);
        }
        StandardTestEvaluatedData evaluatedData = evaluator.evaluateTestData(executionId, rawData, this);
        return builder.buildTest(executionId, evaluatedData, this);
    }

    protected ITestSequence resolveAsTestSequence(String executionId, ITestResource resource) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)resource, (String)"Test resource be null");
        String fileName = resource.getName();
        TestSequence testSequence = new TestSequence();
        testSequence.setName(fileName);
        ITestResourceItem index = null;
        if (resource instanceof ITestResourceItem) {
            if (resource.getName().toUpperCase().endsWith(INDEX_FILE_SUFFIX)) {
                index = (ITestResourceItem)resource;
            } else {
                return null;
            }
        }
        if (resource instanceof ITestResourceContainer) {
            ITestResourceContainer containerResource = (ITestResourceContainer)resource;
            if (index == null) {
                for (ITestResource resourceInFolder : containerResource.getContainedResources()) {
                    String resourceInFolderName;
                    if (!(resourceInFolder instanceof ITestResourceItem) || (resourceInFolderName = resourceInFolder.getName()) == null || !resourceInFolderName.toUpperCase().endsWith(FOLDER_INDEX_FILE_NAME)) continue;
                    index = (ITestResourceItem)resourceInFolder;
                    break;
                }
            }
            if (index == null) {
                for (ITestResource resourceInFolder : containerResource.getContainedResources()) {
                    ITestable testable;
                    String resourceName;
                    if (resourceInFolder == null || !(resourceInFolder instanceof ITestResourceContainer) && ((resourceName = resourceInFolder.getName()) == null || !resourceName.toUpperCase().endsWith(TEST_FILE_SUFFIX)) || (testable = this.resolveResource(executionId, resourceInFolder)) == null) continue;
                    testSequence.addElement(testable);
                }
                return testSequence;
            }
        }
        this.readIndex(executionId, index, testSequence);
        return testSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String[] parseTestIndexLine(String line) {
        Matcher m;
        if (line == null) {
            return null;
        }
        Pattern pattern = INDEX_FILE_LINE_PATTERN;
        synchronized (pattern) {
            m = INDEX_FILE_LINE_PATTERN.matcher(line);
        }
        if (m == null || !m.matches()) {
            return null;
        }
        String fileName = m.group(1);
        String lineSpec = m.group(3);
        if (fileName == null || fileName.trim().equals("")) {
            return null;
        }
        String[] result = new String[]{fileName.trim(), lineSpec == null ? null : lineSpec.trim()};
        return result;
    }

    protected ITestIterator resolveAsTestIterator(String executionId, ITestResource resource) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)resource, (String)"Test resource cannot be null");
        String fileName = resource.getName();
        Matcher iterMatcher = ITERATOR_PATTERN.matcher(fileName);
        if (!iterMatcher.matches()) {
            throw new TestEngineExecutionException("Cannot match \"" + fileName + "\" as a valid folder name for an iterator");
        }
        int iterations = Integer.parseInt(iterMatcher.group(2));
        ITestSequence iteratedSequence = this.resolveAsTestSequence(executionId, resource);
        return new TestIterator(iteratedSequence, iterations);
    }

    protected ITestParallelizer resolveAsTestParallelizer(String executionId, ITestResource resource) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)resource, (String)"Test resource cannot be null");
        String fileName = resource.getName();
        Matcher parMatcher = PARALLELIZER_PATTERN.matcher(fileName);
        if (!parMatcher.matches()) {
            throw new TestEngineExecutionException("Cannot match \"" + fileName + "\" as a valid folder name for a parallelizer");
        }
        int numThreads = Integer.parseInt(parMatcher.group(2));
        ITestSequence iteratedSequence = this.resolveAsTestSequence(executionId, resource);
        return new TestParallelizer(iteratedSequence, numThreads);
    }

    private void readIndex(String executionId, ITestResourceItem indexResource, TestSequence testSequence) {
        BufferedReader reader = null;
        try {
            String indexContents = indexResource.readAsText();
            reader = new BufferedReader(new StringReader(indexContents));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("") || line.startsWith("#")) continue;
                String[] lineComponents = StandardTestableResolver.parseTestIndexLine(line);
                if (lineComponents == null) {
                    throw new TestEngineExecutionException("Error parsing test index file line: '" + line + "'");
                }
                String testResourceName = lineComponents[0];
                String testSpec = lineComponents[1];
                ITestResource testResource = this.testResourceResolver.resolve(testResourceName, indexResource);
                ITestable testable = this.resolveResource(executionId, testResource);
                if (testable == null) {
                    throw new TestEngineExecutionException("Error resolving file '" + testResourceName + "' " + "specified in test index file: '" + indexResource.getName() + "'");
                }
                if (testSpec != null) {
                    Matcher iterMatcher = ITERATOR_SUFFIX_PATTERN.matcher(testSpec);
                    if (iterMatcher.matches()) {
                        int iterations = Integer.parseInt(iterMatcher.group(1));
                        TestIterator testIterator = new TestIterator(testable, iterations);
                        testable = testIterator;
                    } else {
                        Matcher parMatcher = PARALLELIZER_SUFFIX_PATTERN.matcher(testSpec);
                        if (parMatcher.matches()) {
                            int numThreads = Integer.parseInt(parMatcher.group(1));
                            TestParallelizer testParallelizer = new TestParallelizer(testable, numThreads);
                            testable = testParallelizer;
                        } else {
                            throw new TestEngineExecutionException("Error resolving file '" + testResourceName + "' " + "specified in test index file: '" + indexResource.getName() + "'. " + "Unrecognized specification '[" + testSpec + "]'");
                        }
                    }
                }
                testSequence.addElement(testable);
            }
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestEngineExecutionException("Exception raised while reading test index file '" + indexResource.getName() + "'", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestableType {
        NONE,
        TEST,
        SEQUENCE,
        ITERATOR,
        PARALLELIZER;

    }
}

