/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators;

import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceResolver;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators.AbstractStandardTestFieldEvaluator;

public class DefaultExceptionTestFieldEvaluator
extends AbstractStandardTestFieldEvaluator {
    public static final DefaultExceptionTestFieldEvaluator INSTANCE = new DefaultExceptionTestFieldEvaluator();

    private DefaultExceptionTestFieldEvaluator() {
        super(Class.class);
    }

    public StandardTestEvaluatedField getValue(String executionId, ITestResource resource, ITestResourceResolver testResourceResolver, String fieldName, String fieldQualifier, String fieldValue) {
        if (fieldValue == null || fieldValue.trim().equals("")) {
            return StandardTestEvaluatedField.forNoValue();
        }
        String resourceName = resource != null ? resource.getName() : null;
        Class<?> specifiedClass = null;
        try {
            specifiedClass = Class.forName(fieldValue.trim());
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Exception initializing field \"" + fieldName + "\" in document " + "\"" + resourceName + "\"", t);
        }
        if (!Throwable.class.isAssignableFrom(specifiedClass)) {
            throw new TestEngineExecutionException("Exception initializing field \"" + fieldName + "\" in document " + "\"" + resourceName + "\": Class \"" + specifiedClass.getClass().getName() + "\" does not " + "extend " + Throwable.class.getName());
        }
        return StandardTestEvaluatedField.forSpecifiedValue(specifiedClass);
    }
}

