/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.attoparser.IMarkupHandler;
import org.attoparser.IMarkupParser;
import org.attoparser.MarkupParser;
import org.attoparser.ParseException;
import org.attoparser.config.ParseConfiguration;
import org.attoparser.trace.MarkupTraceEvent;
import org.attoparser.trace.TraceBuilderMarkupHandler;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultCompareUtils {
    private static final AttributeEventComparator ATTRIBUTE_EVENT_COMPARATOR = new AttributeEventComparator();
    private static final IMarkupParser PARSER;
    private static final ParseConfiguration MARKUP_PARSING_CONFIGURATION;
    private static final Set<String> BLOCK_ELEMENTS;
    private static final Set<String> BLOCK_CONTAINER_ELEMENTS;

    public static ResultComparison compareResults(String expected, String actual, boolean lenient) {
        Validate.notNull((Object)expected, (String)"Expected result cannot be null");
        Validate.notNull((Object)actual, (String)"Actual result cannot be null");
        TraceBuilderMarkupHandler expectedHandler = new TraceBuilderMarkupHandler();
        TraceBuilderMarkupHandler actualHandler = new TraceBuilderMarkupHandler();
        try {
            PARSER.parse(expected, (IMarkupHandler)expectedHandler);
            PARSER.parse(actual, (IMarkupHandler)actualHandler);
        }
        catch (ParseException e) {
            throw new TestEngineExecutionException("Error while trying to compare results", e);
        }
        List<MarkupTraceEvent> expectedTrace = lenient ? ResultCompareUtils.normalizeTrace(expectedHandler.getTrace()) : expectedHandler.getTrace();
        List<MarkupTraceEvent> actualTrace = lenient ? ResultCompareUtils.normalizeTrace(actualHandler.getTrace()) : actualHandler.getTrace();
        int actualTraceSize = actualTrace.size();
        int expectedTraceSize = expectedTrace.size();
        for (int i = 0; i < actualTraceSize; ++i) {
            boolean itemMatches;
            MarkupTraceEvent expectedTraceItem;
            MarkupTraceEvent actualTraceItem = actualTrace.get(i);
            MarkupTraceEvent markupTraceEvent = expectedTraceItem = expectedTraceSize > i ? expectedTrace.get(i) : null;
            if (actualTraceItem instanceof MarkupTraceEvent.DocumentStartTraceEvent && expectedTraceItem != null && expectedTraceItem instanceof MarkupTraceEvent.DocumentStartTraceEvent || actualTraceItem instanceof MarkupTraceEvent.DocumentEndTraceEvent && expectedTraceItem != null && expectedTraceItem instanceof MarkupTraceEvent.DocumentEndTraceEvent) continue;
            if (expectedTraceItem == null) {
                int[] actualFragmentReportSizes = ResultCompareUtils.computeErrorMessageLength(actualTrace, i, actual);
                int[] expectedFragmentReportSizes = new int[]{20, 0};
                int actualTraceItemLine = ResultCompareUtils.computeFirstLine(actualTraceItem);
                int actualTraceItemCol = ResultCompareUtils.computeFirstCol(actualTraceItem);
                String actualFragment = ResultCompareUtils.getFragmentSurrounding(actual, actualTraceItemLine, actualTraceItemCol, actualFragmentReportSizes[0], actualFragmentReportSizes[1]);
                String expectedFragment = ResultCompareUtils.getFragmentSurrounding(expected, Integer.MAX_VALUE, Integer.MAX_VALUE, expectedFragmentReportSizes[0], expectedFragmentReportSizes[1]);
                String explanation = ResultCompareUtils.createExplanation(actualFragment, actualTraceItemLine, actualTraceItemCol, expectedFragment);
                return new ResultComparison(false, explanation);
            }
            MarkupTraceEvent comparableActualTraceItem = ResultCompareUtils.compressWhitespaceIfText(actualTraceItem);
            MarkupTraceEvent comparableExpectedTraceItem = ResultCompareUtils.compressWhitespaceIfText(expectedTraceItem);
            boolean bl = itemMatches = lenient ? comparableActualTraceItem.matchesTypeAndContent(comparableExpectedTraceItem) : actualTraceItem.equals((Object)expectedTraceItem);
            if (itemMatches) continue;
            int[] actualFragmentReportSizes = ResultCompareUtils.computeErrorMessageLength(actualTrace, i, actual);
            int[] expectedFragmentReportSizes = ResultCompareUtils.computeErrorMessageLength(expectedTrace, i, expected);
            int actualTraceItemLine = ResultCompareUtils.computeFirstLine(actualTraceItem);
            int actualTraceItemCol = ResultCompareUtils.computeFirstCol(actualTraceItem);
            int expectedTraceItemLine = ResultCompareUtils.computeFirstLine(expectedTraceItem);
            int expectedTraceItemCol = ResultCompareUtils.computeFirstCol(expectedTraceItem);
            String actualFragment = ResultCompareUtils.getFragmentSurrounding(actual, actualTraceItemLine, actualTraceItemCol, actualFragmentReportSizes[0], actualFragmentReportSizes[1]);
            String expectedFragment = ResultCompareUtils.getFragmentSurrounding(expected, expectedTraceItemLine, expectedTraceItemCol, expectedFragmentReportSizes[0], expectedFragmentReportSizes[1]);
            String explanation = ResultCompareUtils.createExplanation(actualFragment, actualTraceItemLine, actualTraceItemCol, expectedFragment);
            return new ResultComparison(false, explanation);
        }
        return new ResultComparison(true, "OK");
    }

    private static List<MarkupTraceEvent> normalizeTrace(List<MarkupTraceEvent> trace) {
        String lastOpenElementName = null;
        String lastClosedElementName = null;
        boolean lastIsWhiteSpace = false;
        ArrayList<MarkupTraceEvent> newTrace = new ArrayList<MarkupTraceEvent>();
        ArrayList<MarkupTraceEvent> currentAttributeList = new ArrayList<MarkupTraceEvent>();
        for (MarkupTraceEvent event : trace) {
            String elementName;
            MarkupTraceEvent.EventType eventType = event.getEventType();
            if (!currentAttributeList.isEmpty() && MarkupTraceEvent.EventType.ATTRIBUTE != eventType && MarkupTraceEvent.EventType.INNER_WHITE_SPACE != eventType) {
                Collections.sort(currentAttributeList, ATTRIBUTE_EVENT_COMPARATOR);
                newTrace.addAll(currentAttributeList);
                currentAttributeList.clear();
                lastIsWhiteSpace = false;
            }
            if (newTrace.size() == 2 && MarkupTraceEvent.EventType.DOC_TYPE != eventType && MarkupTraceEvent.EventType.XML_DECLARATION != eventType && MarkupTraceEvent.EventType.DOCUMENT_END != eventType && lastIsWhiteSpace) {
                newTrace.remove(newTrace.size() - 1);
                lastIsWhiteSpace = false;
            }
            if (MarkupTraceEvent.EventType.TEXT == eventType) {
                String text = ((MarkupTraceEvent.TextTraceEvent)event).getContent();
                newTrace.add(event);
                if (ResultCompareUtils.isAllWhitespace(text)) {
                    lastIsWhiteSpace = true;
                    continue;
                }
                lastOpenElementName = null;
                lastClosedElementName = null;
                continue;
            }
            if (MarkupTraceEvent.EventType.INNER_WHITE_SPACE == eventType) continue;
            if (MarkupTraceEvent.EventType.ATTRIBUTE == eventType) {
                currentAttributeList.add(event);
                continue;
            }
            if (MarkupTraceEvent.EventType.CLOSE_ELEMENT_END == eventType || MarkupTraceEvent.EventType.STANDALONE_ELEMENT_END == eventType) {
                lastClosedElementName = MarkupTraceEvent.EventType.CLOSE_ELEMENT_END == eventType ? ((MarkupTraceEvent.CloseElementEndTraceEvent)event).getElementName().toLowerCase() : ((MarkupTraceEvent.StandaloneElementEndTraceEvent)event).getElementName().toLowerCase();
                lastOpenElementName = null;
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if (MarkupTraceEvent.EventType.OPEN_ELEMENT_START == eventType || MarkupTraceEvent.EventType.STANDALONE_ELEMENT_START == eventType) {
                String string = elementName = MarkupTraceEvent.EventType.OPEN_ELEMENT_START == eventType ? ((MarkupTraceEvent.OpenElementStartTraceEvent)event).getElementName().toLowerCase() : ((MarkupTraceEvent.StandaloneElementStartTraceEvent)event).getElementName().toLowerCase();
                if (lastClosedElementName != null && BLOCK_ELEMENTS.contains(lastClosedElementName) && BLOCK_ELEMENTS.contains(elementName)) {
                    if (lastIsWhiteSpace) {
                        newTrace.remove(newTrace.size() - 1);
                        lastIsWhiteSpace = false;
                    }
                } else if (lastOpenElementName != null && BLOCK_CONTAINER_ELEMENTS.contains(lastOpenElementName) && BLOCK_ELEMENTS.contains(elementName) && lastIsWhiteSpace) {
                    newTrace.remove(newTrace.size() - 1);
                    lastIsWhiteSpace = false;
                }
                if (MarkupTraceEvent.EventType.STANDALONE_ELEMENT_START == eventType) {
                    lastOpenElementName = null;
                    lastClosedElementName = elementName;
                } else {
                    lastOpenElementName = elementName;
                    lastClosedElementName = null;
                }
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if (MarkupTraceEvent.EventType.CLOSE_ELEMENT_START == eventType) {
                elementName = ((MarkupTraceEvent.CloseElementStartTraceEvent)event).getElementName().toLowerCase();
                if (lastClosedElementName != null && BLOCK_ELEMENTS.contains(lastClosedElementName) && BLOCK_CONTAINER_ELEMENTS.contains(elementName) && lastIsWhiteSpace) {
                    newTrace.remove(newTrace.size() - 1);
                    lastIsWhiteSpace = false;
                }
                lastOpenElementName = null;
                lastClosedElementName = elementName;
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if (MarkupTraceEvent.EventType.DOCUMENT_END == eventType) {
                String text;
                MarkupTraceEvent lastEvent;
                MarkupTraceEvent markupTraceEvent = lastEvent = newTrace.size() > 2 ? (MarkupTraceEvent)newTrace.get(newTrace.size() - 1) : null;
                if (lastEvent != null && MarkupTraceEvent.EventType.TEXT == lastEvent.getEventType() && ResultCompareUtils.isAllWhitespace(text = ((MarkupTraceEvent.TextTraceEvent)lastEvent).getContent())) {
                    newTrace.remove(newTrace.size() - 1);
                }
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if (MarkupTraceEvent.EventType.OPEN_ELEMENT_END == eventType) {
                lastClosedElementName = null;
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            lastOpenElementName = null;
            lastClosedElementName = null;
            newTrace.add(event);
            lastIsWhiteSpace = false;
        }
        return newTrace;
    }

    private static MarkupTraceEvent compressWhitespaceIfText(MarkupTraceEvent event) {
        MarkupTraceEvent.EventType eventType = event.getEventType();
        if (MarkupTraceEvent.EventType.TEXT != eventType) {
            return event;
        }
        MarkupTraceEvent.TextTraceEvent textEvent = (MarkupTraceEvent.TextTraceEvent)event;
        String text = textEvent.getContent();
        StringBuilder strBuilder = new StringBuilder(text.length());
        boolean whitespace = false;
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (whitespace) continue;
                strBuilder.append(' ');
                whitespace = true;
                continue;
            }
            whitespace = false;
            strBuilder.append(c);
        }
        return new MarkupTraceEvent.TextTraceEvent(strBuilder.toString(), textEvent.getLine(), textEvent.getCol());
    }

    private static boolean isAllWhitespace(String text) {
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private static String getFragmentSurrounding(String text, int line, int col, int before, int after) {
        int pos;
        int textLen = text.length();
        int cline = 1;
        int ccol = 1;
        for (pos = 0; pos < textLen && (cline < line || ccol < col); ++pos) {
            char c = text.charAt(pos);
            if (c == '\n') {
                ++cline;
                ccol = 1;
                continue;
            }
            ++ccol;
        }
        if (pos >= textLen) {
            pos = textLen - 1;
        }
        int startPos = Math.max(0, pos - before);
        int endPos = Math.min(textLen, pos + after);
        return new String(text.substring(startPos, endPos));
    }

    public static String createExplanation(String actualFragment, int actualLine, int actualCol, String expectedFragment) {
        return "Actual result does not match expected result.\nObtained:\n[" + actualFragment + "]\n" + "at line " + actualLine + " col " + actualCol + ", but " + "expected:\n[" + expectedFragment + "]";
    }

    private static int[] computeErrorMessageLength(List<MarkupTraceEvent> trace, int position, String result) {
        MarkupTraceEvent eventItem = trace.get(position);
        MarkupTraceEvent.EventType eventType = eventItem.getEventType();
        if (MarkupTraceEvent.EventType.TEXT == eventType) {
            MarkupTraceEvent.TextTraceEvent textEvent = (MarkupTraceEvent.TextTraceEvent)eventItem;
            String content = textEvent.getContent();
            int contentLen = content == null ? 0 : content.length();
            return new int[]{20, contentLen + 20};
        }
        if (MarkupTraceEvent.EventType.ATTRIBUTE == eventType || MarkupTraceEvent.EventType.OPEN_ELEMENT_START == eventType || MarkupTraceEvent.EventType.STANDALONE_ELEMENT_START == eventType) {
            int attributeLine = ResultCompareUtils.computeFirstLine(eventItem);
            int attributeCol = ResultCompareUtils.computeFirstCol(eventItem);
            int i = position;
            eventItem = trace.get(i);
            eventType = eventItem.getEventType();
            while (MarkupTraceEvent.EventType.OPEN_ELEMENT_START != eventType && MarkupTraceEvent.EventType.STANDALONE_ELEMENT_START != eventType && i > 0) {
                eventItem = trace.get(--i);
                eventType = eventItem.getEventType();
            }
            int elementLine = ResultCompareUtils.computeFirstLine(eventItem);
            int elementCol = ResultCompareUtils.computeFirstCol(eventItem);
            int beforeDistance = ResultCompareUtils.computeDistance(result, elementLine, elementCol, attributeLine, attributeCol);
            int afterDistance = 0;
            int lastAttributeLen = 0;
            eventItem = trace.get(++i);
            eventType = eventItem.getEventType();
            while (MarkupTraceEvent.EventType.ATTRIBUTE == eventType && i < trace.size()) {
                MarkupTraceEvent.AttributeTraceEvent attributeTraceEvent = (MarkupTraceEvent.AttributeTraceEvent)eventItem;
                int distance = ResultCompareUtils.computeDistance(result, attributeLine, attributeCol, attributeTraceEvent.getNameLine(), attributeTraceEvent.getNameCol());
                if (distance > afterDistance) {
                    afterDistance = distance;
                    lastAttributeLen = attributeTraceEvent.getName().length() + (attributeTraceEvent.getOperator() != null ? attributeTraceEvent.getOperator().length() : 0) + (attributeTraceEvent.getOuterValue() != null ? attributeTraceEvent.getOuterValue().length() : 0);
                }
                eventItem = trace.get(++i);
                eventType = eventItem.getEventType();
            }
            return new int[]{beforeDistance + 20, afterDistance + lastAttributeLen + 80};
        }
        return new int[]{20, 80};
    }

    private static int computeDistance(String text, int lineFrom, int colFrom, int lineTo, int colTo) {
        char c;
        int i;
        int textLen = text.length();
        int startPos = 0;
        int endPos = 0;
        int line = 1;
        int col = 1;
        for (i = 0; i < textLen; ++i) {
            if (line == lineFrom && col == colFrom) {
                startPos = i;
                break;
            }
            c = text.charAt(i);
            if (c == '\n') {
                ++line;
                col = 1;
                continue;
            }
            ++col;
        }
        line = 1;
        col = 1;
        for (i = 0; i < textLen; ++i) {
            if (line == lineTo && col == colTo) {
                endPos = i;
                break;
            }
            c = text.charAt(i);
            if (c == '\n') {
                ++line;
                col = 1;
                continue;
            }
            ++col;
        }
        return endPos - startPos;
    }

    private static int computeFirstLine(MarkupTraceEvent event) {
        if (event instanceof MarkupTraceEvent.XmlDeclarationTraceEvent) {
            return ((MarkupTraceEvent.XmlDeclarationTraceEvent)event).getKeywordLine();
        }
        if (event instanceof MarkupTraceEvent.DocTypeTraceEvent) {
            return ((MarkupTraceEvent.DocTypeTraceEvent)event).getKeywordLine();
        }
        if (event instanceof MarkupTraceEvent.CommentTraceEvent) {
            return ((MarkupTraceEvent.CommentTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.TextTraceEvent) {
            return ((MarkupTraceEvent.TextTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.ProcessingInstructionTraceEvent) {
            return ((MarkupTraceEvent.ProcessingInstructionTraceEvent)event).getTargetLine();
        }
        if (event instanceof MarkupTraceEvent.CDATASectionTraceEvent) {
            return ((MarkupTraceEvent.CDATASectionTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.StandaloneElementStartTraceEvent) {
            return ((MarkupTraceEvent.StandaloneElementStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.StandaloneElementEndTraceEvent) {
            return ((MarkupTraceEvent.StandaloneElementEndTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.OpenElementStartTraceEvent) {
            return ((MarkupTraceEvent.OpenElementStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.OpenElementEndTraceEvent) {
            return ((MarkupTraceEvent.OpenElementEndTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.AutoOpenElementStartTraceEvent) {
            return ((MarkupTraceEvent.AutoOpenElementStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.AutoOpenElementEndTraceEvent) {
            return ((MarkupTraceEvent.AutoOpenElementEndTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.CloseElementStartTraceEvent) {
            return ((MarkupTraceEvent.CloseElementStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.CloseElementEndTraceEvent) {
            return ((MarkupTraceEvent.CloseElementEndTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.AutoCloseElementStartTraceEvent) {
            return ((MarkupTraceEvent.AutoCloseElementStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.AutoCloseElementEndTraceEvent) {
            return ((MarkupTraceEvent.AutoCloseElementEndTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.AttributeTraceEvent) {
            return ((MarkupTraceEvent.AttributeTraceEvent)event).getNameLine();
        }
        if (event instanceof MarkupTraceEvent.InnerWhiteSpaceTraceEvent) {
            return ((MarkupTraceEvent.InnerWhiteSpaceTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.NonMinimizedStandaloneElementStartTraceEvent) {
            return ((MarkupTraceEvent.NonMinimizedStandaloneElementStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.NonMinimizedStandaloneElementEndTraceEvent) {
            return ((MarkupTraceEvent.NonMinimizedStandaloneElementEndTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.UnmatchedCloseElementStartTraceEvent) {
            return ((MarkupTraceEvent.UnmatchedCloseElementStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.UnmatchedCloseElementEndTraceEvent) {
            return ((MarkupTraceEvent.UnmatchedCloseElementEndTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.DocumentStartTraceEvent) {
            return ((MarkupTraceEvent.DocumentStartTraceEvent)event).getLine();
        }
        if (event instanceof MarkupTraceEvent.DocumentEndTraceEvent) {
            return ((MarkupTraceEvent.DocumentEndTraceEvent)event).getLine();
        }
        throw new IllegalStateException("Unrecognized event class: " + event.getClass().getName());
    }

    private static int computeFirstCol(MarkupTraceEvent event) {
        if (event instanceof MarkupTraceEvent.XmlDeclarationTraceEvent) {
            return ((MarkupTraceEvent.XmlDeclarationTraceEvent)event).getKeywordCol();
        }
        if (event instanceof MarkupTraceEvent.DocTypeTraceEvent) {
            return ((MarkupTraceEvent.DocTypeTraceEvent)event).getKeywordCol();
        }
        if (event instanceof MarkupTraceEvent.CommentTraceEvent) {
            return ((MarkupTraceEvent.CommentTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.TextTraceEvent) {
            return ((MarkupTraceEvent.TextTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.ProcessingInstructionTraceEvent) {
            return ((MarkupTraceEvent.ProcessingInstructionTraceEvent)event).getTargetCol();
        }
        if (event instanceof MarkupTraceEvent.CDATASectionTraceEvent) {
            return ((MarkupTraceEvent.CDATASectionTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.StandaloneElementStartTraceEvent) {
            return ((MarkupTraceEvent.StandaloneElementStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.StandaloneElementEndTraceEvent) {
            return ((MarkupTraceEvent.StandaloneElementEndTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.OpenElementStartTraceEvent) {
            return ((MarkupTraceEvent.OpenElementStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.OpenElementEndTraceEvent) {
            return ((MarkupTraceEvent.OpenElementEndTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.AutoOpenElementStartTraceEvent) {
            return ((MarkupTraceEvent.AutoOpenElementStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.AutoOpenElementEndTraceEvent) {
            return ((MarkupTraceEvent.AutoOpenElementEndTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.CloseElementStartTraceEvent) {
            return ((MarkupTraceEvent.CloseElementStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.CloseElementEndTraceEvent) {
            return ((MarkupTraceEvent.CloseElementEndTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.AutoCloseElementStartTraceEvent) {
            return ((MarkupTraceEvent.AutoCloseElementStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.AutoCloseElementEndTraceEvent) {
            return ((MarkupTraceEvent.AutoCloseElementEndTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.AttributeTraceEvent) {
            return ((MarkupTraceEvent.AttributeTraceEvent)event).getNameCol();
        }
        if (event instanceof MarkupTraceEvent.InnerWhiteSpaceTraceEvent) {
            return ((MarkupTraceEvent.InnerWhiteSpaceTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.NonMinimizedStandaloneElementStartTraceEvent) {
            return ((MarkupTraceEvent.NonMinimizedStandaloneElementStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.NonMinimizedStandaloneElementEndTraceEvent) {
            return ((MarkupTraceEvent.NonMinimizedStandaloneElementEndTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.UnmatchedCloseElementStartTraceEvent) {
            return ((MarkupTraceEvent.UnmatchedCloseElementStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.UnmatchedCloseElementEndTraceEvent) {
            return ((MarkupTraceEvent.UnmatchedCloseElementEndTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.DocumentStartTraceEvent) {
            return ((MarkupTraceEvent.DocumentStartTraceEvent)event).getCol();
        }
        if (event instanceof MarkupTraceEvent.DocumentEndTraceEvent) {
            return ((MarkupTraceEvent.DocumentEndTraceEvent)event).getCol();
        }
        throw new IllegalStateException("Unrecognized event class: " + event.getClass().getName());
    }

    private ResultCompareUtils() {
    }

    static {
        BLOCK_ELEMENTS = new HashSet<String>(Arrays.asList("address", "article", "aside", "audio", "blockquote", "canvas", "dd", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "li", "noscript", "ol", "option", "output", "p", "pre", "section", "table", "tbody", "tfoot", "tr", "td", "th", "ul", "video"));
        BLOCK_CONTAINER_ELEMENTS = new HashSet<String>(Arrays.asList("address", "article", "aside", "div", "dl", "fieldset", "footer", "form", "header", "hgroup", "noscript", "ol", "section", "table", "tbody", "tr", "tfoot", "ul"));
        MARKUP_PARSING_CONFIGURATION = ParseConfiguration.htmlConfiguration();
        MARKUP_PARSING_CONFIGURATION.setElementBalancing(ParseConfiguration.ElementBalancing.AUTO_CLOSE);
        MARKUP_PARSING_CONFIGURATION.setCaseSensitive(false);
        MARKUP_PARSING_CONFIGURATION.setNoUnmatchedCloseElementsRequired(false);
        MARKUP_PARSING_CONFIGURATION.setUniqueAttributesInElementRequired(true);
        MARKUP_PARSING_CONFIGURATION.setXmlWellFormedAttributeValuesRequired(false);
        MARKUP_PARSING_CONFIGURATION.setUniqueRootElementPresence(ParseConfiguration.UniqueRootElementPresence.NOT_VALIDATED);
        MARKUP_PARSING_CONFIGURATION.getPrologParseConfiguration().setDoctypePresence(ParseConfiguration.PrologPresence.ALLOWED);
        MARKUP_PARSING_CONFIGURATION.getPrologParseConfiguration().setRequireDoctypeKeywordsUpperCase(false);
        MARKUP_PARSING_CONFIGURATION.getPrologParseConfiguration().setValidateProlog(false);
        MARKUP_PARSING_CONFIGURATION.getPrologParseConfiguration().setXmlDeclarationPresence(ParseConfiguration.PrologPresence.ALLOWED);
        PARSER = new MarkupParser(MARKUP_PARSING_CONFIGURATION);
    }

    public static class ResultComparison {
        private final boolean result;
        private final String explanation;

        public ResultComparison(boolean result, String explanation) {
            this.result = result;
            this.explanation = explanation;
        }

        public boolean getResult() {
            return this.result;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeEventComparator
    implements Comparator<MarkupTraceEvent> {
        AttributeEventComparator() {
        }

        @Override
        public int compare(MarkupTraceEvent o1, MarkupTraceEvent o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            MarkupTraceEvent.AttributeTraceEvent ao1 = (MarkupTraceEvent.AttributeTraceEvent)o1;
            MarkupTraceEvent.AttributeTraceEvent ao2 = (MarkupTraceEvent.AttributeTraceEvent)o2;
            return ao1.getName().compareTo(ao2.getName());
        }
    }
}

