/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.util.Validate;

public final class ResourceUtils {
    public static File createTempFile(String prefix, String suffix, String contents, String characterEncoding) {
        Validate.notNull((Object)contents, (String)"Contents cannot be null");
        Validate.notNull((Object)characterEncoding, (String)"Character encoding cannot be null");
        try {
            String totalPrefix = "thymeleaf-testing" + (prefix != null ? "-" + prefix : "");
            File tempFile = File.createTempFile(totalPrefix, suffix);
            tempFile.deleteOnExit();
            Writer writer = null;
            try {
                FileOutputStream os = new FileOutputStream(tempFile, false);
                writer = new OutputStreamWriter((OutputStream)os, characterEncoding);
                writer.write(contents);
            }
            catch (Throwable t) {
                throw new TestEngineExecutionException("Could not write contents of temporary file \"" + tempFile.getAbsolutePath() + "\"", t);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Throwable os) {}
            }
            return tempFile;
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Could not create temporary file", t);
        }
    }

    public static String read(InputStream is, String characterEncoding) throws UnsupportedEncodingException, IOException {
        return ResourceUtils.read(is, characterEncoding, false);
    }

    public static String read(InputStream is, String characterEncoding, boolean normalize) throws UnsupportedEncodingException, IOException {
        return ResourceUtils.read(new InputStreamReader(is, characterEncoding), normalize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader reader, boolean normalize) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            StringBuilder strBuilder = new StringBuilder();
            String line = bufferedReader.readLine();
            if (line != null) {
                strBuilder.append(normalize ? ResourceUtils.normalizeLine(line) : line);
                while ((line = bufferedReader.readLine()) != null) {
                    strBuilder.append('\n');
                    strBuilder.append(normalize ? ResourceUtils.normalizeLine(line) : line);
                }
            }
            if (normalize) {
                ResourceUtils.normalizeFileEnd(strBuilder);
            }
            String string = strBuilder.toString();
            return string;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static String normalize(String text) {
        try {
            return ResourceUtils.read(new StringReader(text), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String normalizeLine(String text) {
        StringBuilder strBuilder = new StringBuilder();
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (c == '\r') continue;
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    private static void normalizeFileEnd(StringBuilder strBuilder) {
        if (strBuilder.length() == 0) {
            return;
        }
        int i = strBuilder.length() - 1;
        char c = strBuilder.charAt(i);
        while (Character.isWhitespace(c)) {
            strBuilder.deleteCharAt(i);
            if (i == 0) break;
            c = strBuilder.charAt(--i);
        }
    }

    private ResourceUtils() {
    }
}

