/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.HostMapping;
import org.tikv.common.Utils;
import org.tikv.common.pd.PDUtils;
import org.tikv.common.replica.ReplicaSelector;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.io.grpc.Metadata;

public class TiConfiguration
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TiConfiguration.class);
    private static final ConcurrentHashMap<String, String> settings = new ConcurrentHashMap();
    public static final Metadata.Key<String> FORWARD_META_DATA_KEY = Metadata.Key.of("tikv-forwarded-host", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> PD_FORWARD_META_DATA_KEY = Metadata.Key.of("pd-forwarded-host", Metadata.ASCII_STRING_MARSHALLER);
    public static final ByteString API_V2_RAW_PREFIX = ByteString.copyFromUtf8("r");
    public static final ByteString API_V2_TXN_PREFIX = ByteString.copyFromUtf8("x");
    private long timeout = TiConfiguration.getTimeAsMs("tikv.grpc.timeout_in_ms");
    private long ingestTimeout = TiConfiguration.getTimeAsMs("tikv.grpc.ingest_timeout_in_ms");
    private long forwardTimeout = TiConfiguration.getTimeAsMs("tikv.grpc.forward_timeout_in_ms");
    private long warmUpTimeout = TiConfiguration.getTimeAsMs("tikv.grpc.warm_up_timeout_in_ms");
    private long pdFirstGetMemberTimeout = TiConfiguration.getTimeAsMs("tikv.grpc.pd_first_get_member_timeout_in_ms");
    private long scanTimeout = TiConfiguration.getTimeAsMs("tikv.grpc.scan_timeout_in_ms");
    private int maxFrameSize = TiConfiguration.getInt("tikv.grpc.max_frame_size");
    private long connRecycleTime = TiConfiguration.getTimeAsSeconds("tikv.conn.recycle_time");
    private List<URI> pdAddrs = TiConfiguration.getPdAddrs("tikv.pd.addresses");
    private int indexScanBatchSize = TiConfiguration.getInt("tikv.index.scan_batch_size");
    private int indexScanConcurrency = TiConfiguration.getInt("tikv.index.scan_concurrency");
    private int tableScanConcurrency = TiConfiguration.getInt("tikv.table.scan_concurrency");
    private int batchGetConcurrency = TiConfiguration.getInt("tikv.batch_get_concurrency");
    private int batchPutConcurrency = TiConfiguration.getInt("tikv.batch_put_concurrency");
    private int batchDeleteConcurrency = TiConfiguration.getInt("tikv.batch_delete_concurrency");
    private int batchScanConcurrency = TiConfiguration.getInt("tikv.batch_scan_concurrency");
    private int deleteRangeConcurrency = TiConfiguration.getInt("tikv.delete_range_concurrency");
    private Kvrpcpb.CommandPri commandPriority = TiConfiguration.getCommandPri("tikv.request.command.priority");
    private Kvrpcpb.IsolationLevel isolationLevel = TiConfiguration.getIsolationLevel("tikv.request.isolation.level");
    private boolean showRowId = TiConfiguration.getBoolean("tikv.show_rowid");
    private String dbPrefix = TiConfiguration.get("tikv.db_prefix");
    private KVMode kvMode = TiConfiguration.getKvMode("tikv.kv_mode");
    private boolean enableGrpcForward = TiConfiguration.getBoolean("tikv.enable_grpc_forward");
    private int kvClientConcurrency = TiConfiguration.getInt("tikv.kv_client_concurrency");
    private ReplicaRead replicaRead = TiConfiguration.getReplicaRead("tikv.replica_read");
    private ReplicaSelector internalReplicaSelector = this.getReplicaSelector(this.replicaRead);
    private ReplicaSelector replicaSelector;
    private boolean metricsEnable = TiConfiguration.getBoolean("tikv.metrics.enable");
    private int metricsPort = TiConfiguration.getInt("tikv.metrics.port");
    private int grpcHealthCheckTimeout = TiConfiguration.getInt("tikv.grpc.health_check_timeout");
    private int healthCheckPeriodDuration = TiConfiguration.getInt("tikv.health_check_period_duration");
    private final String networkMappingName = TiConfiguration.get("tikv.network.mapping");
    private HostMapping hostMapping = null;
    private boolean enableAtomicForCAS = TiConfiguration.getBoolean("tikv.enable_atomic_for_cas");
    private int importerMaxKVBatchBytes = TiConfiguration.getInt("tikv.importer.max_kv_batch_bytes");
    private int importerMaxKVBatchSize = TiConfiguration.getInt("tikv.importer.max_kv_batch_size");
    private int scatterWaitSeconds = TiConfiguration.getInt("tikv.scatter_wait_seconds");
    private int rawKVDefaultBackoffInMS = TiConfiguration.getInt("tikv.rawkv.default_backoff_in_ms");
    private int rawKVReadTimeoutInMS = TiConfiguration.getInt("tikv.rawkv.read_timeout_in_ms");
    private int rawKVWriteTimeoutInMS = TiConfiguration.getInt("tikv.rawkv.write_timeout_in_ms");
    private int rawKVBatchReadTimeoutInMS = TiConfiguration.getInt("tikv.rawkv.batch_read_timeout_in_ms");
    private int rawKVBatchWriteTimeoutInMS = TiConfiguration.getInt("tikv.rawkv.batch_write_timeout_in_ms");
    private int rawKVScanTimeoutInMS = TiConfiguration.getInt("tikv.rawkv.scan_timeout_in_ms");
    private int rawKVCleanTimeoutInMS = TiConfiguration.getInt("tikv.rawkv.clean_timeout_in_ms");
    private Integer rawKVReadSlowLogInMS = TiConfiguration.getIntOption("tikv.rawkv.read_slowlog_in_ms").orElse(null);
    private Integer rawKVWriteSlowLogInMS = TiConfiguration.getIntOption("tikv.rawkv.write_slowlog_in_ms").orElse(null);
    private Integer rawKVBatchReadSlowLogInMS = TiConfiguration.getIntOption("tikv.rawkv.batch_read_slowlog_in_ms").orElse(null);
    private Integer rawKVBatchWriteSlowLogInMS = TiConfiguration.getIntOption("tikv.rawkv.batch_write_slowlog_in_ms").orElse(null);
    private int rawKVScanSlowLogInMS = TiConfiguration.getInt("tikv.rawkv.scan_slowlog_in_ms");
    private double rawKVServerSlowLogFactor = TiConfiguration.getDouble("tikv.rawkv.server_slowlog_factor", 0.5);
    private boolean tlsEnable = TiConfiguration.getBoolean("tikv.tls_enable");
    private long certReloadInterval = TiConfiguration.getTimeAsSeconds("tikv.tls.reload_interval");
    private String trustCertCollectionFile = TiConfiguration.getOption("tikv.trust_cert_collection").orElse(null);
    private String keyCertChainFile = TiConfiguration.getOption("tikv.key_cert_chain").orElse(null);
    private String keyFile = TiConfiguration.getOption("tikv.key_file").orElse(null);
    private boolean useJks = TiConfiguration.getBoolean("tikv.use_jks");
    private String jksKeyPath = TiConfiguration.getOption("tikv.jks.key_path").orElse(null);
    private String jksKeyPassword = TiConfiguration.getOption("tikv.jks.key_password").orElse(null);
    private String jksTrustPath = TiConfiguration.getOption("tikv.jks.trust_path").orElse(null);
    private String jksTrustPassword = TiConfiguration.getOption("tikv.jks.trust_password").orElse(null);
    private final boolean tiFlashEnable = TiConfiguration.getBoolean("tiflash.enable");
    private boolean warmUpEnable = TiConfiguration.getBoolean("tikv.warm_up.enable");
    private boolean isTest = false;
    private int keepaliveTime = TiConfiguration.getInt("tikv.grpc.keepalive_time");
    private int keepaliveTimeout = TiConfiguration.getInt("tikv.grpc.keepalive_timeout");
    private int idleTimeout = TiConfiguration.getInt("tikv.grpc.idle_timeout");
    private boolean circuitBreakEnable = TiConfiguration.getBoolean("tikv.circuit_break.enable");
    private int circuitBreakAvailabilityWindowInSeconds = TiConfiguration.getInt("tikv.circuit_break.trigger.availability.window_in_seconds");
    private int circuitBreakAvailabilityErrorThresholdPercentage = TiConfiguration.getInt("tikv.circuit_break.trigger.availability.error_threshold_percentage");
    private int circuitBreakAvailabilityRequestVolumnThreshold = TiConfiguration.getInt("tikv.circuit_break.trigger.availability.request_volumn_threshold");
    private int circuitBreakSleepWindowInSeconds = TiConfiguration.getInt("tikv.circuit_break.trigger.sleep_window_in_seconds");
    private int circuitBreakAttemptRequestCount = TiConfiguration.getInt("tikv.circuit_break.trigger.attempt_request_count");
    private int scanRegionsLimit = TiConfiguration.getInt("tikv.scan_regions_limit");
    private ApiVersion apiVersion = ApiVersion.fromInt(TiConfiguration.getInt("tikv.api_version"));

    private static void loadFromSystemProperties() {
        for (Map.Entry<String, String> prop : Utils.getSystemProperties().entrySet()) {
            if (!prop.getKey().startsWith("tikv.")) continue;
            TiConfiguration.set(prop.getKey(), prop.getValue());
        }
    }

    private static void loadFromConfigurationFile() {
        try (InputStream input = TiConfiguration.class.getClassLoader().getResourceAsStream("tikv.properties");){
            Properties properties = new Properties();
            if (input == null) {
                logger.warn("Unable to find tikv.properties");
                return;
            }
            logger.info("loading tikv.properties");
            properties.load(input);
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith("tikv.")) continue;
                String value = properties.getProperty(key);
                TiConfiguration.setIfMissing(key, value);
            }
        }
        catch (IOException e) {
            logger.error("load config file error", (Throwable)e);
        }
    }

    private static void loadFromDefaultProperties() {
        TiConfiguration.setIfMissing("tikv.pd.addresses", "127.0.0.1:2379");
        TiConfiguration.setIfMissing("tikv.grpc.timeout_in_ms", "200ms");
        TiConfiguration.setIfMissing("tikv.grpc.ingest_timeout_in_ms", "200s");
        TiConfiguration.setIfMissing("tikv.grpc.forward_timeout_in_ms", "300ms");
        TiConfiguration.setIfMissing("tikv.grpc.warm_up_timeout_in_ms", "5000ms");
        TiConfiguration.setIfMissing("tikv.grpc.pd_first_get_member_timeout_in_ms", "10000ms");
        TiConfiguration.setIfMissing("tikv.grpc.scan_timeout_in_ms", "20s");
        TiConfiguration.setIfMissing("tikv.grpc.scan_batch_size", 10240);
        TiConfiguration.setIfMissing("tikv.grpc.max_frame_size", 0x20000000);
        TiConfiguration.setIfMissing("tikv.conn.recycle_time", "60s");
        TiConfiguration.setIfMissing("tikv.tls.reload_interval", "10s");
        TiConfiguration.setIfMissing("tikv.index.scan_batch_size", 20000);
        TiConfiguration.setIfMissing("tikv.index.scan_concurrency", 5);
        TiConfiguration.setIfMissing("tikv.table.scan_concurrency", 512);
        TiConfiguration.setIfMissing("tikv.batch_get_concurrency", 20);
        TiConfiguration.setIfMissing("tikv.batch_put_concurrency", 20);
        TiConfiguration.setIfMissing("tikv.batch_delete_concurrency", 20);
        TiConfiguration.setIfMissing("tikv.batch_scan_concurrency", 5);
        TiConfiguration.setIfMissing("tikv.delete_range_concurrency", 20);
        TiConfiguration.setIfMissing("tikv.request.command.priority", "LOW");
        TiConfiguration.setIfMissing("tikv.request.isolation.level", "SI");
        TiConfiguration.setIfMissing("tikv.request.isolation.level", "SI");
        TiConfiguration.setIfMissing("tikv.show_rowid", false);
        TiConfiguration.setIfMissing("tikv.db_prefix", "");
        TiConfiguration.setIfMissing("tikv.db_prefix", "");
        TiConfiguration.setIfMissing("tikv.kv_client_concurrency", 10);
        TiConfiguration.setIfMissing("tikv.kv_mode", "TXN");
        TiConfiguration.setIfMissing("tikv.replica_read", "LEADER");
        TiConfiguration.setIfMissing("tikv.metrics.enable", false);
        TiConfiguration.setIfMissing("tikv.metrics.port", 3140);
        TiConfiguration.setIfMissing("tikv.network.mapping", "");
        TiConfiguration.setIfMissing("tikv.enable_grpc_forward", true);
        TiConfiguration.setIfMissing("tikv.grpc.health_check_timeout", 100);
        TiConfiguration.setIfMissing("tikv.health_check_period_duration", 300);
        TiConfiguration.setIfMissing("tikv.enable_atomic_for_cas", false);
        TiConfiguration.setIfMissing("tikv.importer.max_kv_batch_bytes", 0x100000);
        TiConfiguration.setIfMissing("tikv.importer.max_kv_batch_size", 32768);
        TiConfiguration.setIfMissing("tikv.scatter_wait_seconds", 300);
        TiConfiguration.setIfMissing("tikv.rawkv.default_backoff_in_ms", 20000);
        TiConfiguration.setIfMissing("tikv.grpc.keepalive_time", 10);
        TiConfiguration.setIfMissing("tikv.grpc.keepalive_timeout", 3);
        TiConfiguration.setIfMissing("tikv.grpc.idle_timeout", 60);
        TiConfiguration.setIfMissing("tikv.tls_enable", false);
        TiConfiguration.setIfMissing("tikv.use_jks", false);
        TiConfiguration.setIfMissing("tiflash.enable", false);
        TiConfiguration.setIfMissing("tikv.warm_up.enable", true);
        TiConfiguration.setIfMissing("tikv.rawkv.read_timeout_in_ms", 2000);
        TiConfiguration.setIfMissing("tikv.rawkv.write_timeout_in_ms", 2000);
        TiConfiguration.setIfMissing("tikv.rawkv.batch_read_timeout_in_ms", 2000);
        TiConfiguration.setIfMissing("tikv.rawkv.batch_write_timeout_in_ms", 2000);
        TiConfiguration.setIfMissing("tikv.rawkv.scan_timeout_in_ms", 10000);
        TiConfiguration.setIfMissing("tikv.rawkv.clean_timeout_in_ms", 600000);
        TiConfiguration.setIfMissing("tikv.bo_region_miss_base_in_ms", 20);
        TiConfiguration.setIfMissing("tikv.rawkv.scan_slowlog_in_ms", "5000");
        TiConfiguration.setIfMissing("tikv.circuit_break.enable", false);
        TiConfiguration.setIfMissing("tikv.circuit_break.trigger.availability.window_in_seconds", 60);
        TiConfiguration.setIfMissing("tikv.circuit_break.trigger.availability.error_threshold_percentage", 100);
        TiConfiguration.setIfMissing("tikv.circuit_break.trigger.availability.request_volumn_threshold", 10);
        TiConfiguration.setIfMissing("tikv.circuit_break.trigger.sleep_window_in_seconds", 20);
        TiConfiguration.setIfMissing("tikv.circuit_break.trigger.attempt_request_count", 10);
        TiConfiguration.setIfMissing("tikv.scan_regions_limit", 1000);
        TiConfiguration.setIfMissing("tikv.api_version", 1);
    }

    public static void listAll() {
        logger.info("static configurations are:" + new ArrayList<Map.Entry<String, String>>(settings.entrySet()));
    }

    private static void set(String key, String value) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        if (value == null) {
            throw new NullPointerException("null value for " + key);
        }
        settings.put(key, value);
    }

    private static void setIfMissing(String key, int value) {
        TiConfiguration.setIfMissing(key, String.valueOf(value));
    }

    private static void setIfMissing(String key, boolean value) {
        TiConfiguration.setIfMissing(key, String.valueOf(value));
    }

    private static void setIfMissing(String key, String value) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        if (value == null) {
            throw new NullPointerException("null value for " + key);
        }
        settings.putIfAbsent(key, value);
    }

    private static Optional<String> getOption(String key) {
        return Optional.ofNullable(settings.get(key));
    }

    private static String get(String key) {
        Optional<String> option = TiConfiguration.getOption(key);
        if (!option.isPresent()) {
            throw new NoSuchElementException(key);
        }
        return option.get();
    }

    public static int getInt(String key) {
        return Integer.parseInt(TiConfiguration.get(key));
    }

    public static Optional<Integer> getIntOption(String key) {
        return TiConfiguration.getOption(key).map(Integer::parseInt);
    }

    private static int getInt(String key, int defaultValue) {
        try {
            return TiConfiguration.getOption(key).map(Integer::parseInt).orElse(defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static long getLong(String key) {
        return Long.parseLong(TiConfiguration.get(key));
    }

    private static long getLong(String key, long defaultValue) {
        try {
            return TiConfiguration.getOption(key).map(Long::parseLong).orElse(defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static double getDouble(String key) {
        return Double.parseDouble(TiConfiguration.get(key));
    }

    private static double getDouble(String key, double defaultValue) {
        try {
            return TiConfiguration.getOption(key).map(Double::parseDouble).orElse(defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static boolean getBoolean(String key) {
        return Boolean.parseBoolean(TiConfiguration.get(key));
    }

    private static boolean getBoolean(String key, boolean defaultValue) {
        try {
            return TiConfiguration.getOption(key).map(Boolean::parseBoolean).orElse(defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Long getTimeAsMs(String key) {
        return Utils.timeStringAsMs(TiConfiguration.get(key));
    }

    private static Long getTimeAsSeconds(String key) {
        return Utils.timeStringAsSec(TiConfiguration.get(key));
    }

    private static List<URI> getPdAddrs(String key) {
        Optional<String> pdAddrs = TiConfiguration.getOption(key);
        if (pdAddrs.isPresent()) {
            return TiConfiguration.strToURI(pdAddrs.get());
        }
        return new ArrayList<URI>();
    }

    private static Kvrpcpb.CommandPri getCommandPri(String key) {
        String priority;
        switch (priority = TiConfiguration.get(key).toUpperCase(Locale.ROOT)) {
            case "NORMAL": {
                return Kvrpcpb.CommandPri.Normal;
            }
            case "LOW": {
                return Kvrpcpb.CommandPri.Low;
            }
            case "HIGH": {
                return Kvrpcpb.CommandPri.High;
            }
        }
        return Kvrpcpb.CommandPri.UNRECOGNIZED;
    }

    private static Kvrpcpb.IsolationLevel getIsolationLevel(String key) {
        String isolationLevel;
        switch (isolationLevel = TiConfiguration.get(key).toUpperCase(Locale.ROOT)) {
            case "RC": {
                return Kvrpcpb.IsolationLevel.RC;
            }
            case "SI": {
                return Kvrpcpb.IsolationLevel.SI;
            }
        }
        return Kvrpcpb.IsolationLevel.UNRECOGNIZED;
    }

    private static KVMode getKvMode(String key) {
        if (TiConfiguration.get(key).toUpperCase(Locale.ROOT).equals("RAW")) {
            return KVMode.RAW;
        }
        return KVMode.TXN;
    }

    private static ReplicaRead getReplicaRead(String key) {
        String value = TiConfiguration.get(key).toUpperCase(Locale.ROOT);
        if ("FOLLOWER".equals(value)) {
            return ReplicaRead.FOLLOWER;
        }
        if ("LEADER_AND_FOLLOWER".equals(value)) {
            return ReplicaRead.LEADER_AND_FOLLOWER;
        }
        return ReplicaRead.LEADER;
    }

    public TiConfiguration() {
        if (this.rawKVServerSlowLogFactor < 0.0 || this.rawKVServerSlowLogFactor > 1.0) {
            throw new IllegalArgumentException("rawkv_server_slowlog_factor must be in range [0, 1]");
        }
    }

    public static TiConfiguration createDefault() {
        return new TiConfiguration();
    }

    public static TiConfiguration createDefault(String pdAddrsStr) {
        Objects.requireNonNull(pdAddrsStr, "pdAddrsStr is null");
        TiConfiguration conf = new TiConfiguration();
        conf.pdAddrs = TiConfiguration.strToURI(pdAddrsStr);
        return conf;
    }

    public static TiConfiguration createRawDefault() {
        TiConfiguration conf = new TiConfiguration();
        conf.kvMode = KVMode.RAW;
        return conf;
    }

    public static TiConfiguration createRawDefault(String pdAddrsStr) {
        Objects.requireNonNull(pdAddrsStr, "pdAddrsStr is null");
        TiConfiguration conf = new TiConfiguration();
        conf.pdAddrs = TiConfiguration.strToURI(pdAddrsStr);
        conf.kvMode = KVMode.RAW;
        return conf;
    }

    private static List<URI> strToURI(String addressStr) {
        Objects.requireNonNull(addressStr);
        Object[] addrs = addressStr.split(",");
        Arrays.sort(addrs);
        return PDUtils.addrsToUrls((String[])addrs);
    }

    public static <E> String listToString(List<E> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i).toString());
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TiConfiguration setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public long getIngestTimeout() {
        return this.ingestTimeout;
    }

    public void setIngestTimeout(long ingestTimeout) {
        this.ingestTimeout = ingestTimeout;
    }

    public long getForwardTimeout() {
        return this.forwardTimeout;
    }

    public TiConfiguration setForwardTimeout(long timeout) {
        this.forwardTimeout = timeout;
        return this;
    }

    public long getWarmUpTimeout() {
        return this.warmUpTimeout;
    }

    public TiConfiguration setWarmUpTimeout(long timeout) {
        this.warmUpTimeout = timeout;
        return this;
    }

    public long getPdFirstGetMemberTimeout() {
        return this.pdFirstGetMemberTimeout;
    }

    public void setPdFirstGetMemberTimeout(long pdFirstGetMemberTimeout) {
        this.pdFirstGetMemberTimeout = pdFirstGetMemberTimeout;
    }

    public long getScanTimeout() {
        return this.scanTimeout;
    }

    public TiConfiguration setScanTimeout(long scanTimeout) {
        this.scanTimeout = scanTimeout;
        return this;
    }

    public List<URI> getPdAddrs() {
        return this.pdAddrs;
    }

    public String getPdAddrsString() {
        return TiConfiguration.listToString(this.pdAddrs);
    }

    public int getScanBatchSize() {
        return 10240;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public TiConfiguration setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public long getConnRecycleTimeInSeconds() {
        return this.connRecycleTime;
    }

    public TiConfiguration setConnRecycleTimeInSeconds(int connRecycleTime) {
        this.connRecycleTime = connRecycleTime;
        return this;
    }

    public int getIndexScanBatchSize() {
        return this.indexScanBatchSize;
    }

    public TiConfiguration setIndexScanBatchSize(int indexScanBatchSize) {
        this.indexScanBatchSize = indexScanBatchSize;
        return this;
    }

    public int getIndexScanConcurrency() {
        return this.indexScanConcurrency;
    }

    public TiConfiguration setIndexScanConcurrency(int indexScanConcurrency) {
        this.indexScanConcurrency = indexScanConcurrency;
        return this;
    }

    public int getTableScanConcurrency() {
        return this.tableScanConcurrency;
    }

    public TiConfiguration setTableScanConcurrency(int tableScanConcurrency) {
        this.tableScanConcurrency = tableScanConcurrency;
        return this;
    }

    public int getBatchGetConcurrency() {
        return this.batchGetConcurrency;
    }

    public TiConfiguration setBatchGetConcurrency(int batchGetConcurrency) {
        this.batchGetConcurrency = batchGetConcurrency;
        return this;
    }

    public int getBatchPutConcurrency() {
        return this.batchPutConcurrency;
    }

    public TiConfiguration setBatchPutConcurrency(int batchPutConcurrency) {
        this.batchPutConcurrency = batchPutConcurrency;
        return this;
    }

    public int getBatchDeleteConcurrency() {
        return this.batchDeleteConcurrency;
    }

    public TiConfiguration setBatchDeleteConcurrency(int batchDeleteConcurrency) {
        this.batchDeleteConcurrency = batchDeleteConcurrency;
        return this;
    }

    public int getBatchScanConcurrency() {
        return this.batchScanConcurrency;
    }

    public TiConfiguration setBatchScanConcurrency(int batchScanConcurrency) {
        this.batchScanConcurrency = batchScanConcurrency;
        return this;
    }

    public int getDeleteRangeConcurrency() {
        return this.deleteRangeConcurrency;
    }

    public TiConfiguration setDeleteRangeConcurrency(int deleteRangeConcurrency) {
        this.deleteRangeConcurrency = deleteRangeConcurrency;
        return this;
    }

    public Kvrpcpb.CommandPri getCommandPriority() {
        return this.commandPriority;
    }

    public TiConfiguration setCommandPriority(Kvrpcpb.CommandPri commandPriority) {
        this.commandPriority = commandPriority;
        return this;
    }

    public Kvrpcpb.IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public TiConfiguration setIsolationLevel(Kvrpcpb.IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public boolean ifShowRowId() {
        return this.showRowId;
    }

    public TiConfiguration setShowRowId(boolean flag) {
        this.showRowId = flag;
        return this;
    }

    public String getDBPrefix() {
        return this.dbPrefix;
    }

    public TiConfiguration setDBPrefix(String dbPrefix) {
        this.dbPrefix = dbPrefix;
        return this;
    }

    public KVMode getKvMode() {
        return this.kvMode;
    }

    public boolean isRawKVMode() {
        return this.getKvMode() == KVMode.RAW;
    }

    public boolean isTxnKVMode() {
        return this.getKvMode() == KVMode.TXN;
    }

    public TiConfiguration setKvMode(String kvMode) {
        this.kvMode = KVMode.valueOf(kvMode);
        return this;
    }

    public int getKvClientConcurrency() {
        return this.kvClientConcurrency;
    }

    public TiConfiguration setKvClientConcurrency(int kvClientConcurrency) {
        this.kvClientConcurrency = kvClientConcurrency;
        return this;
    }

    public ReplicaRead getReplicaRead() {
        return this.replicaRead;
    }

    public TiConfiguration setReplicaRead(ReplicaRead replicaRead) {
        this.replicaRead = replicaRead;
        this.internalReplicaSelector = this.getReplicaSelector(this.replicaRead);
        return this;
    }

    private ReplicaSelector getReplicaSelector(ReplicaRead replicaRead) {
        if (ReplicaRead.LEADER.equals((Object)replicaRead)) {
            return ReplicaSelector.LEADER;
        }
        if (ReplicaRead.FOLLOWER.equals((Object)replicaRead)) {
            return ReplicaSelector.FOLLOWER;
        }
        if (ReplicaRead.LEADER_AND_FOLLOWER.equals((Object)replicaRead)) {
            return ReplicaSelector.LEADER_AND_FOLLOWER;
        }
        return null;
    }

    public ReplicaSelector getReplicaSelector() {
        if (this.replicaSelector != null) {
            return this.replicaSelector;
        }
        return this.internalReplicaSelector;
    }

    public void setReplicaSelector(ReplicaSelector replicaSelector) {
        this.replicaSelector = replicaSelector;
    }

    public boolean isMetricsEnable() {
        return this.metricsEnable;
    }

    public TiConfiguration setMetricsEnable(boolean metricsEnable) {
        this.metricsEnable = metricsEnable;
        return this;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public TiConfiguration setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
        return this;
    }

    public String getNetworkMappingName() {
        return this.networkMappingName;
    }

    public HostMapping getHostMapping() {
        return this.hostMapping;
    }

    public void setHostMapping(HostMapping mapping) {
        this.hostMapping = mapping;
    }

    public boolean getEnableGrpcForward() {
        return this.enableGrpcForward;
    }

    public void setEnableGrpcForward(boolean enableGrpcForward) {
        this.enableGrpcForward = enableGrpcForward;
    }

    public long getGrpcHealthCheckTimeout() {
        return this.grpcHealthCheckTimeout;
    }

    public void setGrpcHealthCheckTimeout(int grpcHealthCheckTimeout) {
        this.grpcHealthCheckTimeout = grpcHealthCheckTimeout;
    }

    public long getHealthCheckPeriodDuration() {
        return this.healthCheckPeriodDuration;
    }

    public void setHealthCheckPeriodDuration(int healthCheckPeriodDuration) {
        this.healthCheckPeriodDuration = healthCheckPeriodDuration;
    }

    public boolean isEnableAtomicForCAS() {
        return this.enableAtomicForCAS;
    }

    public void setEnableAtomicForCAS(boolean enableAtomicForCAS) {
        this.enableAtomicForCAS = enableAtomicForCAS;
    }

    public int getImporterMaxKVBatchBytes() {
        return this.importerMaxKVBatchBytes;
    }

    public void setImporterMaxKVBatchBytes(int importerMaxKVBatchBytes) {
        this.importerMaxKVBatchBytes = importerMaxKVBatchBytes;
    }

    public int getImporterMaxKVBatchSize() {
        return this.importerMaxKVBatchSize;
    }

    public void setImporterMaxKVBatchSize(int importerMaxKVBatchSize) {
        this.importerMaxKVBatchSize = importerMaxKVBatchSize;
    }

    public int getScatterWaitSeconds() {
        return this.scatterWaitSeconds;
    }

    public void setScatterWaitSeconds(int scatterWaitSeconds) {
        this.scatterWaitSeconds = scatterWaitSeconds;
    }

    public int getRawKVDefaultBackoffInMS() {
        return this.rawKVDefaultBackoffInMS;
    }

    public void setRawKVDefaultBackoffInMS(int rawKVDefaultBackoffInMS) {
        this.rawKVDefaultBackoffInMS = rawKVDefaultBackoffInMS;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public void setTest(boolean test) {
        this.isTest = test;
    }

    public int getKeepaliveTime() {
        return this.keepaliveTime;
    }

    public void setKeepaliveTime(int keepaliveTime) {
        this.keepaliveTime = keepaliveTime;
    }

    public int getKeepaliveTimeout() {
        return this.keepaliveTimeout;
    }

    public void setKeepaliveTimeout(int timeout) {
        this.keepaliveTimeout = timeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int timeout) {
        this.idleTimeout = timeout;
    }

    public boolean isTiFlashEnabled() {
        return this.tiFlashEnable;
    }

    public boolean isWarmUpEnable() {
        return this.warmUpEnable;
    }

    public void setWarmUpEnable(boolean warmUpEnable) {
        this.warmUpEnable = warmUpEnable;
    }

    public boolean isTlsEnable() {
        return this.tlsEnable;
    }

    public long getCertReloadIntervalInSeconds() {
        return this.certReloadInterval;
    }

    public TiConfiguration setCertReloadIntervalInSeconds(long interval) {
        this.certReloadInterval = interval;
        return this;
    }

    public void setTlsEnable(boolean tlsEnable) {
        this.tlsEnable = tlsEnable;
    }

    public String getTrustCertCollectionFile() {
        return this.trustCertCollectionFile;
    }

    public void setTrustCertCollectionFile(String trustCertCollectionFile) {
        this.trustCertCollectionFile = trustCertCollectionFile;
    }

    public String getKeyCertChainFile() {
        return this.keyCertChainFile;
    }

    public void setKeyCertChainFile(String keyCertChainFile) {
        this.keyCertChainFile = keyCertChainFile;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public boolean isJksEnable() {
        return this.useJks;
    }

    public void setJksEnable(boolean useJks) {
        this.useJks = useJks;
    }

    public String getJksKeyPath() {
        return this.jksKeyPath;
    }

    public void setJksKeyPath(String jksKeyPath) {
        this.jksKeyPath = jksKeyPath;
    }

    public String getJksKeyPassword() {
        return this.jksKeyPassword;
    }

    public void setJksKeyPassword(String jksKeyPassword) {
        this.jksKeyPassword = jksKeyPassword;
    }

    public String getJksTrustPath() {
        return this.jksTrustPath;
    }

    public void setJksTrustPath(String jksTrustPath) {
        this.jksTrustPath = jksTrustPath;
    }

    public String getJksTrustPassword() {
        return this.jksTrustPassword;
    }

    public void setJksTrustPassword(String jksTrustPassword) {
        this.jksTrustPassword = jksTrustPassword;
    }

    public int getRawKVReadTimeoutInMS() {
        return this.rawKVReadTimeoutInMS;
    }

    public void setRawKVReadTimeoutInMS(int rawKVReadTimeoutInMS) {
        this.rawKVReadTimeoutInMS = rawKVReadTimeoutInMS;
    }

    public int getRawKVWriteTimeoutInMS() {
        return this.rawKVWriteTimeoutInMS;
    }

    public void setRawKVWriteTimeoutInMS(int rawKVWriteTimeoutInMS) {
        this.rawKVWriteTimeoutInMS = rawKVWriteTimeoutInMS;
    }

    public int getRawKVBatchReadTimeoutInMS() {
        return this.rawKVBatchReadTimeoutInMS;
    }

    public void setRawKVBatchReadTimeoutInMS(int rawKVBatchReadTimeoutInMS) {
        this.rawKVBatchReadTimeoutInMS = rawKVBatchReadTimeoutInMS;
    }

    public int getRawKVBatchWriteTimeoutInMS() {
        return this.rawKVBatchWriteTimeoutInMS;
    }

    public void setRawKVBatchWriteTimeoutInMS(int rawKVBatchWriteTimeoutInMS) {
        this.rawKVBatchWriteTimeoutInMS = rawKVBatchWriteTimeoutInMS;
    }

    public int getRawKVScanTimeoutInMS() {
        return this.rawKVScanTimeoutInMS;
    }

    public void setRawKVScanTimeoutInMS(int rawKVScanTimeoutInMS) {
        this.rawKVScanTimeoutInMS = rawKVScanTimeoutInMS;
    }

    public int getRawKVCleanTimeoutInMS() {
        return this.rawKVCleanTimeoutInMS;
    }

    public void setRawKVCleanTimeoutInMS(int rawKVCleanTimeoutInMS) {
        this.rawKVCleanTimeoutInMS = rawKVCleanTimeoutInMS;
    }

    public Integer getRawKVReadSlowLogInMS() {
        return Optional.ofNullable(this.rawKVReadSlowLogInMS).orElse((int)(this.getTimeout() * 2L));
    }

    public void setRawKVReadSlowLogInMS(Integer rawKVReadSlowLogInMS) {
        this.rawKVReadSlowLogInMS = rawKVReadSlowLogInMS;
    }

    public Integer getRawKVWriteSlowLogInMS() {
        return Optional.ofNullable(this.rawKVWriteSlowLogInMS).orElse((int)(this.getTimeout() * 2L));
    }

    public void setRawKVWriteSlowLogInMS(Integer rawKVWriteSlowLogInMS) {
        this.rawKVWriteSlowLogInMS = rawKVWriteSlowLogInMS;
    }

    public Integer getRawKVBatchReadSlowLogInMS() {
        return Optional.ofNullable(this.rawKVBatchReadSlowLogInMS).orElse((int)(this.getTimeout() * 2L));
    }

    public void setRawKVBatchReadSlowLogInMS(Integer rawKVBatchReadSlowLogInMS) {
        this.rawKVBatchReadSlowLogInMS = rawKVBatchReadSlowLogInMS;
    }

    public Integer getRawKVBatchWriteSlowLogInMS() {
        return Optional.ofNullable(this.rawKVBatchWriteSlowLogInMS).orElse((int)(this.getTimeout() * 2L));
    }

    public void setRawKVBatchWriteSlowLogInMS(Integer rawKVBatchWriteSlowLogInMS) {
        this.rawKVBatchWriteSlowLogInMS = rawKVBatchWriteSlowLogInMS;
    }

    public int getRawKVScanSlowLogInMS() {
        return this.rawKVScanSlowLogInMS;
    }

    public void setRawKVScanSlowLogInMS(int rawKVScanSlowLogInMS) {
        this.rawKVScanSlowLogInMS = rawKVScanSlowLogInMS;
    }

    public double getRawKVServerSlowLogFactor() {
        return this.rawKVServerSlowLogFactor;
    }

    public void setRawKVServerSlowLogFactor(double rawKVServerSlowLogFactor) {
        if (rawKVServerSlowLogFactor < 0.0 || rawKVServerSlowLogFactor > 1.0) {
            throw new IllegalArgumentException("rawkv_server_slowlog_factor must be in range [0, 1]");
        }
        this.rawKVServerSlowLogFactor = rawKVServerSlowLogFactor;
    }

    public boolean isCircuitBreakEnable() {
        return this.circuitBreakEnable;
    }

    public void setCircuitBreakEnable(boolean circuitBreakEnable) {
        this.circuitBreakEnable = circuitBreakEnable;
    }

    public int getCircuitBreakAvailabilityWindowInSeconds() {
        return this.circuitBreakAvailabilityWindowInSeconds;
    }

    public void setCircuitBreakAvailabilityWindowInSeconds(int circuitBreakAvailabilityWindowInSeconds) {
        this.circuitBreakAvailabilityWindowInSeconds = circuitBreakAvailabilityWindowInSeconds;
    }

    public int getCircuitBreakAvailabilityErrorThresholdPercentage() {
        return this.circuitBreakAvailabilityErrorThresholdPercentage;
    }

    public void setCircuitBreakAvailabilityErrorThresholdPercentage(int circuitBreakAvailabilityErrorThresholdPercentage) {
        this.circuitBreakAvailabilityErrorThresholdPercentage = circuitBreakAvailabilityErrorThresholdPercentage;
    }

    public int getCircuitBreakAvailabilityRequestVolumnThreshold() {
        return this.circuitBreakAvailabilityRequestVolumnThreshold;
    }

    public void setCircuitBreakAvailabilityRequestVolumnThreshold(int circuitBreakAvailabilityRequestVolumnThreshold) {
        this.circuitBreakAvailabilityRequestVolumnThreshold = circuitBreakAvailabilityRequestVolumnThreshold;
    }

    public int getCircuitBreakSleepWindowInSeconds() {
        return this.circuitBreakSleepWindowInSeconds;
    }

    public void setCircuitBreakSleepWindowInSeconds(int circuitBreakSleepWindowInSeconds) {
        this.circuitBreakSleepWindowInSeconds = circuitBreakSleepWindowInSeconds;
    }

    public int getCircuitBreakAttemptRequestCount() {
        return this.circuitBreakAttemptRequestCount;
    }

    public void setCircuitBreakAttemptRequestCount(int circuitBreakAttemptRequestCount) {
        this.circuitBreakAttemptRequestCount = circuitBreakAttemptRequestCount;
    }

    public int getScanRegionsLimit() {
        return this.scanRegionsLimit;
    }

    public void setScanRegionsLimit(int scanRegionsLimit) {
        this.scanRegionsLimit = scanRegionsLimit;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public TiConfiguration setApiVersion(ApiVersion version) {
        this.apiVersion = version;
        return this;
    }

    static {
        TiConfiguration.loadFromSystemProperties();
        TiConfiguration.loadFromConfigurationFile();
        TiConfiguration.loadFromDefaultProperties();
        TiConfiguration.listAll();
    }

    public static enum ApiVersion {
        V1,
        V2;


        public static ApiVersion fromInt(int version) {
            switch (version) {
                case 1: {
                    return V1;
                }
                case 2: {
                    return V2;
                }
            }
            throw new IllegalArgumentException("unknown api version " + version);
        }

        public boolean isV1() {
            return this == V1;
        }

        public boolean isV2() {
            return this == V2;
        }

        public Kvrpcpb.APIVersion toPb() {
            switch (this) {
                case V1: {
                    return Kvrpcpb.APIVersion.V1;
                }
                case V2: {
                    return Kvrpcpb.APIVersion.V2;
                }
            }
            throw new IllegalArgumentException("unknown api version " + (Object)((Object)this));
        }
    }

    public static enum ReplicaRead {
        LEADER,
        FOLLOWER,
        LEADER_AND_FOLLOWER;

    }

    public static enum KVMode {
        TXN,
        RAW;

    }
}

