/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.MetricsServer;
import org.tikv.common.PDClient;
import org.tikv.common.ReadOnlyPDClient;
import org.tikv.common.Snapshot;
import org.tikv.common.StoreVersion;
import org.tikv.common.TiConfiguration;
import org.tikv.common.apiversion.RequestKeyCodec;
import org.tikv.common.apiversion.RequestKeyV1RawCodec;
import org.tikv.common.apiversion.RequestKeyV1TxnCodec;
import org.tikv.common.apiversion.RequestKeyV2RawCodec;
import org.tikv.common.apiversion.RequestKeyV2TxnCodec;
import org.tikv.common.catalog.Catalog;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.importer.ImporterStoreClient;
import org.tikv.common.importer.SwitchTiKVModeClient;
import org.tikv.common.key.Key;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import org.tikv.common.util.ClientUtils;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.Metapb;
import org.tikv.kvproto.Pdpb;
import org.tikv.raw.RawKVClient;
import org.tikv.raw.SmartRawKVClient;
import org.tikv.service.failsafe.CircuitBreaker;
import org.tikv.service.failsafe.CircuitBreakerImpl;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.txn.KVClient;
import org.tikv.txn.TxnKVClient;

public class TiSession
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TiSession.class);
    private static final Map<String, TiSession> sessionCachedMap = new HashMap<String, TiSession>();
    private final TiConfiguration conf;
    private final RequestKeyCodec keyCodec;
    private final ChannelFactory channelFactory;
    private volatile PDClient client;
    private volatile Catalog catalog;
    private volatile ExecutorService indexScanThreadPool;
    private volatile ExecutorService tableScanThreadPool;
    private volatile ExecutorService batchGetThreadPool;
    private volatile ExecutorService batchPutThreadPool;
    private volatile ExecutorService batchDeleteThreadPool;
    private volatile ExecutorService batchScanThreadPool;
    private volatile ExecutorService deleteRangeThreadPool;
    private volatile RegionManager regionManager;
    private final boolean enableGrpcForward;
    private volatile RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private volatile ImporterStoreClient.ImporterStoreClientBuilder importerClientBuilder;
    private volatile boolean isClosed = false;
    private volatile SwitchTiKVModeClient switchTiKVModeClient;
    private final MetricsServer metricsServer;
    private final CircuitBreaker circuitBreaker;
    private static final int MAX_SPLIT_REGION_STACK_DEPTH = 6;

    public TiSession(TiConfiguration conf) {
        this.metricsServer = MetricsServer.getInstance(conf);
        this.conf = conf;
        this.keyCodec = conf.getApiVersion().isV1() ? (conf.isRawKVMode() ? new RequestKeyV1RawCodec() : new RequestKeyV1TxnCodec()) : (conf.isRawKVMode() ? new RequestKeyV2RawCodec() : new RequestKeyV2TxnCodec());
        this.channelFactory = conf.isTlsEnable() ? (conf.isJksEnable() ? new ChannelFactory(conf.getMaxFrameSize(), conf.getKeepaliveTime(), conf.getKeepaliveTimeout(), conf.getIdleTimeout(), conf.getConnRecycleTimeInSeconds(), conf.getCertReloadIntervalInSeconds(), conf.getJksKeyPath(), conf.getJksKeyPassword(), conf.getJksTrustPath(), conf.getJksTrustPassword()) : new ChannelFactory(conf.getMaxFrameSize(), conf.getKeepaliveTime(), conf.getKeepaliveTimeout(), conf.getIdleTimeout(), conf.getConnRecycleTimeInSeconds(), conf.getCertReloadIntervalInSeconds(), conf.getTrustCertCollectionFile(), conf.getKeyCertChainFile(), conf.getKeyFile())) : new ChannelFactory(conf.getMaxFrameSize(), conf.getKeepaliveTime(), conf.getKeepaliveTimeout(), conf.getIdleTimeout());
        this.client = PDClient.createRaw(conf, this.keyCodec, this.channelFactory);
        if (conf.getApiVersion().isV2() && !StoreVersion.minTiKVVersion("6.1.0", this.client)) {
            throw new IllegalStateException("With API v2, store versions should not older than 6.1.0");
        }
        this.enableGrpcForward = conf.getEnableGrpcForward();
        if (this.enableGrpcForward) {
            logger.info("enable grpc forward for high available");
        }
        if (conf.isWarmUpEnable() && conf.isRawKVMode()) {
            this.warmUp();
        }
        this.circuitBreaker = new CircuitBreakerImpl(conf, this.client.getClusterId());
        logger.info("TiSession initialized in " + (Object)((Object)conf.getKvMode()) + " mode in API version: " + (Object)((Object)conf.getApiVersion()));
    }

    private static VersionInfo getVersionInfo() {
        VersionInfo info;
        try {
            Properties properties = new Properties();
            properties.load(TiSession.class.getClassLoader().getResourceAsStream("git.properties"));
            String version = properties.getProperty("git.build.version");
            String commitHash = properties.getProperty("git.commit.id.full");
            info = new VersionInfo(version, commitHash);
        }
        catch (Exception e) {
            logger.info("Fail to read package info: " + e.getMessage());
            info = new VersionInfo("unknown", "unknown");
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public synchronized void warmUp() {
        long warmUpStartTime = System.nanoTime();
        ConcreteBackOffer backOffer = ConcreteBackOffer.newRawKVBackOff(this.getPDClient().getClusterId());
        try {
            List<Pdpb.Region> regions;
            Errorpb.Error.newBuilder().setNotLeader(Errorpb.NotLeader.newBuilder().build()).build();
            this.client = this.getPDClient();
            this.regionManager = this.getRegionManager();
            List<Metapb.Store> stores = this.client.getAllStores(backOffer);
            for (Metapb.Store store : stores) {
                this.regionManager.updateStore(null, new TiStore(this.client.getStore(backOffer, store.getId())));
            }
            ByteString startKey = ByteString.EMPTY;
            while ((regions = this.regionManager.scanRegions(backOffer, startKey, ByteString.EMPTY, this.conf.getScanRegionsLimit())) != null && !regions.isEmpty()) {
                for (Pdpb.Region region : regions) {
                    this.regionManager.insertRegionToCache(this.regionManager.createRegion(region.getRegion(), backOffer));
                }
                startKey = regions.get(regions.size() - 1).getRegion().getEndKey();
                if (!startKey.isEmpty()) continue;
            }
            RawKVClient rawKVClient = this.createRawClient();
            Object object = null;
            try {
                ByteString exampleKey = ByteString.EMPTY;
                Optional<ByteString> prev = rawKVClient.get(exampleKey);
                if (prev.isPresent()) {
                    rawKVClient.delete(exampleKey);
                    rawKVClient.putIfAbsent(exampleKey, prev.get());
                    rawKVClient.put(exampleKey, prev.get());
                } else {
                    rawKVClient.putIfAbsent(exampleKey, ByteString.EMPTY);
                    rawKVClient.put(exampleKey, ByteString.EMPTY);
                    rawKVClient.delete(exampleKey);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rawKVClient != null) {
                    if (object != null) {
                        try {
                            rawKVClient.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rawKVClient.close();
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                logger.info("warm up fails, ignored ", (Throwable)e);
            }
            catch (Throwable throwable) {
                logger.info(String.format("warm up duration %d ms", (System.nanoTime() - warmUpStartTime) / 1000000L));
                throw throwable;
            }
            logger.info(String.format("warm up duration %d ms", (System.nanoTime() - warmUpStartTime) / 1000000L));
        }
        logger.info(String.format("warm up duration %d ms", (System.nanoTime() - warmUpStartTime) / 1000000L));
    }

    @VisibleForTesting
    public static TiSession create(TiConfiguration conf) {
        return new TiSession(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static TiSession getInstance(TiConfiguration conf) {
        Map<String, TiSession> map = sessionCachedMap;
        synchronized (map) {
            String key = conf.getPdAddrsString();
            if (sessionCachedMap.containsKey(key)) {
                return sessionCachedMap.get(key);
            }
            TiSession newSession = new TiSession(conf);
            sessionCachedMap.put(key, newSession);
            return newSession;
        }
    }

    public RawKVClient createRawClient() {
        this.checkIsClosed();
        return new RawKVClient(this, this.getRegionStoreClientBuilder());
    }

    public SmartRawKVClient createSmartRawClient() {
        RawKVClient rawKVClient = this.createRawClient();
        return new SmartRawKVClient(rawKVClient, this.circuitBreaker);
    }

    public KVClient createKVClient() {
        this.checkIsClosed();
        return new KVClient(this.conf, this.getRegionStoreClientBuilder(), this);
    }

    public TxnKVClient createTxnClient() {
        this.checkIsClosed();
        return new TxnKVClient(this.conf, this.getRegionStoreClientBuilder(), this.getPDClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionStoreClient.RegionStoreClientBuilder getRegionStoreClientBuilder() {
        this.checkIsClosed();
        if (this.clientBuilder != null) {
            return this.clientBuilder;
        }
        TiSession tiSession = this;
        synchronized (tiSession) {
            if (this.clientBuilder == null) {
                this.clientBuilder = new RegionStoreClient.RegionStoreClientBuilder(this.conf, this.channelFactory, this.getRegionManager(), this.getPDClient());
            }
        }
        return this.clientBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImporterStoreClient.ImporterStoreClientBuilder getImporterRegionStoreClientBuilder() {
        this.checkIsClosed();
        ImporterStoreClient.ImporterStoreClientBuilder res = this.importerClientBuilder;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.importerClientBuilder == null) {
                    this.importerClientBuilder = this.conf.isTxnKVMode() ? new ImporterStoreClient.ImporterStoreClientBuilder(this.conf, this.channelFactory, this.getRegionManager(), this.getPDClient()) : new ImporterStoreClient.ImporterStoreClientBuilder(this.conf, this.channelFactory, this.getRegionManager(), this.getPDClient());
                }
                res = this.importerClientBuilder;
            }
        }
        return res;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public TiTimestamp getTimestamp() {
        this.checkIsClosed();
        return this.getPDClient().getTimestamp(ConcreteBackOffer.newTsoBackOff(this.getPDClient().getClusterId()));
    }

    public Snapshot createSnapshot() {
        this.checkIsClosed();
        return new Snapshot(this.getTimestamp(), this);
    }

    public Snapshot createSnapshot(TiTimestamp ts) {
        this.checkIsClosed();
        return new Snapshot(ts, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDClient getPDClient() {
        this.checkIsClosed();
        PDClient res = this.client;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.client == null) {
                    this.client = PDClient.createRaw(this.getConf(), this.keyCodec, this.channelFactory);
                }
                res = this.client;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Catalog getCatalog() {
        this.checkIsClosed();
        Catalog res = this.catalog;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.catalog == null) {
                    this.catalog = new Catalog(this::createSnapshot, this.conf.ifShowRowId(), this.conf.getDBPrefix());
                }
                res = this.catalog;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionManager getRegionManager() {
        this.checkIsClosed();
        RegionManager res = this.regionManager;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.regionManager == null) {
                    this.regionManager = new RegionManager(this.getConf(), (ReadOnlyPDClient)this.getPDClient(), this.channelFactory);
                }
                res = this.regionManager;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForIndexScan() {
        this.checkIsClosed();
        ExecutorService res = this.indexScanThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.indexScanThreadPool == null) {
                    this.indexScanThreadPool = Executors.newFixedThreadPool(this.conf.getIndexScanConcurrency(), new ThreadFactoryBuilder().setNameFormat("index-scan-pool-%d").setDaemon(true).build());
                }
                res = this.indexScanThreadPool;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForTableScan() {
        this.checkIsClosed();
        ExecutorService res = this.tableScanThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.tableScanThreadPool == null) {
                    this.tableScanThreadPool = Executors.newFixedThreadPool(this.conf.getTableScanConcurrency(), new ThreadFactoryBuilder().setDaemon(true).build());
                }
                res = this.tableScanThreadPool;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForBatchPut() {
        this.checkIsClosed();
        ExecutorService res = this.batchPutThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.batchPutThreadPool == null) {
                    this.batchPutThreadPool = Executors.newFixedThreadPool(this.conf.getBatchPutConcurrency(), new ThreadFactoryBuilder().setNameFormat("batchPut-thread-%d").setDaemon(true).build());
                }
                res = this.batchPutThreadPool;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForBatchGet() {
        this.checkIsClosed();
        ExecutorService res = this.batchGetThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.batchGetThreadPool == null) {
                    this.batchGetThreadPool = Executors.newFixedThreadPool(this.conf.getBatchGetConcurrency(), new ThreadFactoryBuilder().setNameFormat("batchGet-thread-%d").setDaemon(true).build());
                }
                res = this.batchGetThreadPool;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForBatchDelete() {
        this.checkIsClosed();
        ExecutorService res = this.batchDeleteThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.batchDeleteThreadPool == null) {
                    this.batchDeleteThreadPool = Executors.newFixedThreadPool(this.conf.getBatchDeleteConcurrency(), new ThreadFactoryBuilder().setNameFormat("batchDelete-thread-%d").setDaemon(true).build());
                }
                res = this.batchDeleteThreadPool;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForBatchScan() {
        this.checkIsClosed();
        ExecutorService res = this.batchScanThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.batchScanThreadPool == null) {
                    this.batchScanThreadPool = Executors.newFixedThreadPool(this.conf.getBatchScanConcurrency(), new ThreadFactoryBuilder().setNameFormat("batchScan-thread-%d").setDaemon(true).build());
                }
                res = this.batchScanThreadPool;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForDeleteRange() {
        this.checkIsClosed();
        ExecutorService res = this.deleteRangeThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.deleteRangeThreadPool == null) {
                    this.deleteRangeThreadPool = Executors.newFixedThreadPool(this.conf.getDeleteRangeConcurrency(), new ThreadFactoryBuilder().setNameFormat("deleteRange-thread-%d").setDaemon(true).build());
                }
                res = this.deleteRangeThreadPool;
            }
        }
        return res;
    }

    @VisibleForTesting
    public ChannelFactory getChannelFactory() {
        this.checkIsClosed();
        return this.channelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchTiKVModeClient getSwitchTiKVModeClient() {
        this.checkIsClosed();
        SwitchTiKVModeClient res = this.switchTiKVModeClient;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.switchTiKVModeClient == null) {
                    this.switchTiKVModeClient = new SwitchTiKVModeClient(this.getPDClient(), this.getImporterRegionStoreClientBuilder());
                }
                res = this.switchTiKVModeClient;
            }
        }
        return res;
    }

    public void splitRegionAndScatter(List<byte[]> splitKeys, int splitRegionBackoffMS, int scatterRegionBackoffMS, int scatterWaitMS) {
        this.checkIsClosed();
        logger.info(String.format("split key's size is %d", splitKeys.size()));
        long startMS = System.currentTimeMillis();
        List<Metapb.Region> newRegions = this.splitRegion(splitKeys.stream().map(k -> Key.toRawKey(k).toByteString()).collect(Collectors.toList()), ConcreteBackOffer.newCustomBackOff(splitRegionBackoffMS, this.getPDClient().getClusterId()));
        for (Metapb.Region newRegion : newRegions) {
            try {
                this.getPDClient().scatterRegion(newRegion, ConcreteBackOffer.newCustomBackOff(scatterRegionBackoffMS, this.getPDClient().getClusterId()));
            }
            catch (Exception e) {
                logger.warn(String.format("failed to scatter region: %d", newRegion.getId()), (Throwable)e);
            }
        }
        if (scatterWaitMS > 0) {
            logger.info("start to wait scatter region finish");
            long scatterRegionStartMS = System.currentTimeMillis();
            for (Metapb.Region newRegion : newRegions) {
                long remainMS = scatterRegionStartMS + (long)scatterWaitMS - System.currentTimeMillis();
                if (remainMS <= 0L) {
                    logger.warn("wait scatter region timeout");
                    return;
                }
                this.getPDClient().waitScatterRegionFinish(newRegion, ConcreteBackOffer.newCustomBackOff((int)remainMS, this.getPDClient().getClusterId()));
            }
        } else {
            logger.info("skip to wait scatter region finish");
        }
        long endMS = System.currentTimeMillis();
        logger.info("splitRegionAndScatter cost {} seconds", (Object)((endMS - startMS) / 1000L));
    }

    public void splitRegionAndScatter(List<byte[]> splitKeys) {
        this.checkIsClosed();
        int splitRegionBackoffMS = 12000;
        int scatterRegionBackoffMS = 30000;
        int scatterWaitMS = this.conf.getScatterWaitSeconds() * 1000;
        this.splitRegionAndScatter(splitKeys, splitRegionBackoffMS, scatterRegionBackoffMS, scatterWaitMS);
    }

    private List<Metapb.Region> splitRegion(List<ByteString> splitKeys, BackOffer backOffer) {
        return this.splitRegion(splitKeys, backOffer, 1);
    }

    private List<Metapb.Region> splitRegion(List<ByteString> splitKeys, BackOffer backOffer, int depth) {
        ArrayList<Metapb.Region> regions = new ArrayList<Metapb.Region>();
        Map<TiRegion, List<ByteString>> groupKeys = ClientUtils.groupKeysByRegion(this.getRegionManager(), splitKeys, backOffer);
        for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
            List<Metapb.Region> newRegions;
            Pair<TiRegion, TiStore> pair = this.getRegionManager().getRegionStorePairByKey(entry.getKey().getStartKey());
            TiRegion region = (TiRegion)pair.first;
            TiStore store = (TiStore)pair.second;
            List<ByteString> splits = entry.getValue().stream().filter(k -> !k.equals(region.getStartKey()) && !k.equals(region.getEndKey())).collect(Collectors.toList());
            if (splits.isEmpty()) {
                logger.warn("split key equal to region start key or end key. Region splitting is not needed.");
                continue;
            }
            logger.info("start to split region id={}, split size={}", (Object)region.getId(), (Object)splits.size());
            try {
                newRegions = this.getRegionStoreClientBuilder().build(region, store).splitRegion(splits);
                this.getRegionManager().invalidateRegion(region);
            }
            catch (TiKVException e) {
                logger.warn("ReSplitting ranges for splitRegion", (Throwable)e);
                this.getRegionManager().invalidateRegion(region);
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                if (depth >= 6) {
                    logger.warn(String.format("Skip split region because MAX_SPLIT_REGION_STACK_DEPTH(%d) reached!", 6));
                    newRegions = new ArrayList<Metapb.Region>();
                }
                newRegions = this.splitRegion(splits, backOffer, depth + 1);
            }
            logger.info("region id={}, new region size={}", (Object)region.getId(), (Object)newRegions.size());
            regions.addAll(newRegions);
        }
        logger.info("splitRegion: return region size={}", (Object)regions.size());
        return regions;
    }

    private void checkIsClosed() {
        if (this.isClosed) {
            throw new RuntimeException("this TiSession is closed!");
        }
    }

    public synchronized void closeAwaitTermination(long timeoutMS) throws Exception {
        this.shutdown(false);
        long startMS = System.currentTimeMillis();
        while (true) {
            if (this.isTerminatedExecutorServices()) {
                this.cleanAfterTerminated();
                return;
            }
            if (System.currentTimeMillis() - startMS > timeoutMS) {
                this.shutdown(true);
                return;
            }
            Thread.sleep(500L);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shutdown(boolean now) throws Exception {
        if (!this.isClosed) {
            this.isClosed = true;
            Map<String, TiSession> map = sessionCachedMap;
            synchronized (map) {
                sessionCachedMap.remove(this.conf.getPdAddrsString());
            }
            if (this.metricsServer != null) {
                this.metricsServer.close();
            }
            if (this.circuitBreaker != null) {
                this.circuitBreaker.close();
            }
        }
        if (now) {
            this.shutdownNowExecutorServices();
            this.cleanAfterTerminated();
        } else {
            this.shutdownExecutorServices();
        }
    }

    private synchronized void cleanAfterTerminated() throws InterruptedException {
        if (this.regionManager != null) {
            this.regionManager.close();
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.catalog != null) {
            this.catalog.close();
        }
        if (this.switchTiKVModeClient != null) {
            this.switchTiKVModeClient.stopKeepTiKVToImportMode();
        }
    }

    private List<ExecutorService> getExecutorServices() {
        ArrayList<ExecutorService> executorServiceList = new ArrayList<ExecutorService>();
        if (this.tableScanThreadPool != null) {
            executorServiceList.add(this.tableScanThreadPool);
        }
        if (this.indexScanThreadPool != null) {
            executorServiceList.add(this.indexScanThreadPool);
        }
        if (this.batchGetThreadPool != null) {
            executorServiceList.add(this.batchGetThreadPool);
        }
        if (this.batchPutThreadPool != null) {
            executorServiceList.add(this.batchPutThreadPool);
        }
        if (this.batchDeleteThreadPool != null) {
            executorServiceList.add(this.batchDeleteThreadPool);
        }
        if (this.batchScanThreadPool != null) {
            executorServiceList.add(this.batchScanThreadPool);
        }
        if (this.deleteRangeThreadPool != null) {
            executorServiceList.add(this.deleteRangeThreadPool);
        }
        return executorServiceList;
    }

    private void shutdownExecutorServices() {
        for (ExecutorService executorService : this.getExecutorServices()) {
            executorService.shutdown();
        }
    }

    private void shutdownNowExecutorServices() {
        for (ExecutorService executorService : this.getExecutorServices()) {
            executorService.shutdownNow();
        }
    }

    private boolean isTerminatedExecutorServices() {
        for (ExecutorService executorService : this.getExecutorServices()) {
            if (executorService.isTerminated()) continue;
            return false;
        }
        return true;
    }

    static {
        logger.info("Welcome to TiKV Java Client {}", (Object)TiSession.getVersionInfo());
    }

    private static class VersionInfo {
        private final String buildVersion;
        private final String commitHash;

        public VersionInfo(String buildVersion, String commitHash) {
            this.buildVersion = buildVersion;
            this.commitHash = commitHash;
        }

        public String toString() {
            return this.buildVersion + "@" + this.commitHash;
        }
    }
}

