/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.jcl;

import org.apache.commons.logging.Log;
import org.tinylog.Level;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public final class TinylogLog
implements Log {
    private static final int STACKTRACE_DEPTH = 2;
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final boolean MINIMUM_LEVEL_COVERS_TRACE = TinylogLog.isCoveredByMinimumLevel(Level.TRACE);
    private static final boolean MINIMUM_LEVEL_COVERS_DEBUG = TinylogLog.isCoveredByMinimumLevel(Level.DEBUG);
    private static final boolean MINIMUM_LEVEL_COVERS_INFO = TinylogLog.isCoveredByMinimumLevel(Level.INFO);
    private static final boolean MINIMUM_LEVEL_COVERS_WARN = TinylogLog.isCoveredByMinimumLevel(Level.WARN);
    private static final boolean MINIMUM_LEVEL_COVERS_ERROR = TinylogLog.isCoveredByMinimumLevel(Level.ERROR);

    TinylogLog() {
    }

    public boolean isTraceEnabled() {
        return MINIMUM_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE);
    }

    public void trace(Object message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, message, new Object[0]);
        }
    }

    public void trace(Object message, Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, message == exception ? null : message, new Object[0]);
        }
    }

    public boolean isDebugEnabled() {
        return MINIMUM_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, Level.DEBUG);
    }

    public void debug(Object message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, message, new Object[0]);
        }
    }

    public void debug(Object message, Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, message == exception ? null : message, new Object[0]);
        }
    }

    public boolean isInfoEnabled() {
        return MINIMUM_LEVEL_COVERS_INFO && provider.isEnabled(2, null, Level.INFO);
    }

    public void info(Object message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, message, new Object[0]);
        }
    }

    public void info(Object message, Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, message == exception ? null : message, new Object[0]);
        }
    }

    public boolean isWarnEnabled() {
        return MINIMUM_LEVEL_COVERS_WARN && provider.isEnabled(2, null, Level.WARN);
    }

    public void warn(Object message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, message, new Object[0]);
        }
    }

    public void warn(Object message, Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, message == exception ? null : message, new Object[0]);
        }
    }

    public boolean isErrorEnabled() {
        return MINIMUM_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR);
    }

    public void error(Object message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, message, new Object[0]);
        }
    }

    public void error(Object message, Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, exception == message ? null : message, new Object[0]);
        }
    }

    public boolean isFatalEnabled() {
        return MINIMUM_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR);
    }

    public void fatal(Object message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, message, new Object[0]);
        }
    }

    public void fatal(Object message, Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, exception == message ? null : message, new Object[0]);
        }
    }

    private static boolean isCoveredByMinimumLevel(Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }
}

