/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.jsl;

import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.JavaTextMessageFormatFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public class TinylogLogger
implements System.Logger {
    private static final int STACKTRACE_DEPTH = 2;
    private static final int ENABLED_STACKTRACE_DEPTH = 3;
    private static final MessageFormatter MESSAGE_FORMATTER = new JavaTextMessageFormatFormatter(Configuration.getLocale());
    private static final LoggingProvider LOGGING_PROVIDER = ProviderRegistry.getLoggingProvider();
    private final String name;

    public TinylogLogger(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        Objects.requireNonNull(level);
        if (level == System.Logger.Level.OFF) {
            return false;
        }
        return LOGGING_PROVIDER.isEnabled(2, null, TinylogLogger.translate(level));
    }

    @Override
    public void log(System.Logger.Level level, String msg) {
        Objects.requireNonNull(level);
        if (this.enabled(level)) {
            LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), null, null, (Object)msg, (Object[])null);
        }
    }

    @Override
    public void log(System.Logger.Level level, Supplier<String> msgSupplier) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(msgSupplier);
        if (this.enabled(level)) {
            LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), null, null, msgSupplier, (Object[])null);
        }
    }

    @Override
    public void log(System.Logger.Level level, Object obj) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(obj);
        if (this.enabled(level)) {
            LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), null, null, obj, (Object[])null);
        }
    }

    @Override
    public void log(System.Logger.Level level, String msg, Throwable thrown) {
        Objects.requireNonNull(level);
        if (this.enabled(level)) {
            LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), thrown, null, (Object)msg, (Object[])null);
        }
    }

    @Override
    public void log(System.Logger.Level level, Supplier<String> msgSupplier, Throwable thrown) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(msgSupplier);
        if (this.enabled(level)) {
            LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), thrown, null, msgSupplier, (Object[])null);
        }
    }

    @Override
    public void log(System.Logger.Level level, String format, Object ... params) {
        Objects.requireNonNull(level);
        if (this.enabled(level)) {
            LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), null, MESSAGE_FORMATTER, (Object)format, params);
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        Objects.requireNonNull(level);
        if (this.enabled(level)) {
            if (bundle != null && msg != null) {
                LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), thrown, null, (Object)bundle.getString(msg), (Object[])null);
            } else {
                LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), thrown, null, (Object)msg, (Object[])null);
            }
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        Objects.requireNonNull(level);
        if (this.enabled(level)) {
            if (bundle != null && format != null) {
                LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), null, MESSAGE_FORMATTER, (Object)bundle.getString(format), params);
            } else {
                LOGGING_PROVIDER.log(2, null, TinylogLogger.translate(level), null, MESSAGE_FORMATTER, (Object)format, params);
            }
        }
    }

    private boolean enabled(System.Logger.Level level) {
        return level != System.Logger.Level.OFF && LOGGING_PROVIDER.isEnabled(3, null, TinylogLogger.translate(level));
    }

    private static Level translate(System.Logger.Level level) {
        switch (level) {
            case ALL: 
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unknown Java System.Logger severity level \"" + level + "\"");
    }
}

