/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.TinylogBridge;

public class Category {
    private final Category parent;
    private final String name;
    private volatile ResourceBundle bundle;

    Category(Category category, String string) {
        this.parent = category;
        this.name = string;
    }

    @Deprecated
    public static final Category getRoot() {
        return LogManager.getRootLogger();
    }

    @Deprecated
    public static Category getInstance(String string) {
        return LogManager.getLogger(string);
    }

    @Deprecated
    public static Category getInstance(Class clazz) {
        return LogManager.getLogger(clazz);
    }

    public final Category getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public final ResourceBundle getResourceBundle() {
        for (Category category = this; category != null; category = category.getParent()) {
            ResourceBundle resourceBundle = category.bundle;
            if (resourceBundle == null) continue;
            return resourceBundle;
        }
        return null;
    }

    public final void setResourceBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    @Deprecated
    public final Level getPriority() {
        return TinylogBridge.getLevel();
    }

    @Deprecated
    public Priority getChainedPriority() {
        return TinylogBridge.getLevel();
    }

    public final Level getLevel() {
        return TinylogBridge.getLevel();
    }

    public Level getEffectiveLevel() {
        return TinylogBridge.getLevel();
    }

    public boolean isDebugEnabled() {
        return TinylogBridge.isEnabled(Level.DEBUG);
    }

    public void debug(Object object) {
        TinylogBridge.log(Level.DEBUG, object);
    }

    public void debug(Object object, Throwable throwable) {
        TinylogBridge.log((Priority)Level.DEBUG, throwable, object == throwable ? null : object);
    }

    public boolean isInfoEnabled() {
        return TinylogBridge.isEnabled(Level.INFO);
    }

    public void info(Object object) {
        TinylogBridge.log(Level.INFO, object);
    }

    public void info(Object object, Throwable throwable) {
        TinylogBridge.log((Priority)Level.INFO, throwable, object == throwable ? null : object);
    }

    public void warn(Object object) {
        TinylogBridge.log(Level.WARN, object);
    }

    public void warn(Object object, Throwable throwable) {
        TinylogBridge.log((Priority)Level.WARN, throwable, object == throwable ? null : object);
    }

    public void error(Object object) {
        TinylogBridge.log(Level.ERROR, object);
    }

    public void error(Object object, Throwable throwable) {
        TinylogBridge.log((Priority)Level.ERROR, throwable, object == throwable ? null : object);
    }

    public void fatal(Object object) {
        TinylogBridge.log(Level.FATAL, object);
    }

    public void fatal(Object object, Throwable throwable) {
        TinylogBridge.log((Priority)Level.FATAL, throwable, object == throwable ? null : object);
    }

    public boolean isEnabledFor(Priority priority) {
        return TinylogBridge.isEnabled(priority);
    }

    public void assertLog(boolean bl, String string) {
        if (!bl) {
            TinylogBridge.log(Level.ERROR, string);
        }
    }

    public void log(Priority priority, Object object) {
        TinylogBridge.log(priority, object);
    }

    public void log(Priority priority, Object object, Throwable throwable) {
        TinylogBridge.log(priority, throwable, object == throwable ? null : object);
    }

    public void l7dlog(Priority priority, String string, Throwable throwable) {
        String string2 = this.getResourceBundleString(string);
        if (string2 == null) {
            string2 = string;
        }
        TinylogBridge.log(priority, throwable, (Object)string2);
    }

    public void l7dlog(Priority priority, String string, Object[] objectArray, Throwable throwable) {
        String string2 = this.getResourceBundleString(string);
        string2 = string2 == null ? string : MessageFormat.format(string2, objectArray);
        TinylogBridge.log(priority, throwable, (Object)string2);
    }

    protected final String getResourceBundleString(String string) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (resourceBundle == null) {
            return null;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

