/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.TinylogBridge;

public abstract class LogXF {
    protected LogXF() {
    }

    public static void entering(Logger logger, String string, String string2) {
        TinylogBridge.log(Level.DEBUG, string + "." + string2 + " ENTRY");
    }

    public static void entering(Logger logger, String string, String string2, String string3) {
        TinylogBridge.log(Level.DEBUG, string + "." + string2 + " ENTRY " + string3);
    }

    public static void entering(Logger logger, String string, String string2, Object object) {
        TinylogBridge.log(Level.DEBUG, string + "." + string2 + " ENTRY " + LogXF.toString(object));
    }

    public static void entering(Logger logger, String string, String string2, Object[] objectArray) {
        TinylogBridge.log(Level.DEBUG, string + "." + string2 + " ENTRY " + LogXF.toString(objectArray));
    }

    public static void exiting(Logger logger, String string, String string2) {
        TinylogBridge.log(Level.DEBUG, string + "." + string2 + " RETURN");
    }

    public static void exiting(Logger logger, String string, String string2, String string3) {
        TinylogBridge.log(Level.DEBUG, string + "." + string2 + " RETURN " + string3);
    }

    public static void exiting(Logger logger, String string, String string2, Object object) {
        TinylogBridge.log(Level.DEBUG, string + "." + string2 + " RETURN " + LogXF.toString(object));
    }

    public static void throwing(Logger logger, String string, String string2, Throwable throwable) {
        TinylogBridge.log((Priority)Level.DEBUG, throwable, (Object)(string + "." + string2 + " THROW"));
    }

    protected static String getResourceBundleString(String string, String string2) {
        if (string == null) {
            return string2;
        }
        try {
            return ResourceBundle.getBundle(string).getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(LogXF.toString(objectArray[i]));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            return object.toString();
        }
        catch (Throwable throwable) {
            return "?";
        }
    }
}

