/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.pmw.tinylog.EnvironmentHelper;
import org.pmw.tinylog.LogEntryForwarder;
import org.pmw.tinylog.Logger;
import org.pmw.tinylog.runtime.RuntimeDialect;

final class TinylogBridge {
    private static final RuntimeDialect runtime = EnvironmentHelper.getRuntimeDialect();

    private TinylogBridge() {
    }

    public static Level getLevel() {
        String string = runtime.getClassName(3);
        org.pmw.tinylog.Level level = Logger.getLevel((String)string);
        return TinylogBridge.toLog4jLevel(level);
    }

    public static Level getLevel(Class<?> clazz) {
        org.pmw.tinylog.Level level = Logger.getLevel((String)clazz.getName());
        return TinylogBridge.toLog4jLevel(level);
    }

    public static boolean isEnabled(Priority priority) {
        String string = runtime.getClassName(3);
        org.pmw.tinylog.Level level = Logger.getLevel((String)string);
        return level.ordinal() <= TinylogBridge.toTinylogLevel(priority).ordinal();
    }

    public static boolean isEnabled(Class<?> clazz, Priority priority) {
        org.pmw.tinylog.Level level = Logger.getLevel((String)clazz.getName());
        return level.ordinal() <= TinylogBridge.toTinylogLevel(priority).ordinal();
    }

    public static void log(Priority priority, Object object) {
        LogEntryForwarder.forward((int)2, (org.pmw.tinylog.Level)TinylogBridge.toTinylogLevel(priority), (Object)object);
    }

    public static void log(Priority priority, Throwable throwable, Object object) {
        LogEntryForwarder.forward((int)2, (org.pmw.tinylog.Level)TinylogBridge.toTinylogLevel(priority), (Throwable)throwable, (String)(object == null ? null : object.toString()), (Object[])new Object[0]);
    }

    public static void log(Priority priority, String string, Object ... objectArray) {
        LogEntryForwarder.forward((int)2, (org.pmw.tinylog.Level)TinylogBridge.toTinylogLevel(priority), (String)string, (Object[])objectArray);
    }

    public static void log(Priority priority, Throwable throwable, String string, Object ... objectArray) {
        LogEntryForwarder.forward((int)2, (org.pmw.tinylog.Level)TinylogBridge.toTinylogLevel(priority), (Throwable)throwable, (String)string, (Object[])objectArray);
    }

    private static org.pmw.tinylog.Level toTinylogLevel(Priority priority) {
        if (priority.isGreaterOrEqual(Level.OFF)) {
            return org.pmw.tinylog.Level.OFF;
        }
        if (priority.isGreaterOrEqual(Level.ERROR)) {
            return org.pmw.tinylog.Level.ERROR;
        }
        if (priority.isGreaterOrEqual(Level.WARN)) {
            return org.pmw.tinylog.Level.WARNING;
        }
        if (priority.isGreaterOrEqual(Level.INFO)) {
            return org.pmw.tinylog.Level.INFO;
        }
        if (priority.isGreaterOrEqual(Level.DEBUG)) {
            return org.pmw.tinylog.Level.DEBUG;
        }
        return org.pmw.tinylog.Level.TRACE;
    }

    private static Level toLog4jLevel(org.pmw.tinylog.Level level) {
        if (level.ordinal() >= org.pmw.tinylog.Level.OFF.ordinal()) {
            return Level.OFF;
        }
        if (level.ordinal() >= org.pmw.tinylog.Level.ERROR.ordinal()) {
            return Level.ERROR;
        }
        if (level.ordinal() >= org.pmw.tinylog.Level.WARNING.ordinal()) {
            return Level.WARN;
        }
        if (level.ordinal() >= org.pmw.tinylog.Level.INFO.ordinal()) {
            return Level.INFO;
        }
        if (level.ordinal() >= org.pmw.tinylog.Level.DEBUG.ordinal()) {
            return Level.DEBUG;
        }
        return Level.TRACE;
    }
}

