/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public class Category {
    protected static final int STACKTRACE_DEPTH = 2;
    protected static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final boolean MINIMUM_LEVEL_COVERS_DEBUG = Category.isCoveredByMinimumLevel(org.tinylog.Level.DEBUG);
    private static final boolean MINIMUM_LEVEL_COVERS_INFO = Category.isCoveredByMinimumLevel(org.tinylog.Level.INFO);
    private static final boolean MINIMUM_LEVEL_COVERS_WARN = Category.isCoveredByMinimumLevel(org.tinylog.Level.WARN);
    private static final boolean MINIMUM_LEVEL_COVERS_ERROR = Category.isCoveredByMinimumLevel(org.tinylog.Level.ERROR);
    private final Category parent;
    private final String name;
    private volatile ResourceBundle bundle;

    Category(Category parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    protected Category(String name) {
        this(LogManager.getParentLogger(name), name);
    }

    public void addAppender(Appender newAppender) {
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion && MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, null, (Object)msg, (Object[])null);
        }
    }

    public void callAppenders(LoggingEvent event) {
    }

    public void debug(Object message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, null, null, message, (Object[])null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, t, null, message == t ? null : message, (Object[])null);
        }
    }

    public void error(Object message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, null, message, (Object[])null);
        }
    }

    public void error(Object message, Throwable t) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, t, null, message == t ? null : message, (Object[])null);
        }
    }

    @Deprecated
    public static Logger exists(String name) {
        return LogManager.exists(name);
    }

    public void fatal(Object message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, null, message, (Object[])null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, t, null, message == t ? null : message, (Object[])null);
        }
    }

    protected void forcedLog(String fqcn, Priority level, Object message, Throwable t) {
        provider.log(fqcn, null, Category.translatePriority(level), t, null, message == t ? null : message, (Object[])null);
    }

    public boolean getAdditivity() {
        return true;
    }

    public Enumeration getAllAppenders() {
        return Collections.emptyEnumeration();
    }

    public Appender getAppender(String name) {
        return null;
    }

    public Level getEffectiveLevel() {
        return Category.translateLevel(provider.getMinimumLevel(null));
    }

    @Deprecated
    public Priority getChainedPriority() {
        return Category.translateLevel(provider.getMinimumLevel(null));
    }

    @Deprecated
    public static Enumeration getCurrentCategories() {
        return LogManager.getCurrentLoggers();
    }

    @Deprecated
    public static Category getInstance(String name) {
        return LogManager.getLogger(name);
    }

    @Deprecated
    public static Category getInstance(Class clazz) {
        return LogManager.getLogger(clazz);
    }

    public final String getName() {
        return this.name;
    }

    public final Category getParent() {
        return this.parent;
    }

    public final Level getLevel() {
        return Category.translateLevel(provider.getMinimumLevel(null));
    }

    @Deprecated
    public final Level getPriority() {
        return Category.translateLevel(provider.getMinimumLevel(null));
    }

    @Deprecated
    public static final Category getRoot() {
        return LogManager.getRootLogger();
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public void info(Object message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, null, null, message, (Object[])null);
        }
    }

    public void info(Object message, Throwable t) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, t, null, message == t ? null : message, (Object[])null);
        }
    }

    public boolean isAttached(Appender appender) {
        return false;
    }

    public boolean isDebugEnabled() {
        return MINIMUM_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, org.tinylog.Level.DEBUG);
    }

    public boolean isEnabledFor(Priority level) {
        return provider.isEnabled(2, null, Category.translatePriority(level));
    }

    public boolean isInfoEnabled() {
        return MINIMUM_LEVEL_COVERS_INFO && provider.isEnabled(2, null, org.tinylog.Level.INFO);
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        ResourceBundle bundle = this.bundle;
        String message = bundle == null ? key : bundle.getString(key);
        provider.log(2, null, Category.translatePriority(priority), t, null, (Object)message, (Object[])null);
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        ResourceBundle bundle = this.bundle;
        String message = bundle == null ? key : MessageFormat.format(bundle.getString(key), params);
        provider.log(2, null, Category.translatePriority(priority), t, null, (Object)message, (Object[])null);
    }

    public void log(Priority priority, Object message, Throwable t) {
        provider.log(2, null, Category.translatePriority(priority), t, null, message == t ? null : message, (Object[])null);
    }

    public void log(Priority priority, Object message) {
        provider.log(2, null, Category.translatePriority(priority), null, null, message, (Object[])null);
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        provider.log(callerFQCN, null, Category.translatePriority(level), t, null, message == t ? null : message, (Object[])null);
    }

    public void removeAllAppenders() {
    }

    public void removeAppender(Appender appender) {
    }

    public void removeAppender(String name) {
    }

    public void setAdditivity(boolean additive) {
    }

    public void setLevel(Level level) {
    }

    @Deprecated
    public void setPriority(Priority priority) {
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Deprecated
    public static void shutdown() {
        LogManager.shutdown();
    }

    public void warn(Object message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, null, null, message, (Object[])null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, t, null, message == t ? null : message, (Object[])null);
        }
    }

    protected static boolean isCoveredByMinimumLevel(org.tinylog.Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }

    private static org.tinylog.Level translatePriority(Priority priority) {
        if (priority.isGreaterOrEqual(Level.ERROR)) {
            return org.tinylog.Level.ERROR;
        }
        if (priority.isGreaterOrEqual(Level.WARN)) {
            return org.tinylog.Level.WARN;
        }
        if (priority.isGreaterOrEqual(Level.INFO)) {
            return org.tinylog.Level.INFO;
        }
        if (priority.isGreaterOrEqual(Level.DEBUG)) {
            return org.tinylog.Level.DEBUG;
        }
        return org.tinylog.Level.TRACE;
    }

    private static Level translateLevel(org.tinylog.Level level) {
        switch (level) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unknown tinylog 2 severity level \"" + level + "\"");
    }
}

