/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class LogManager {
    private static final Logger root = new Logger(null, "root");
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static final Object mutex = new Object();

    public static Logger getRootLogger() {
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Object object = mutex;
        synchronized (object) {
            return LogManager.getOrCreateLogger(name);
        }
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return LogManager.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return LogManager.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger exists(String name) {
        Object object = mutex;
        synchronized (object) {
            return loggers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getCurrentLoggers() {
        ArrayList<Logger> copy;
        Object object = mutex;
        synchronized (object) {
            copy = new ArrayList<Logger>(loggers.values());
        }
        copy.remove(root);
        return Collections.enumeration(copy);
    }

    public static void shutdown() {
    }

    public static void resetConfiguration() {
    }

    static Logger getParentLogger(String name) {
        return LogManager.getLogger(LogManager.reduce(name));
    }

    private static Logger getOrCreateLogger(String name) {
        if (name == null || name.length() == 0) {
            return root;
        }
        Logger logger = loggers.get(name);
        if (logger == null) {
            Logger parent = LogManager.getOrCreateLogger(LogManager.reduce(name));
            logger = new Logger(parent, name);
            loggers.put(name, logger);
        }
        return logger;
    }

    private static String reduce(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? null : name.substring(0, index);
    }

    static {
        loggers.put(root.getName(), root);
    }
}

