/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog;

import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public final class TaggedLogger {
    private static final int STACKTRACE_DEPTH = 2;
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private final boolean minimumLevelCoversTrace;
    private final boolean minimumLevelCoversDebug;
    private final boolean minimumLevelCoversInfo;
    private final boolean minimumLevelCoversWarn;
    private final boolean minimumLevelCoversError;
    private final String tag;

    TaggedLogger(String tag) {
        this.tag = tag;
        this.minimumLevelCoversTrace = TaggedLogger.isCoveredByMinimumLevel(tag, Level.TRACE);
        this.minimumLevelCoversDebug = TaggedLogger.isCoveredByMinimumLevel(tag, Level.DEBUG);
        this.minimumLevelCoversInfo = TaggedLogger.isCoveredByMinimumLevel(tag, Level.INFO);
        this.minimumLevelCoversWarn = TaggedLogger.isCoveredByMinimumLevel(tag, Level.WARN);
        this.minimumLevelCoversError = TaggedLogger.isCoveredByMinimumLevel(tag, Level.ERROR);
    }

    public boolean isTraceEnabled() {
        return this.minimumLevelCoversTrace && provider.isEnabled(2, this.tag, Level.TRACE);
    }

    public void trace(Object message) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, null, message, (Object[])null);
        }
    }

    public void trace(Supplier<?> message) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, null, message, (Object[])null);
        }
    }

    public void trace(String message, Object ... arguments) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, null, (Object)message, arguments);
        }
    }

    public void trace(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, null, (Object)message, (Object[])arguments);
        }
    }

    public void trace(Throwable exception) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, exception, null, (Object[])null);
        }
    }

    public void trace(Throwable exception, String message) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, exception, (Object)message, (Object[])null);
        }
    }

    public void trace(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, exception, message, (Object[])null);
        }
    }

    public void trace(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, exception, (Object)message, arguments);
        }
    }

    public void trace(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversTrace) {
            provider.log(2, this.tag, Level.TRACE, exception, (Object)message, (Object[])arguments);
        }
    }

    public boolean isDebugEnabled() {
        return this.minimumLevelCoversDebug && provider.isEnabled(2, this.tag, Level.DEBUG);
    }

    public void debug(Object message) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, null, message, (Object[])null);
        }
    }

    public void debug(Supplier<?> message) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, null, message, (Object[])null);
        }
    }

    public void debug(String message, Object ... arguments) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, null, (Object)message, arguments);
        }
    }

    public void debug(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, null, (Object)message, (Object[])arguments);
        }
    }

    public void debug(Throwable exception) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, exception, null, (Object[])null);
        }
    }

    public void debug(Throwable exception, String message) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, exception, (Object)message, (Object[])null);
        }
    }

    public void debug(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, exception, message, (Object[])null);
        }
    }

    public void debug(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, exception, (Object)message, arguments);
        }
    }

    public void debug(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversDebug) {
            provider.log(2, this.tag, Level.DEBUG, exception, (Object)message, (Object[])arguments);
        }
    }

    public boolean isInfoEnabled() {
        return this.minimumLevelCoversInfo && provider.isEnabled(2, this.tag, Level.INFO);
    }

    public void info(Object message) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, null, message, (Object[])null);
        }
    }

    public void info(Supplier<?> message) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, null, message, (Object[])null);
        }
    }

    public void info(String message, Object ... arguments) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, null, (Object)message, arguments);
        }
    }

    public void info(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, null, (Object)message, (Object[])arguments);
        }
    }

    public void info(Throwable exception) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, exception, null, (Object[])null);
        }
    }

    public void info(Throwable exception, String message) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, exception, (Object)message, (Object[])null);
        }
    }

    public void info(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, exception, message, (Object[])null);
        }
    }

    public void info(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, exception, (Object)message, arguments);
        }
    }

    public void info(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversInfo) {
            provider.log(2, this.tag, Level.INFO, exception, (Object)message, (Object[])arguments);
        }
    }

    public boolean isWarnEnabled() {
        return this.minimumLevelCoversWarn && provider.isEnabled(2, this.tag, Level.WARN);
    }

    public void warn(Object message) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, null, message, (Object[])null);
        }
    }

    public void warn(Supplier<?> message) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, null, message, (Object[])null);
        }
    }

    public void warn(String message, Object ... arguments) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, null, (Object)message, arguments);
        }
    }

    public void warn(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, null, (Object)message, (Object[])arguments);
        }
    }

    public void warn(Throwable exception) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, exception, null, (Object[])null);
        }
    }

    public void warn(Throwable exception, String message) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, exception, (Object)message, (Object[])null);
        }
    }

    public void warn(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, exception, message, (Object[])null);
        }
    }

    public void warn(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, exception, (Object)message, arguments);
        }
    }

    public void warn(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversWarn) {
            provider.log(2, this.tag, Level.WARN, exception, (Object)message, (Object[])arguments);
        }
    }

    public boolean isErrorEnabled() {
        return this.minimumLevelCoversError && provider.isEnabled(2, this.tag, Level.ERROR);
    }

    public void error(Object message) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, null, message, (Object[])null);
        }
    }

    public void error(Supplier<?> message) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, null, message, (Object[])null);
        }
    }

    public void error(String message, Object ... arguments) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, null, (Object)message, arguments);
        }
    }

    public void error(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, null, (Object)message, (Object[])arguments);
        }
    }

    public void error(Throwable exception) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, exception, null, (Object[])null);
        }
    }

    public void error(Throwable exception, String message) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, exception, (Object)message, (Object[])null);
        }
    }

    public void error(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, exception, message, (Object[])null);
        }
    }

    public void error(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, exception, (Object)message, arguments);
        }
    }

    public void error(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversError) {
            provider.log(2, this.tag, Level.ERROR, exception, (Object)message, (Object[])arguments);
        }
    }

    private static boolean isCoveredByMinimumLevel(String tag, Level level) {
        return provider.getMinimumLevel(tag).ordinal() <= level.ordinal();
    }
}

